/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.BaseKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.PathElement;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.PartitionId;
import java.util.List;

public class IncompleteKey
extends BaseKey {
    private static final long serialVersionUID = 4947014765344279019L;

    IncompleteKey(String projectId, String namespace, ImmutableList<PathElement> path) {
        super(projectId, namespace, path);
    }

    static IncompleteKey fromPb(com.google.datastore.v1.Key keyPb) {
        List pathElementsPb;
        String projectId = "";
        String namespace = "";
        if (keyPb.hasPartitionId()) {
            PartitionId partitionIdPb = keyPb.getPartitionId();
            projectId = partitionIdPb.getProjectId();
            namespace = partitionIdPb.getNamespaceId();
        }
        Preconditions.checkArgument((!(pathElementsPb = keyPb.getPathList()).isEmpty() ? 1 : 0) != 0, (Object)"Path must not be empty");
        ImmutableList.Builder pathBuilder = ImmutableList.builder();
        for (Key.PathElement pathElementPb : pathElementsPb) {
            pathBuilder.add((Object)PathElement.fromPb(pathElementPb));
        }
        ImmutableList path = pathBuilder.build();
        PathElement leaf = (PathElement)path.get(path.size() - 1);
        if (leaf.getNameOrId() != null) {
            return new Key(projectId, namespace, (ImmutableList<PathElement>)path);
        }
        return new IncompleteKey(projectId, namespace, (ImmutableList<PathElement>)path);
    }

    @Override
    @Deprecated
    public Key parent() {
        return this.getParent();
    }

    @Override
    public Key getParent() {
        List<PathElement> ancestors = this.getAncestors();
        if (ancestors.isEmpty()) {
            return null;
        }
        PathElement parent = ancestors.get(ancestors.size() - 1);
        Key.Builder keyBuilder = parent.hasName() ? Key.newBuilder(this.getProjectId(), parent.getKind(), parent.getName()) : Key.newBuilder(this.getProjectId(), parent.getKind(), (long)parent.getId());
        String namespace = this.getNamespace();
        if (namespace != null) {
            keyBuilder.setNamespace(namespace);
        }
        return ((Key.Builder)keyBuilder.addAncestors(ancestors.subList(0, ancestors.size() - 1))).build();
    }

    @Deprecated
    public static Builder builder(String projectId, String kind) {
        return IncompleteKey.newBuilder(projectId, kind);
    }

    public static Builder newBuilder(String projectId, String kind) {
        return new Builder(projectId, kind);
    }

    @Deprecated
    public static Builder builder(IncompleteKey copyFrom) {
        return IncompleteKey.newBuilder(copyFrom);
    }

    public static Builder newBuilder(IncompleteKey copyFrom) {
        return new Builder(copyFrom);
    }

    @Deprecated
    public static Builder builder(Key parent, String kind) {
        return IncompleteKey.newBuilder(parent, kind);
    }

    public static Builder newBuilder(Key parent, String kind) {
        return (Builder)((Builder)IncompleteKey.newBuilder(parent.getProjectId(), kind).setNamespace(parent.getNamespace())).addAncestors(parent.getPath());
    }

    public static class Builder
    extends BaseKey.Builder<Builder> {
        private Builder(String projectId, String kind) {
            super(projectId, kind);
        }

        private Builder(IncompleteKey copyFrom) {
            super(copyFrom);
        }

        @Override
        public IncompleteKey build() {
            ImmutableList path = ImmutableList.builder().addAll((Iterable)this.ancestors).add((Object)PathElement.of(this.kind)).build();
            return new IncompleteKey(this.projectId, this.namespace, (ImmutableList<PathElement>)path);
        }
    }
}

