/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.common.base.Preconditions;
import com.google.protobuf.Timestamp;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.format.ISODateTimeFormat;

public final class DateTime
implements Comparable<DateTime>,
Serializable {
    private static final long serialVersionUID = 5152143600571559844L;
    private final long timestampMicroseconds;

    DateTime(long timestampMicroseconds) {
        this.timestampMicroseconds = timestampMicroseconds;
    }

    public String toString() {
        return ISODateTimeFormat.dateTime().print(this.getTimestampMillis());
    }

    public int hashCode() {
        return (int)this.timestampMicroseconds;
    }

    @Override
    public int compareTo(DateTime other) {
        return this.toDate().compareTo(other.toDate());
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DateTime && this.timestampMicroseconds == ((DateTime)obj).timestampMicroseconds;
    }

    @Deprecated
    public long timestampMicroseconds() {
        return this.getTimestampMicroseconds();
    }

    public long getTimestampMicroseconds() {
        return this.timestampMicroseconds;
    }

    @Deprecated
    public long timestampMillis() {
        return this.getTimestampMillis();
    }

    public long getTimestampMillis() {
        return this.timestampMicroseconds / 1000L;
    }

    public Date toDate() {
        return new Date(this.getTimestampMillis());
    }

    public Calendar toCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.getTimestampMillis());
        return cal;
    }

    public static DateTime now() {
        return DateTime.copyFrom(new Date());
    }

    public static DateTime copyFrom(Date date) {
        return new DateTime(((Date)Preconditions.checkNotNull((Object)date)).getTime() * 1000L);
    }

    public static DateTime copyFrom(Calendar calendar) {
        return DateTime.copyFrom(calendar.getTime());
    }

    Timestamp toPb() {
        return DateTime.microsecondsToTimestampPb(this.timestampMicroseconds);
    }

    static long timestampPbToMicroseconds(Timestamp timestampPb) {
        return timestampPb.getSeconds() * 1000000L + (long)(timestampPb.getNanos() / 1000);
    }

    static Timestamp microsecondsToTimestampPb(long microseconds) {
        long seconds = microseconds / 1000000L;
        int nanos = (int)(microseconds % 1000000L) * 1000;
        return Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
    }
}

