/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.testing;

import com.google.cloud.RetryParams;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import java.util.UUID;

public class RemoteDatastoreHelper {
    private final DatastoreOptions options;
    private final Datastore datastore;
    private final String namespace;

    private RemoteDatastoreHelper(DatastoreOptions options) {
        this.options = options;
        this.datastore = (Datastore)options.getService();
        this.namespace = options.getNamespace();
    }

    @Deprecated
    public DatastoreOptions options() {
        return this.options;
    }

    public DatastoreOptions getOptions() {
        return this.options;
    }

    public void deleteNamespace() {
        KeyQuery query = ((KeyQuery.Builder)Query.newKeyQueryBuilder().setNamespace(this.namespace)).build();
        QueryResults keys = this.datastore.run(query);
        while (keys.hasNext()) {
            this.datastore.delete((Key)keys.next());
        }
    }

    public static RemoteDatastoreHelper create() {
        DatastoreOptions datastoreOption = ((DatastoreOptions.Builder)((DatastoreOptions.Builder)((DatastoreOptions.Builder)DatastoreOptions.newBuilder().setNamespace(UUID.randomUUID().toString()).setRetryParams(RemoteDatastoreHelper.retryParams())).setConnectTimeout(60000)).setReadTimeout(60000)).build();
        return new RemoteDatastoreHelper(datastoreOption);
    }

    private static RetryParams retryParams() {
        return RetryParams.newBuilder().setRetryMaxAttempts(10).setRetryMinAttempts(6).setMaxRetryDelayMillis(30000L).setTotalRetryPeriodMillis(120000L).setInitialRetryDelayMillis(250L).build();
    }
}

