/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.Timestamp;
import com.google.cloud.datastore.BaseEntity;
import com.google.cloud.datastore.Blob;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.LongValue;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.Value;
import com.google.datastore.v1.Entity;
import com.google.protobuf.ByteString;

public final class ProjectionEntity
extends BaseEntity<Key> {
    private static final long serialVersionUID = -3399517537444851544L;

    ProjectionEntity(Builder builder) {
        super(builder);
    }

    @Override
    public Timestamp getTimestamp(String name) {
        Object value = this.getValue(name);
        if (((Value)value).getMeaning() == 18 && value instanceof LongValue) {
            return Timestamp.ofTimeMicroseconds((long)this.getLong(name));
        }
        return (Timestamp)((Value)value).get();
    }

    @Override
    public Blob getBlob(String name) {
        Object value = this.getValue(name);
        if (((Value)value).getMeaning() == 18 && value instanceof StringValue) {
            return new Blob(ByteString.copyFromUtf8((String)this.getString(name)));
        }
        return (Blob)((Value)value).get();
    }

    static ProjectionEntity fromPb(Entity entityPb) {
        return ((Builder)new Builder().fill(entityPb)).build();
    }

    public static Builder newBuilder(ProjectionEntity copyFrom) {
        return new Builder(copyFrom);
    }

    public static final class Builder
    extends BaseEntity.Builder<Key, Builder> {
        Builder() {
        }

        private Builder(ProjectionEntity entity) {
            super(entity);
        }

        public ProjectionEntity build() {
            return new ProjectionEntity(this);
        }
    }
}

