/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.BaseDatastoreBatchWriter;
import com.google.cloud.datastore.Batch;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreImpl;
import com.google.cloud.datastore.Key;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.Mutation;
import com.google.datastore.v1.MutationResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class BatchImpl
extends BaseDatastoreBatchWriter
implements Batch {
    private final DatastoreImpl datastore;

    BatchImpl(DatastoreImpl datastore) {
        super("batch");
        this.datastore = datastore;
    }

    @Override
    public Batch.Response submit() {
        this.validateActive();
        List<Mutation> mutationsPb = this.toMutationPbList();
        CommitRequest.Builder requestPb = CommitRequest.newBuilder();
        requestPb.setMode(CommitRequest.Mode.NON_TRANSACTIONAL);
        requestPb.addAllMutations(mutationsPb);
        CommitResponse responsePb = this.datastore.commit(requestPb.build());
        this.deactivate();
        return new ResponseImpl(responsePb, this.toAddAutoId().size());
    }

    @Override
    public Datastore getDatastore() {
        return this.datastore;
    }

    static class ResponseImpl
    implements Batch.Response {
        private final CommitResponse response;
        private final int numAutoAllocatedIds;

        ResponseImpl(CommitResponse response, int numAutoAllocatedIds) {
            this.response = response;
            this.numAutoAllocatedIds = numAutoAllocatedIds;
        }

        @Override
        public List<Key> getGeneratedKeys() {
            Iterator results = this.response.getMutationResultsList().iterator();
            ArrayList<Key> generated = new ArrayList<Key>(this.numAutoAllocatedIds);
            for (int i = 0; i < this.numAutoAllocatedIds; ++i) {
                generated.add(Key.fromPb(((MutationResult)results.next()).getKey()));
            }
            return generated;
        }
    }
}

