/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.DatastoreWriter;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.ReadOption;
import com.google.cloud.datastore.Transaction;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

class DatastoreHelper {
    private DatastoreHelper() {
    }

    static Key allocateId(Datastore service, IncompleteKey key) {
        return service.allocateId(new IncompleteKey[]{key}).get(0);
    }

    static Entity get(Transaction reader, Key key) {
        return (Entity)Iterators.getNext(reader.get(new Key[]{key}), null);
    }

    static Entity get(Datastore reader, Key key, ReadOption ... options) {
        return (Entity)Iterators.getNext(reader.get(Collections.singletonList(key), options), null);
    }

    static Entity add(DatastoreWriter writer, FullEntity<?> entity) {
        return writer.add(new FullEntity[]{entity}).get(0);
    }

    static Entity put(DatastoreWriter writer, FullEntity<?> entity) {
        return writer.put(new FullEntity[]{entity}).get(0);
    }

    static KeyFactory newKeyFactory(DatastoreOptions options) {
        return new KeyFactory(options.getProjectId(), options.getNamespace());
    }

    static List<Entity> fetch(Transaction reader, Key ... keys) {
        return DatastoreHelper.compileEntities(keys, reader.get(keys));
    }

    static List<Entity> fetch(Datastore reader, Key[] keys, ReadOption ... options) {
        return DatastoreHelper.compileEntities(keys, reader.get(Arrays.asList(keys), options));
    }

    private static List<Entity> compileEntities(Key[] keys, Iterator<Entity> entities) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)keys.length);
        while (entities.hasNext()) {
            Entity entity = entities.next();
            map.put(entity.getKey(), entity);
        }
        ArrayList<Entity> list = new ArrayList<Entity>(keys.length);
        for (Key key : keys) {
            list.add((Entity)map.get(key));
        }
        return list;
    }

    static <T> T runInTransaction(Datastore datastore, Datastore.TransactionCallable<T> callable) {
        Transaction transaction = datastore.newTransaction();
        try {
            T value = callable.run(transaction);
            transaction.commit();
            T t = value;
            return t;
        }
        catch (Exception ex) {
            transaction.rollback();
            throw DatastoreException.propagateUserException(ex);
        }
        finally {
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
    }
}

