/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.core.ApiClock;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.BaseService;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.RetryHelper;
import com.google.cloud.ServiceOptions;
import com.google.cloud.datastore.Batch;
import com.google.cloud.datastore.BatchImpl;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.DatastoreHelper;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.QueryResultsImpl;
import com.google.cloud.datastore.ReadOption;
import com.google.cloud.datastore.Transaction;
import com.google.cloud.datastore.TransactionExceptionHandler;
import com.google.cloud.datastore.TransactionImpl;
import com.google.cloud.datastore.spi.v1.DatastoreRpc;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.datastore.v1.AllocateIdsRequest;
import com.google.datastore.v1.AllocateIdsResponse;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.BeginTransactionResponse;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.EntityResult;
import com.google.datastore.v1.LookupRequest;
import com.google.datastore.v1.LookupResponse;
import com.google.datastore.v1.Mutation;
import com.google.datastore.v1.MutationResult;
import com.google.datastore.v1.ReadOptions;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;

final class DatastoreImpl
extends BaseService<DatastoreOptions>
implements Datastore {
    private final DatastoreRpc datastoreRpc;
    private final RetrySettings retrySettings;
    private static final ExceptionHandler TRANSACTION_EXCEPTION_HANDLER = TransactionExceptionHandler.build();

    DatastoreImpl(DatastoreOptions options) {
        super((ServiceOptions)options);
        this.datastoreRpc = options.getDatastoreRpcV1();
        this.retrySettings = (RetrySettings)MoreObjects.firstNonNull((Object)options.getRetrySettings(), (Object)ServiceOptions.getNoRetrySettings());
    }

    @Override
    public Batch newBatch() {
        return new BatchImpl(this);
    }

    @Override
    public Transaction newTransaction() {
        return new TransactionImpl(this);
    }

    @Override
    public <T> T runInTransaction(final Datastore.TransactionCallable<T> callable) {
        final DatastoreImpl self = this;
        try {
            return (T)RetryHelper.runWithRetries((Callable)new Callable<T>(){

                @Override
                public T call() throws DatastoreException {
                    return DatastoreHelper.runInTransaction(self, callable);
                }
            }, (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)TRANSACTION_EXCEPTION_HANDLER, (ApiClock)((DatastoreOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw DatastoreException.translateAndThrow(e);
        }
    }

    @Override
    public <T> QueryResults<T> run(Query<T> query) {
        return this.run(null, query);
    }

    @Override
    public <T> QueryResults<T> run(Query<T> query, ReadOption ... options) {
        return this.run(DatastoreImpl.toReadOptionsPb(options), query);
    }

    <T> QueryResults<T> run(ReadOptions readOptionsPb, Query<T> query) {
        return new QueryResultsImpl<T>(this, readOptionsPb, query);
    }

    RunQueryResponse runQuery(final RunQueryRequest requestPb) {
        try {
            return (RunQueryResponse)RetryHelper.runWithRetries((Callable)new Callable<RunQueryResponse>(){

                @Override
                public RunQueryResponse call() throws DatastoreException {
                    return DatastoreImpl.this.datastoreRpc.runQuery(requestPb);
                }
            }, (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((DatastoreOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw DatastoreException.translateAndThrow(e);
        }
    }

    @Override
    public Key allocateId(IncompleteKey key) {
        return DatastoreHelper.allocateId(this, key);
    }

    private boolean verifyIncompleteKeyType(IncompleteKey ... keys) {
        for (IncompleteKey key : keys) {
            if (!(key instanceof Key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Key> allocateId(IncompleteKey ... keys) {
        Preconditions.checkArgument((boolean)this.verifyIncompleteKeyType(keys), (Object)"keys must be IncompleteKey instances");
        if (keys.length == 0) {
            return Collections.emptyList();
        }
        AllocateIdsRequest.Builder requestPb = AllocateIdsRequest.newBuilder();
        for (IncompleteKey key : keys) {
            requestPb.addKeys(this.trimNameOrId(key).toPb());
        }
        AllocateIdsResponse responsePb = this.allocateIds(requestPb.build());
        ImmutableList.Builder keyList = ImmutableList.builder();
        for (com.google.datastore.v1.Key keyPb : responsePb.getKeysList()) {
            keyList.add((Object)Key.fromPb(keyPb));
        }
        return keyList.build();
    }

    private AllocateIdsResponse allocateIds(final AllocateIdsRequest requestPb) {
        try {
            return (AllocateIdsResponse)RetryHelper.runWithRetries((Callable)new Callable<AllocateIdsResponse>(){

                @Override
                public AllocateIdsResponse call() throws DatastoreException {
                    return DatastoreImpl.this.datastoreRpc.allocateIds(requestPb);
                }
            }, (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((DatastoreOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw DatastoreException.translateAndThrow(e);
        }
    }

    private IncompleteKey trimNameOrId(IncompleteKey key) {
        if (key instanceof Key) {
            return IncompleteKey.newBuilder(key).build();
        }
        return key;
    }

    @Override
    public Entity add(FullEntity<?> entity) {
        return DatastoreHelper.add(this, entity);
    }

    @Override
    public List<Entity> add(FullEntity<?> ... entities) {
        if (entities.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Mutation> mutationsPb = new ArrayList<Mutation>();
        LinkedHashMap completeEntities = new LinkedHashMap();
        for (FullEntity<Key> fullEntity : entities) {
            Entity completeEntity = null;
            if (fullEntity.getKey() instanceof Key) {
                completeEntity = Entity.convert(fullEntity);
            }
            if (completeEntity != null) {
                if (completeEntities.put(completeEntity.getKey(), completeEntity) != null) {
                    throw DatastoreException.throwInvalidRequest("Duplicate entity with the key %s", fullEntity.getKey());
                }
            } else {
                Preconditions.checkArgument((boolean)fullEntity.hasKey(), (String)"Entity %s is missing a key", fullEntity);
            }
            mutationsPb.add(Mutation.newBuilder().setInsert(fullEntity.toPb()).build());
        }
        CommitResponse commitResponse = this.commitMutation(mutationsPb);
        Iterator mutationResults = commitResponse.getMutationResultsList().iterator();
        ImmutableList.Builder responseBuilder = ImmutableList.builder();
        for (FullEntity<?> entity : entities) {
            Entity completeEntity = (Entity)completeEntities.get(entity.getKey());
            if (completeEntity != null) {
                responseBuilder.add((Object)completeEntity);
                mutationResults.next();
                continue;
            }
            responseBuilder.add((Object)Entity.newBuilder(Key.fromPb(((MutationResult)mutationResults.next()).getKey()), entity).build());
        }
        return responseBuilder.build();
    }

    @Override
    public Entity get(Key key) {
        return DatastoreHelper.get(this, key, new ReadOption[0]);
    }

    @Override
    public Entity get(Key key, ReadOption ... options) {
        return DatastoreHelper.get(this, key, options);
    }

    @Override
    public Iterator<Entity> get(Key ... keys) {
        return this.get((ReadOptions)null, keys);
    }

    @Override
    public Iterator<Entity> get(Iterable<Key> keys, ReadOption ... options) {
        return this.get(DatastoreImpl.toReadOptionsPb(options), (Key[])Iterables.toArray(keys, Key.class));
    }

    private static ReadOptions toReadOptionsPb(ReadOption ... options) {
        ReadOptions readOptionsPb = null;
        if (options != null && ReadOption.asImmutableMap(options).containsKey(ReadOption.EventualConsistency.class)) {
            readOptionsPb = ReadOptions.newBuilder().setReadConsistency(ReadOptions.ReadConsistency.EVENTUAL).build();
        }
        return readOptionsPb;
    }

    @Override
    public List<Entity> fetch(Key ... keys) {
        return DatastoreHelper.fetch(this, keys, new ReadOption[0]);
    }

    @Override
    public List<Entity> fetch(Iterable<Key> keys, ReadOption ... options) {
        return DatastoreHelper.fetch(this, (Key[])Iterables.toArray(keys, Key.class), options);
    }

    Iterator<Entity> get(ReadOptions readOptionsPb, Key ... keys) {
        if (keys.length == 0) {
            return Collections.emptyIterator();
        }
        LookupRequest.Builder requestPb = LookupRequest.newBuilder();
        if (readOptionsPb != null) {
            requestPb.setReadOptions(readOptionsPb);
        }
        for (Key k : Sets.newLinkedHashSet(Arrays.asList(keys))) {
            requestPb.addKeys(k.toPb());
        }
        return new ResultsIterator(requestPb);
    }

    LookupResponse lookup(final LookupRequest requestPb) {
        try {
            return (LookupResponse)RetryHelper.runWithRetries((Callable)new Callable<LookupResponse>(){

                @Override
                public LookupResponse call() throws DatastoreException {
                    return DatastoreImpl.this.datastoreRpc.lookup(requestPb);
                }
            }, (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((DatastoreOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw DatastoreException.translateAndThrow(e);
        }
    }

    @Override
    public void update(Entity ... entities) {
        if (entities.length > 0) {
            ArrayList<Mutation> mutationsPb = new ArrayList<Mutation>();
            LinkedHashMap dedupEntities = new LinkedHashMap();
            for (Entity entity : entities) {
                dedupEntities.put(entity.getKey(), entity);
            }
            for (Entity entity : dedupEntities.values()) {
                mutationsPb.add(Mutation.newBuilder().setUpdate(entity.toPb()).build());
            }
            this.commitMutation(mutationsPb);
        }
    }

    @Override
    public Entity put(FullEntity<?> entity) {
        return DatastoreHelper.put(this, entity);
    }

    @Override
    public List<Entity> put(FullEntity<?> ... entities) {
        if (entities.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Mutation> mutationsPb = new ArrayList<Mutation>();
        LinkedHashMap dedupEntities = new LinkedHashMap();
        for (FullEntity<Key> fullEntity : entities) {
            Preconditions.checkArgument((boolean)fullEntity.hasKey(), (String)"Entity %s is missing a key", fullEntity);
            if (fullEntity.getKey() instanceof Key) {
                Entity completeEntity = Entity.convert(fullEntity);
                dedupEntities.put(completeEntity.getKey(), completeEntity);
                continue;
            }
            mutationsPb.add(Mutation.newBuilder().setUpsert(fullEntity.toPb()).build());
        }
        for (Entity entity : dedupEntities.values()) {
            mutationsPb.add(Mutation.newBuilder().setUpsert(entity.toPb()).build());
        }
        CommitResponse commitResponse = this.commitMutation(mutationsPb);
        Iterator mutationResults = commitResponse.getMutationResultsList().iterator();
        ImmutableList.Builder responseBuilder = ImmutableList.builder();
        for (FullEntity<?> entity : entities) {
            Entity completeEntity = (Entity)dedupEntities.get(entity.getKey());
            if (completeEntity != null) {
                responseBuilder.add((Object)completeEntity);
                continue;
            }
            responseBuilder.add((Object)Entity.newBuilder(Key.fromPb(((MutationResult)mutationResults.next()).getKey()), entity).build());
        }
        return responseBuilder.build();
    }

    @Override
    public void delete(Key ... keys) {
        if (keys.length > 0) {
            ArrayList<Mutation> mutationsPb = new ArrayList<Mutation>();
            LinkedHashSet<Key> dedupKeys = new LinkedHashSet<Key>(Arrays.asList(keys));
            for (Key key : dedupKeys) {
                mutationsPb.add(Mutation.newBuilder().setDelete(key.toPb()).build());
            }
            this.commitMutation(mutationsPb);
        }
    }

    @Override
    public KeyFactory newKeyFactory() {
        return DatastoreHelper.newKeyFactory((DatastoreOptions)this.getOptions());
    }

    private CommitResponse commitMutation(List<Mutation> mutationsPb) {
        CommitRequest.Builder requestPb = CommitRequest.newBuilder();
        requestPb.setMode(CommitRequest.Mode.NON_TRANSACTIONAL);
        requestPb.addAllMutations(mutationsPb);
        return this.commit(requestPb.build());
    }

    CommitResponse commit(final CommitRequest requestPb) {
        try {
            return (CommitResponse)RetryHelper.runWithRetries((Callable)new Callable<CommitResponse>(){

                @Override
                public CommitResponse call() throws DatastoreException {
                    return DatastoreImpl.this.datastoreRpc.commit(requestPb);
                }
            }, (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((DatastoreOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw DatastoreException.translateAndThrow(e);
        }
    }

    ByteString requestTransactionId(BeginTransactionRequest.Builder requestPb) {
        return this.beginTransaction(requestPb.build()).getTransaction();
    }

    BeginTransactionResponse beginTransaction(final BeginTransactionRequest requestPb) {
        try {
            return (BeginTransactionResponse)RetryHelper.runWithRetries((Callable)new Callable<BeginTransactionResponse>(){

                @Override
                public BeginTransactionResponse call() throws DatastoreException {
                    return DatastoreImpl.this.datastoreRpc.beginTransaction(requestPb);
                }
            }, (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((DatastoreOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw DatastoreException.translateAndThrow(e);
        }
    }

    void rollbackTransaction(ByteString transaction) {
        RollbackRequest.Builder requestPb = RollbackRequest.newBuilder();
        requestPb.setTransaction(transaction);
        this.rollback(requestPb.build());
    }

    void rollback(final RollbackRequest requestPb) {
        try {
            RetryHelper.runWithRetries((Callable)new Callable<Void>(){

                @Override
                public Void call() throws DatastoreException {
                    DatastoreImpl.this.datastoreRpc.rollback(requestPb);
                    return null;
                }
            }, (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((DatastoreOptions)this.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw DatastoreException.translateAndThrow(e);
        }
    }

    final class ResultsIterator
    extends AbstractIterator<Entity> {
        private final LookupRequest.Builder requestPb;
        Iterator<EntityResult> iter;

        ResultsIterator(LookupRequest.Builder requestPb) {
            this.requestPb = requestPb;
            this.loadResults();
        }

        private void loadResults() {
            LookupResponse responsePb = DatastoreImpl.this.lookup(this.requestPb.build());
            this.iter = responsePb.getFoundList().iterator();
            this.requestPb.clearKeys();
            if (responsePb.getDeferredCount() > 0) {
                this.requestPb.addAllKeys((Iterable)responsePb.getDeferredList());
            }
        }

        protected Entity computeNext() {
            while (!this.iter.hasNext()) {
                if (this.requestPb.getKeysCount() == 0) {
                    return (Entity)this.endOfData();
                }
                this.loadResults();
            }
            return Entity.fromPb(this.iter.next().getEntity());
        }
    }
}

