/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.testing;

import com.google.api.core.InternalApi;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.testing.BaseEmulatorHelper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.threeten.bp.Duration;

@InternalApi
public class LocalDatastoreHelper
extends BaseEmulatorHelper<DatastoreOptions> {
    private final List<BaseEmulatorHelper.EmulatorRunner> emulatorRunners;
    private final double consistency;
    private final Path gcdPath;
    private static final String GCLOUD_CMD_TEXT = "gcloud beta emulators datastore start";
    private static final String GCLOUD_CMD_PORT_FLAG = "--host-port=";
    private static final String VERSION_PREFIX = "cloud-datastore-emulator ";
    private static final String MIN_VERSION = "1.2.0";
    private static final String BIN_NAME = "cloud-datastore-emulator/cloud_datastore_emulator";
    private static final String FILENAME = "cloud-datastore-emulator-1.2.0.zip";
    private static final String MD5_CHECKSUM = "ec2237a0f0ac54964c6bd95e12c73720";
    private static final String BIN_CMD_PORT_FLAG = "--port=";
    private static final URL EMULATOR_URL;
    private static final String CONSISTENCY_FLAG = "--consistency=";
    private static final double DEFAULT_CONSISTENCY = 0.9;
    private static final Logger LOGGER;

    private LocalDatastoreHelper(double consistency) {
        String string = String.valueOf("test-project-");
        String string2 = String.valueOf(UUID.randomUUID().toString());
        super("datastore", BaseEmulatorHelper.findAvailablePort((int)8080), string2.length() != 0 ? string.concat(string2) : new String(string));
        Path tmpDirectory = null;
        try {
            tmpDirectory = Files.createTempDirectory("gcd", new FileAttribute[0]);
        }
        catch (IOException ex) {
            this.getLogger().log(Level.WARNING, "Failed to create temporary directory");
        }
        this.gcdPath = tmpDirectory;
        this.consistency = consistency;
        String binName = BIN_NAME;
        if (LocalDatastoreHelper.isWindows()) {
            binName = BIN_NAME.replace("/", "\\");
        }
        ArrayList<String> gcloudCommand = new ArrayList<String>(Arrays.asList(GCLOUD_CMD_TEXT.split(" ")));
        String string3 = String.valueOf(String.valueOf("--host-port=localhost:"));
        int n = this.getPort();
        gcloudCommand.add(new StringBuilder(11 + string3.length()).append(string3).append(n).toString());
        String string4 = String.valueOf(String.valueOf(CONSISTENCY_FLAG));
        double d = consistency;
        gcloudCommand.add(new StringBuilder(24 + string4.length()).append(string4).append(d).toString());
        gcloudCommand.add("--no-store-on-disk");
        BaseEmulatorHelper.GcloudEmulatorRunner gcloudRunner = new BaseEmulatorHelper.GcloudEmulatorRunner(gcloudCommand, VERSION_PREFIX, MIN_VERSION);
        ArrayList<String> binCommand = new ArrayList<String>(Arrays.asList(binName, "start"));
        binCommand.add("--testing");
        String string5 = String.valueOf(String.valueOf(BIN_CMD_PORT_FLAG));
        int n2 = this.getPort();
        binCommand.add(new StringBuilder(11 + string5.length()).append(string5).append(n2).toString());
        String string6 = String.valueOf(String.valueOf(CONSISTENCY_FLAG));
        double d2 = consistency;
        binCommand.add(new StringBuilder(24 + string6.length()).append(string6).append(d2).toString());
        if (this.gcdPath != null) {
            String string7 = String.valueOf(this.gcdPath.toString());
            gcloudCommand.add(string7.length() != 0 ? "--data-dir=".concat(string7) : new String("--data-dir="));
        }
        BaseEmulatorHelper.DownloadableEmulatorRunner downloadRunner = new BaseEmulatorHelper.DownloadableEmulatorRunner(binCommand, EMULATOR_URL, MD5_CHECKSUM);
        this.emulatorRunners = ImmutableList.of((Object)gcloudRunner, (Object)downloadRunner);
    }

    protected List<BaseEmulatorHelper.EmulatorRunner> getEmulatorRunners() {
        return this.emulatorRunners;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    private DatastoreOptions.Builder optionsBuilder() {
        String string = String.valueOf("localhost:");
        String string2 = String.valueOf(Integer.toString(this.getPort()));
        return (DatastoreOptions.Builder)((DatastoreOptions.Builder)((DatastoreOptions.Builder)((DatastoreOptions.Builder)DatastoreOptions.newBuilder().setProjectId(this.getProjectId())).setHost(string2.length() != 0 ? string.concat(string2) : new String(string))).setCredentials((Credentials)NoCredentials.getInstance())).setRetrySettings(ServiceOptions.getNoRetrySettings());
    }

    public DatastoreOptions getOptions() {
        return this.optionsBuilder().build();
    }

    public DatastoreOptions getOptions(String namespace) {
        return this.optionsBuilder().setNamespace(namespace).build();
    }

    public double getConsistency() {
        return this.consistency;
    }

    public static LocalDatastoreHelper create(double consistency) {
        return new LocalDatastoreHelper(consistency);
    }

    public static LocalDatastoreHelper create() {
        return LocalDatastoreHelper.create(0.9);
    }

    public void start() throws IOException, InterruptedException {
        String blockUntilOutput = "Dev App Server is now running";
        this.startProcess(blockUntilOutput);
    }

    public void reset() throws IOException {
        this.sendPostRequest("/reset");
    }

    public void stop(Duration timeout) throws IOException, InterruptedException, TimeoutException {
        this.sendPostRequest("/shutdown");
        this.waitForProcess(timeout);
        LocalDatastoreHelper.deleteRecursively(this.gcdPath);
    }

    private static void deleteRecursively(Path path) throws IOException {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static {
        LOGGER = Logger.getLogger(LocalDatastoreHelper.class.getName());
        try {
            EMULATOR_URL = new URL("http://storage.googleapis.com/gcd/tools/cloud-datastore-emulator-1.2.0.zip");
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

