/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.admin.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datastore.admin.v1.DatastoreAdminClient;
import com.google.cloud.datastore.admin.v1.stub.DatastoreAdminStub;
import com.google.cloud.datastore.admin.v1.stub.DatastoreAdminStubSettings;
import com.google.cloud.datastore.admin.v1.stub.HttpJsonDatastoreAdminCallableFactory;
import com.google.datastore.admin.v1.CreateIndexRequest;
import com.google.datastore.admin.v1.DeleteIndexRequest;
import com.google.datastore.admin.v1.ExportEntitiesMetadata;
import com.google.datastore.admin.v1.ExportEntitiesRequest;
import com.google.datastore.admin.v1.ExportEntitiesResponse;
import com.google.datastore.admin.v1.GetIndexRequest;
import com.google.datastore.admin.v1.ImportEntitiesMetadata;
import com.google.datastore.admin.v1.ImportEntitiesRequest;
import com.google.datastore.admin.v1.Index;
import com.google.datastore.admin.v1.IndexOperationMetadata;
import com.google.datastore.admin.v1.ListIndexesRequest;
import com.google.datastore.admin.v1.ListIndexesResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonDatastoreAdminStub
extends DatastoreAdminStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(ExportEntitiesResponse.getDescriptor()).add(IndexOperationMetadata.getDescriptor()).add(Index.getDescriptor()).add(ExportEntitiesMetadata.getDescriptor()).add(ImportEntitiesMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<ExportEntitiesRequest, Operation> exportEntitiesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.datastore.admin.v1.DatastoreAdmin/ExportEntities").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}:export", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearProjectId().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ImportEntitiesRequest, Operation> importEntitiesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.datastore.admin.v1.DatastoreAdmin/ImportEntities").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}:import", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearProjectId().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<CreateIndexRequest, Operation> createIndexMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.datastore.admin.v1.DatastoreAdmin/CreateIndex").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/indexes", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("index", (Message)request.getIndex(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteIndexRequest, Operation> deleteIndexMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.datastore.admin.v1.DatastoreAdmin/DeleteIndex").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/indexes/{indexId}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "indexId", (Object)request.getIndexId());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetIndexRequest, Index> getIndexMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.datastore.admin.v1.DatastoreAdmin/GetIndex").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/indexes/{indexId}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "indexId", (Object)request.getIndexId());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Index.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListIndexesRequest, ListIndexesResponse> listIndexesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.datastore.admin.v1.DatastoreAdmin/ListIndexes").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/indexes", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListIndexesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ExportEntitiesRequest, Operation> exportEntitiesCallable;
    private final OperationCallable<ExportEntitiesRequest, ExportEntitiesResponse, ExportEntitiesMetadata> exportEntitiesOperationCallable;
    private final UnaryCallable<ImportEntitiesRequest, Operation> importEntitiesCallable;
    private final OperationCallable<ImportEntitiesRequest, Empty, ImportEntitiesMetadata> importEntitiesOperationCallable;
    private final UnaryCallable<CreateIndexRequest, Operation> createIndexCallable;
    private final OperationCallable<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationCallable;
    private final UnaryCallable<DeleteIndexRequest, Operation> deleteIndexCallable;
    private final OperationCallable<DeleteIndexRequest, Index, IndexOperationMetadata> deleteIndexOperationCallable;
    private final UnaryCallable<GetIndexRequest, Index> getIndexCallable;
    private final UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable;
    private final UnaryCallable<ListIndexesRequest, DatastoreAdminClient.ListIndexesPagedResponse> listIndexesPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDatastoreAdminStub create(DatastoreAdminStubSettings settings) throws IOException {
        return new HttpJsonDatastoreAdminStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDatastoreAdminStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDatastoreAdminStub(DatastoreAdminStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDatastoreAdminStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDatastoreAdminStub(DatastoreAdminStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDatastoreAdminStub(DatastoreAdminStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDatastoreAdminCallableFactory());
    }

    protected HttpJsonDatastoreAdminStub(DatastoreAdminStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings exportEntitiesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(exportEntitiesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings importEntitiesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(importEntitiesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createIndexTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createIndexMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteIndexTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteIndexMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getIndexTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIndexMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listIndexesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listIndexesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.exportEntitiesCallable = callableFactory.createUnaryCallable(exportEntitiesTransportSettings, settings.exportEntitiesSettings(), clientContext);
        this.exportEntitiesOperationCallable = callableFactory.createOperationCallable(exportEntitiesTransportSettings, settings.exportEntitiesOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.importEntitiesCallable = callableFactory.createUnaryCallable(importEntitiesTransportSettings, settings.importEntitiesSettings(), clientContext);
        this.importEntitiesOperationCallable = callableFactory.createOperationCallable(importEntitiesTransportSettings, settings.importEntitiesOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.createIndexCallable = callableFactory.createUnaryCallable(createIndexTransportSettings, settings.createIndexSettings(), clientContext);
        this.createIndexOperationCallable = callableFactory.createOperationCallable(createIndexTransportSettings, settings.createIndexOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteIndexCallable = callableFactory.createUnaryCallable(deleteIndexTransportSettings, settings.deleteIndexSettings(), clientContext);
        this.deleteIndexOperationCallable = callableFactory.createOperationCallable(deleteIndexTransportSettings, settings.deleteIndexOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getIndexCallable = callableFactory.createUnaryCallable(getIndexTransportSettings, settings.getIndexSettings(), clientContext);
        this.listIndexesCallable = callableFactory.createUnaryCallable(listIndexesTransportSettings, settings.listIndexesSettings(), clientContext);
        this.listIndexesPagedCallable = callableFactory.createPagedCallable(listIndexesTransportSettings, settings.listIndexesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(exportEntitiesMethodDescriptor);
        methodDescriptors.add(importEntitiesMethodDescriptor);
        methodDescriptors.add(createIndexMethodDescriptor);
        methodDescriptors.add(deleteIndexMethodDescriptor);
        methodDescriptors.add(getIndexMethodDescriptor);
        methodDescriptors.add(listIndexesMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ExportEntitiesRequest, Operation> exportEntitiesCallable() {
        return this.exportEntitiesCallable;
    }

    @Override
    public OperationCallable<ExportEntitiesRequest, ExportEntitiesResponse, ExportEntitiesMetadata> exportEntitiesOperationCallable() {
        return this.exportEntitiesOperationCallable;
    }

    @Override
    public UnaryCallable<ImportEntitiesRequest, Operation> importEntitiesCallable() {
        return this.importEntitiesCallable;
    }

    @Override
    public OperationCallable<ImportEntitiesRequest, Empty, ImportEntitiesMetadata> importEntitiesOperationCallable() {
        return this.importEntitiesOperationCallable;
    }

    @Override
    public UnaryCallable<CreateIndexRequest, Operation> createIndexCallable() {
        return this.createIndexCallable;
    }

    @Override
    public OperationCallable<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationCallable() {
        return this.createIndexOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteIndexRequest, Operation> deleteIndexCallable() {
        return this.deleteIndexCallable;
    }

    @Override
    public OperationCallable<DeleteIndexRequest, Index, IndexOperationMetadata> deleteIndexOperationCallable() {
        return this.deleteIndexOperationCallable;
    }

    @Override
    public UnaryCallable<GetIndexRequest, Index> getIndexCallable() {
        return this.getIndexCallable;
    }

    @Override
    public UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable() {
        return this.listIndexesCallable;
    }

    @Override
    public UnaryCallable<ListIndexesRequest, DatastoreAdminClient.ListIndexesPagedResponse> listIndexesPagedCallable() {
        return this.listIndexesPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

