/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.client.util.Preconditions;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.cloud.Timestamp;
import com.google.cloud.datastore.AggregationResult;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@BetaApi
public class AggregationResults
implements Iterable<AggregationResult> {
    private final List<AggregationResult> aggregationResults;
    private final Timestamp readTime;

    public AggregationResults(List<AggregationResult> aggregationResults, Timestamp readTime) {
        Preconditions.checkNotNull(aggregationResults, (Object)"Aggregation results cannot be null");
        Preconditions.checkNotNull((Object)readTime, (Object)"readTime cannot be null");
        this.aggregationResults = aggregationResults;
        this.readTime = readTime;
    }

    @Override
    public Iterator<AggregationResult> iterator() {
        return this.aggregationResults.iterator();
    }

    public int size() {
        return this.aggregationResults.size();
    }

    @InternalApi
    public AggregationResult get(int index) {
        return this.aggregationResults.get(index);
    }

    public Timestamp getReadTime() {
        return this.readTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationResults that = (AggregationResults)o;
        return Objects.equals(this.aggregationResults, that.aggregationResults);
    }

    public int hashCode() {
        return Objects.hash(this.aggregationResults);
    }
}

