/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Cursor;
import com.google.cloud.datastore.DatastoreImpl;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.RecordQuery;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.datastore.v1.EntityResult;
import com.google.datastore.v1.PartitionId;
import com.google.datastore.v1.Query;
import com.google.datastore.v1.QueryResultBatch;
import com.google.datastore.v1.ReadOptions;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;

class QueryResultsImpl<T>
extends AbstractIterator<T>
implements QueryResults<T> {
    private final DatastoreImpl datastore;
    private final Optional<ReadOptions> readOptionsPb;
    private final PartitionId partitionIdPb;
    private final Query.ResultType<T> queryResultType;
    private RecordQuery<T> query;
    private Query.ResultType<?> actualResultType;
    private RunQueryResponse runQueryResponsePb;
    private Query mostRecentQueryPb;
    private boolean lastBatch;
    private Iterator<EntityResult> entityResultPbIter;
    private ByteString cursor;
    private QueryResultBatch.MoreResultsType moreResults;

    QueryResultsImpl(DatastoreImpl datastore, Optional<ReadOptions> readOptionsPb, RecordQuery<T> query, String namespace) {
        this.datastore = datastore;
        this.readOptionsPb = readOptionsPb;
        this.query = query;
        this.queryResultType = query.getType();
        PartitionId.Builder pbBuilder = PartitionId.newBuilder();
        pbBuilder.setProjectId(((DatastoreOptions)datastore.getOptions()).getProjectId());
        if (namespace != null) {
            pbBuilder.setNamespaceId(namespace);
        } else if (((DatastoreOptions)datastore.getOptions()).getNamespace() != null) {
            pbBuilder.setNamespaceId(((DatastoreOptions)datastore.getOptions()).getNamespace());
        }
        this.partitionIdPb = pbBuilder.build();
        this.sendRequest();
        this.cursor = this.runQueryResponsePb.getBatch().getSkippedResults() > 0 ? this.runQueryResponsePb.getBatch().getSkippedCursor() : this.mostRecentQueryPb.getStartCursor();
    }

    private void sendRequest() {
        RunQueryRequest.Builder requestPb = RunQueryRequest.newBuilder();
        this.readOptionsPb.ifPresent(arg_0 -> ((RunQueryRequest.Builder)requestPb).setReadOptions(arg_0));
        requestPb.setPartitionId(this.partitionIdPb);
        this.query.populatePb(requestPb);
        this.runQueryResponsePb = this.datastore.runQuery(requestPb.build());
        this.mostRecentQueryPb = requestPb.getQuery();
        this.moreResults = this.runQueryResponsePb.getBatch().getMoreResults();
        this.lastBatch = this.moreResults != QueryResultBatch.MoreResultsType.NOT_FINISHED;
        this.entityResultPbIter = this.runQueryResponsePb.getBatch().getEntityResultsList().iterator();
        this.actualResultType = Query.ResultType.fromPb(this.runQueryResponsePb.getBatch().getEntityResultType());
        if (Objects.equals(this.queryResultType, Query.ResultType.PROJECTION_ENTITY)) {
            this.actualResultType = Query.ResultType.PROJECTION_ENTITY;
        }
        Preconditions.checkState((boolean)this.queryResultType.isAssignableFrom(this.actualResultType), (Object)("Unexpected result type " + this.actualResultType + " vs " + this.queryResultType));
    }

    protected T computeNext() {
        while (!this.entityResultPbIter.hasNext() && !this.lastBatch) {
            this.query = this.query.nextQuery(this.runQueryResponsePb);
            this.sendRequest();
        }
        if (!this.entityResultPbIter.hasNext()) {
            this.cursor = this.runQueryResponsePb.getBatch().getEndCursor();
            return (T)this.endOfData();
        }
        EntityResult entityResultPb = this.entityResultPbIter.next();
        this.cursor = entityResultPb.getCursor();
        Object result = this.actualResultType.convert(entityResultPb.getEntity());
        return (T)result;
    }

    @Override
    public Class<?> getResultClass() {
        return this.actualResultType.resultClass();
    }

    @Override
    public Cursor getCursorAfter() {
        return new Cursor(this.cursor);
    }

    @Override
    public int getSkippedResults() {
        return this.runQueryResponsePb.getBatch().getSkippedResults();
    }

    @Override
    public QueryResultBatch.MoreResultsType getMoreResults() {
        return this.moreResults;
    }
}

