/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.cloud.Timestamp;
import com.google.cloud.datastore.Query;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class ReadOption
implements Serializable {
    private static final long serialVersionUID = -4406964829189800528L;

    private ReadOption() {
    }

    public static EventualConsistency eventualConsistency() {
        return new EventualConsistency(true);
    }

    @BetaApi
    public static ReadTime readTime(Timestamp time) {
        return new ReadTime(time);
    }

    @InternalApi
    public static ReadOption transactionId(String transactionId) {
        return new TransactionId(ByteString.copyFrom((byte[])transactionId.getBytes()));
    }

    @InternalApi
    public static ReadOption transactionId(ByteString transactionId) {
        return new TransactionId(transactionId);
    }

    static Map<Class<? extends ReadOption>, ReadOption> asImmutableMap(ReadOption ... options) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ReadOption option : options) {
            builder.put(option.getClass(), (Object)option);
        }
        return builder.buildOrThrow();
    }

    static Map<Class<? extends ReadOption>, ReadOption> asImmutableMap(List<ReadOption> options) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ReadOption option : options) {
            builder.put(option.getClass(), (Object)option);
        }
        return builder.buildOrThrow();
    }

    @InternalApi
    public static class QueryAndReadOptions<Q extends Query<?>> {
        Q query;
        List<ReadOption> readOptions;

        private QueryAndReadOptions(Q query, List<ReadOption> readOptions) {
            this.query = query;
            this.readOptions = readOptions;
        }

        private QueryAndReadOptions(Q query) {
            this.query = query;
            this.readOptions = Collections.emptyList();
        }

        public Q getQuery() {
            return this.query;
        }

        public List<ReadOption> getReadOptions() {
            return this.readOptions;
        }

        public static <Q extends Query<?>> QueryAndReadOptions<Q> create(Q query) {
            return new QueryAndReadOptions<Q>(query);
        }

        public static <Q extends Query<?>> QueryAndReadOptions<Q> create(Q query, List<ReadOption> readOptions) {
            return new QueryAndReadOptions<Q>(query, readOptions);
        }
    }

    @InternalApi
    static class TransactionId
    extends ReadOption {
        private final ByteString transactionId;

        TransactionId(ByteString transactionId) {
            this.transactionId = transactionId;
        }

        public ByteString getTransactionId() {
            return this.transactionId;
        }
    }

    public static final class ReadTime
    extends ReadOption {
        private static final long serialVersionUID = -6780321449114616067L;
        private final Timestamp time;

        private ReadTime(Timestamp time) {
            this.time = time;
        }

        public Timestamp time() {
            return this.time;
        }
    }

    public static final class EventualConsistency
    extends ReadOption {
        private static final long serialVersionUID = -6959530217724666172L;
        private final boolean eventualConsistency;

        private EventualConsistency(boolean eventualConsistency) {
            this.eventualConsistency = eventualConsistency;
        }

        public boolean isEventual() {
            return this.eventualConsistency;
        }
    }
}

