/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.execution.request;

import com.google.api.core.InternalApi;
import com.google.cloud.datastore.AggregationQuery;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.GqlQueryProtoPreparer;
import com.google.cloud.datastore.ReadOption;
import com.google.cloud.datastore.ReadOptionProtoPreparer;
import com.google.cloud.datastore.StructuredQueryProtoPreparer;
import com.google.cloud.datastore.aggregation.Aggregation;
import com.google.cloud.datastore.execution.request.ProtoPreparer;
import com.google.datastore.v1.AggregationQuery;
import com.google.datastore.v1.GqlQuery;
import com.google.datastore.v1.PartitionId;
import com.google.datastore.v1.Query;
import com.google.datastore.v1.ReadOptions;
import com.google.datastore.v1.RunAggregationQueryRequest;
import java.util.List;
import java.util.Optional;

@InternalApi
public class AggregationQueryRequestProtoPreparer
implements ProtoPreparer<ReadOption.QueryAndReadOptions<AggregationQuery>, RunAggregationQueryRequest> {
    private final DatastoreOptions datastoreOptions;
    private final StructuredQueryProtoPreparer structuredQueryProtoPreparer;
    private final GqlQueryProtoPreparer gqlQueryProtoPreparer;
    private final ReadOptionProtoPreparer readOptionProtoPreparer;

    public AggregationQueryRequestProtoPreparer(DatastoreOptions datastoreOptions) {
        this.datastoreOptions = datastoreOptions;
        this.structuredQueryProtoPreparer = new StructuredQueryProtoPreparer();
        this.gqlQueryProtoPreparer = new GqlQueryProtoPreparer();
        this.readOptionProtoPreparer = new ReadOptionProtoPreparer();
    }

    @Override
    public RunAggregationQueryRequest prepare(ReadOption.QueryAndReadOptions<AggregationQuery> aggregationQueryAndReadOptions) {
        AggregationQuery aggregationQuery = aggregationQueryAndReadOptions.getQuery();
        List<ReadOption> readOptions = aggregationQueryAndReadOptions.getReadOptions();
        PartitionId partitionId = this.getPartitionId(aggregationQuery);
        RunAggregationQueryRequest.Builder aggregationQueryRequestBuilder = RunAggregationQueryRequest.newBuilder().setPartitionId(partitionId).setProjectId(this.datastoreOptions.getProjectId());
        if (aggregationQuery.getMode() == AggregationQuery.Mode.GQL) {
            aggregationQueryRequestBuilder.setGqlQuery(this.buildGqlQuery(aggregationQuery));
        } else {
            aggregationQueryRequestBuilder.setAggregationQuery(this.getAggregationQuery(aggregationQuery));
        }
        Optional<ReadOptions> readOptionsPb = this.readOptionProtoPreparer.prepare(readOptions);
        readOptionsPb.ifPresent(arg_0 -> ((RunAggregationQueryRequest.Builder)aggregationQueryRequestBuilder).setReadOptions(arg_0));
        return aggregationQueryRequestBuilder.build();
    }

    private GqlQuery buildGqlQuery(AggregationQuery aggregationQuery) {
        return this.gqlQueryProtoPreparer.prepare(aggregationQuery.getNestedGqlQuery());
    }

    private com.google.datastore.v1.AggregationQuery getAggregationQuery(AggregationQuery aggregationQuery) {
        Query nestedQueryProto = this.structuredQueryProtoPreparer.prepare(aggregationQuery.getNestedStructuredQuery());
        AggregationQuery.Builder aggregationQueryProtoBuilder = com.google.datastore.v1.AggregationQuery.newBuilder().setNestedQuery(nestedQueryProto);
        for (Aggregation aggregation : aggregationQuery.getAggregations()) {
            aggregationQueryProtoBuilder.addAggregations(aggregation.toPb());
        }
        return aggregationQueryProtoBuilder.build();
    }

    private PartitionId getPartitionId(AggregationQuery aggregationQuery) {
        PartitionId.Builder builder = PartitionId.newBuilder().setProjectId(this.datastoreOptions.getProjectId());
        if (aggregationQuery.getNamespace() != null) {
            builder.setNamespaceId(aggregationQuery.getNamespace());
        }
        return builder.build();
    }
}

