/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.execution.response;

import com.google.api.core.InternalApi;
import com.google.cloud.Timestamp;
import com.google.cloud.datastore.AggregationResult;
import com.google.cloud.datastore.AggregationResults;
import com.google.cloud.datastore.LongValue;
import com.google.cloud.datastore.execution.response.ResponseTransformer;
import com.google.datastore.v1.RunAggregationQueryResponse;
import com.google.datastore.v1.Value;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@InternalApi
public class AggregationQueryResponseTransformer
implements ResponseTransformer<RunAggregationQueryResponse, AggregationResults> {
    @Override
    public AggregationResults transform(RunAggregationQueryResponse response) {
        Timestamp readTime = Timestamp.fromProto((com.google.protobuf.Timestamp)response.getBatch().getReadTime());
        List aggregationResults = response.getBatch().getAggregationResultsList().stream().map(aggregationResult -> new AggregationResult(this.resultWithLongValues((com.google.datastore.v1.AggregationResult)aggregationResult))).collect(Collectors.toCollection(LinkedList::new));
        return new AggregationResults(aggregationResults, readTime);
    }

    private Map<String, LongValue> resultWithLongValues(com.google.datastore.v1.AggregationResult aggregationResult) {
        return aggregationResult.getAggregatePropertiesMap().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, LongValue>((String)entry.getKey(), (LongValue)LongValue.fromPb((Value)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

