/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.core.ApiClock;
import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.BaseService;
import com.google.cloud.RetryHelper;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.TraceUtil;
import com.google.cloud.datastore.spi.v1.DatastoreRpc;
import com.google.datastore.v1.AllocateIdsRequest;
import com.google.datastore.v1.AllocateIdsResponse;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.BeginTransactionResponse;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.LookupRequest;
import com.google.datastore.v1.LookupResponse;
import com.google.datastore.v1.ReserveIdsRequest;
import com.google.datastore.v1.ReserveIdsResponse;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.RollbackResponse;
import com.google.datastore.v1.RunAggregationQueryRequest;
import com.google.datastore.v1.RunAggregationQueryResponse;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import java.util.concurrent.Callable;

@InternalApi
public class RetryAndTraceDatastoreRpcDecorator
implements DatastoreRpc {
    private final DatastoreRpc datastoreRpc;
    private final TraceUtil traceUtil;
    private final RetrySettings retrySettings;
    private final DatastoreOptions datastoreOptions;

    public RetryAndTraceDatastoreRpcDecorator(DatastoreRpc datastoreRpc, TraceUtil traceUtil, RetrySettings retrySettings, DatastoreOptions datastoreOptions) {
        this.datastoreRpc = datastoreRpc;
        this.traceUtil = traceUtil;
        this.retrySettings = retrySettings;
        this.datastoreOptions = datastoreOptions;
    }

    @Override
    public AllocateIdsResponse allocateIds(AllocateIdsRequest request) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public BeginTransactionResponse beginTransaction(BeginTransactionRequest request) throws DatastoreException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public CommitResponse commit(CommitRequest request) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public LookupResponse lookup(LookupRequest request) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public ReserveIdsResponse reserveIds(ReserveIdsRequest request) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public RollbackResponse rollback(RollbackRequest request) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public RunQueryResponse runQuery(RunQueryRequest request) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public RunAggregationQueryResponse runAggregationQuery(RunAggregationQueryRequest request) {
        return this.invokeRpc(() -> this.datastoreRpc.runAggregationQuery(request), "CloudDatastoreOperation.runAggregationQuery");
    }

    public <O> O invokeRpc(Callable<O> block, String startSpan) {
        Span span = this.traceUtil.startSpan(startSpan);
        try {
            Object object;
            block11: {
                Scope scope = this.traceUtil.getTracer().withSpan(span);
                try {
                    object = RetryHelper.runWithRetries(block, (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)BaseService.EXCEPTION_HANDLER, (ApiClock)this.datastoreOptions.getClock());
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RetryHelper.RetryHelperException e) {
                        span.setStatus(Status.UNKNOWN.withDescription(e.getMessage()));
                        throw DatastoreException.translateAndThrow(e);
                    }
                }
                scope.close();
            }
            return (O)object;
        }
        finally {
            span.end(TraceUtil.END_SPAN_OPTIONS);
        }
    }
}

