/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.core.BetaApi;
import com.google.cloud.datastore.PathElement;
import com.google.cloud.datastore.Validator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.PartitionId;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public abstract class BaseKey
implements Serializable {
    private static final long serialVersionUID = -5897863400209818325L;
    private final String projectId;
    private final String namespace;
    private final String databaseId;
    private final ImmutableList<PathElement> path;

    BaseKey(String projectId, String namespace, ImmutableList<PathElement> path) {
        this(projectId, namespace, "", path);
    }

    BaseKey(String projectId, String namespace, String databaseId, ImmutableList<PathElement> path) {
        Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0, (Object)"Path must not be empty");
        this.projectId = projectId;
        this.namespace = namespace;
        this.databaseId = databaseId;
        this.path = path;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @BetaApi
    public String getDatabaseId() {
        return this.databaseId;
    }

    public List<PathElement> getAncestors() {
        return this.getPath().subList(0, this.getPath().size() - 1);
    }

    List<PathElement> getPath() {
        return this.path;
    }

    PathElement getLeaf() {
        return this.getPath().get(this.getPath().size() - 1);
    }

    public String getKind() {
        return this.getLeaf().getKind();
    }

    abstract BaseKey getParent();

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projectId", (Object)this.projectId).add("namespace", (Object)this.namespace).add("databaseId", (Object)this.databaseId).add("path", this.path).toString();
    }

    public int hashCode() {
        return Objects.hash(this.getProjectId(), this.getNamespace(), this.getDatabaseId(), this.getPath());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BaseKey)) {
            return false;
        }
        BaseKey other = (BaseKey)obj;
        return Objects.equals(this.getProjectId(), other.getProjectId()) && Objects.equals(this.getNamespace(), other.getNamespace()) && Objects.equals(this.getDatabaseId(), other.getDatabaseId()) && Objects.equals(this.getPath(), other.getPath());
    }

    Key toPb() {
        Key.Builder keyPb = Key.newBuilder();
        PartitionId.Builder partitionIdPb = PartitionId.newBuilder();
        partitionIdPb.setProjectId(this.projectId);
        partitionIdPb.setDatabaseId(this.databaseId);
        partitionIdPb.setNamespaceId(this.namespace);
        keyPb.setPartitionId(partitionIdPb.build());
        for (PathElement pathEntry : this.path) {
            keyPb.addPath(pathEntry.toPb());
        }
        return keyPb.build();
    }

    public static abstract class Builder<B extends Builder<B>> {
        String projectId = "";
        String namespace = "";
        String databaseId = "";
        String kind;
        final List<PathElement> ancestors;
        private static final int MAX_PATH = 100;

        Builder(String projectId) {
            this.projectId = Validator.validateProjectId(projectId);
            this.ancestors = new LinkedList<PathElement>();
        }

        Builder(String projectId, String kind) {
            this(projectId);
            this.kind = Validator.validateKind(kind);
        }

        Builder(BaseKey copyFrom) {
            this.projectId = copyFrom.getProjectId();
            this.namespace = copyFrom.getNamespace();
            this.databaseId = copyFrom.getDatabaseId();
            this.ancestors = new LinkedList<PathElement>(copyFrom.getAncestors());
            this.kind = copyFrom.getKind();
        }

        B self() {
            return (B)this;
        }

        public B addAncestor(PathElement ancestor) {
            Preconditions.checkState((this.ancestors.size() < 100 ? 1 : 0) != 0, (Object)"path can have at most 100 elements");
            this.ancestors.add(ancestor);
            return this.self();
        }

        public B addAncestors(PathElement ancestor, PathElement ... other) {
            return this.addAncestors((Iterable<PathElement>)ImmutableList.builder().add((Object)ancestor).add((Object[])other).build());
        }

        public B addAncestors(Iterable<PathElement> ancestors) {
            ImmutableList list = ImmutableList.copyOf(ancestors);
            Preconditions.checkState((this.ancestors.size() + list.size() < 100 ? 1 : 0) != 0, (Object)"path can have at most 100 elements");
            this.ancestors.addAll((Collection<PathElement>)list);
            return this.self();
        }

        public B setKind(String kind) {
            this.kind = Validator.validateKind(kind);
            return this.self();
        }

        public B setProjectId(String projectId) {
            this.projectId = Validator.validateProjectId(projectId);
            return this.self();
        }

        public B setNamespace(String namespace) {
            this.namespace = Validator.validateNamespace(namespace);
            return this.self();
        }

        @BetaApi
        public B setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
            return this.self();
        }

        protected abstract BaseKey build();
    }
}

