/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.core.BetaApi;
import com.google.cloud.datastore.BaseKey;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.PathElement;
import com.google.common.collect.ImmutableList;

public final class KeyFactory
extends BaseKey.Builder<KeyFactory> {
    private final String initialProjectId;
    private final String initialNamespace;
    private final String initialDatabaseId;

    public KeyFactory(String projectId) {
        this(projectId, "");
    }

    public KeyFactory(String projectId, String namespace) {
        this(projectId, namespace, "");
    }

    @BetaApi
    public KeyFactory(String projectId, String namespace, String databaseId) {
        super(projectId);
        this.setNamespace(namespace);
        this.setDatabaseId(databaseId);
        this.initialProjectId = projectId;
        this.initialNamespace = namespace;
        this.initialDatabaseId = databaseId;
    }

    public IncompleteKey newKey() {
        ImmutableList path = ImmutableList.builder().addAll((Iterable)this.ancestors).add((Object)PathElement.of(this.kind)).build();
        return new IncompleteKey(this.projectId, this.namespace, this.databaseId, (ImmutableList<PathElement>)path);
    }

    public Key newKey(String name) {
        ImmutableList path = ImmutableList.builder().addAll((Iterable)this.ancestors).add((Object)PathElement.of(this.kind, name)).build();
        return new Key(this.projectId, this.namespace, this.databaseId, (ImmutableList<PathElement>)path);
    }

    public Key newKey(long id) {
        ImmutableList path = ImmutableList.builder().addAll((Iterable)this.ancestors).add((Object)PathElement.of(this.kind, id)).build();
        return new Key(this.projectId, this.namespace, this.databaseId, (ImmutableList<PathElement>)path);
    }

    public KeyFactory reset() {
        this.setProjectId(this.initialProjectId);
        this.setNamespace(this.initialNamespace);
        this.setDatabaseId(this.initialDatabaseId);
        this.kind = null;
        this.ancestors.clear();
        return this;
    }

    @Override
    protected IncompleteKey build() {
        return this.newKey();
    }
}

