/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.testing;

import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.TransportOptions;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.http.HttpTransportOptions;
import java.util.UUID;
import org.threeten.bp.Duration;

@InternalApi
public class RemoteDatastoreHelper {
    private final DatastoreOptions options;
    private final Datastore datastore;
    private final String namespace;

    private RemoteDatastoreHelper(DatastoreOptions options) {
        this.options = options;
        this.datastore = (Datastore)options.getService();
        this.namespace = options.getNamespace();
    }

    public DatastoreOptions getOptions() {
        return this.options;
    }

    public void deleteNamespace() {
        KeyQuery query = ((KeyQuery.Builder)Query.newKeyQueryBuilder().setNamespace(this.namespace)).build();
        QueryResults keys = this.datastore.run(query);
        while (keys.hasNext()) {
            this.datastore.delete((Key)keys.next());
        }
    }

    public static RemoteDatastoreHelper create() {
        return RemoteDatastoreHelper.create("");
    }

    public static RemoteDatastoreHelper create(String databaseId) {
        HttpTransportOptions transportOptions = DatastoreOptions.getDefaultHttpTransportOptions();
        transportOptions = transportOptions.toBuilder().setConnectTimeout(60000).setReadTimeout(60000).build();
        DatastoreOptions datastoreOption = ((DatastoreOptions.Builder)DatastoreOptions.newBuilder().setDatabaseId(databaseId).setNamespace(UUID.randomUUID().toString()).setRetrySettings(RemoteDatastoreHelper.retrySettings())).setTransportOptions((TransportOptions)transportOptions).build();
        return new RemoteDatastoreHelper(datastoreOption);
    }

    private static RetrySettings retrySettings() {
        return RetrySettings.newBuilder().setMaxAttempts(10).setMaxRetryDelay(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).setInitialRetryDelay(Duration.ofMillis((long)250L)).setRetryDelayMultiplier(1.0).setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).build();
    }
}

