/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.aggregation;

import com.google.api.core.InternalApi;
import com.google.cloud.datastore.aggregation.AvgAggregation;
import com.google.cloud.datastore.aggregation.CountAggregation;
import com.google.cloud.datastore.aggregation.SumAggregation;
import com.google.datastore.v1.AggregationQuery;

public abstract class Aggregation {
    private final String alias;

    public Aggregation(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    @InternalApi
    public abstract AggregationQuery.Aggregation toPb();

    @InternalApi
    protected AggregationQuery.Aggregation.Builder aggregationBuilder() {
        AggregationQuery.Aggregation.Builder aggregationBuilder = AggregationQuery.Aggregation.newBuilder();
        if (this.getAlias() != null) {
            aggregationBuilder.setAlias(this.getAlias());
        }
        return aggregationBuilder;
    }

    public static CountAggregation.Builder count() {
        return new CountAggregation.Builder();
    }

    public static SumAggregation.Builder sum(String propertyReference) {
        return new SumAggregation.Builder().propertyReference(propertyReference);
    }

    public static AvgAggregation.Builder avg(String propertyReference) {
        return new AvgAggregation.Builder().propertyReference(propertyReference);
    }
}

