/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.BlobValue;
import com.google.cloud.datastore.BooleanValue;
import com.google.cloud.datastore.DoubleValue;
import com.google.cloud.datastore.EntityValue;
import com.google.cloud.datastore.KeyValue;
import com.google.cloud.datastore.LatLngValue;
import com.google.cloud.datastore.ListValue;
import com.google.cloud.datastore.LongValue;
import com.google.cloud.datastore.NullValue;
import com.google.cloud.datastore.RawValue;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.TimestampValue;
import com.google.cloud.datastore.Value;
import com.google.cloud.datastore.ValueBuilder;
import com.google.cloud.datastore.ValueMarshaller;
import com.google.common.collect.ImmutableMap;

public enum ValueType {
    NULL(NullValue.MARSHALLER),
    STRING(StringValue.MARSHALLER),
    ENTITY(EntityValue.MARSHALLER),
    LIST(ListValue.MARSHALLER),
    KEY(KeyValue.MARSHALLER),
    LONG(LongValue.MARSHALLER),
    DOUBLE(DoubleValue.MARSHALLER),
    BOOLEAN(BooleanValue.MARSHALLER),
    TIMESTAMP(TimestampValue.MARSHALLER),
    BLOB(BlobValue.MARSHALLER),
    RAW_VALUE(RawValue.MARSHALLER),
    LAT_LNG(LatLngValue.MARSHALLER);

    private static final ImmutableMap<Integer, ValueType> DESCRIPTOR_TO_TYPE_MAP;
    private final ValueMarshaller marshaller;

    private <V, P extends Value<V>, B extends ValueBuilder<V, P, B>> ValueType(ValueMarshaller<V, P, B> marshaller) {
        this.marshaller = marshaller;
    }

    ValueMarshaller getMarshaller() {
        return this.marshaller;
    }

    static ValueType getByDescriptorId(int descriptorId) {
        return (ValueType)((Object)DESCRIPTOR_TO_TYPE_MAP.get((Object)descriptorId));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ValueType valueType : ValueType.values()) {
            int fieldId = valueType.getMarshaller().getProtoFieldId();
            if (fieldId <= 0) continue;
            builder.put((Object)fieldId, (Object)valueType);
        }
        DESCRIPTOR_TO_TYPE_MAP = builder.buildOrThrow();
    }
}

