/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import io.opentelemetry.api.OpenTelemetry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DatastoreOpenTelemetryOptions {
    private final boolean enabled;
    @Nullable
    private final OpenTelemetry openTelemetry;

    DatastoreOpenTelemetryOptions(Builder builder) {
        this.enabled = builder.enabled;
        this.openTelemetry = builder.openTelemetry;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private boolean enabled;
        @Nullable
        private OpenTelemetry openTelemetry;

        private Builder() {
            this.enabled = false;
            this.openTelemetry = null;
        }

        private Builder(DatastoreOpenTelemetryOptions options) {
            this.enabled = options.enabled;
            this.openTelemetry = options.openTelemetry;
        }

        @Nonnull
        public DatastoreOpenTelemetryOptions build() {
            return new DatastoreOpenTelemetryOptions(this);
        }

        @Nonnull
        public Builder setTracingEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Nonnull
        public Builder setOpenTelemetry(@Nonnull OpenTelemetry openTelemetry) {
            this.openTelemetry = openTelemetry;
            return this;
        }
    }
}

