/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.admin.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datastore.admin.v1.DatastoreAdminClient;
import com.google.cloud.datastore.admin.v1.stub.DatastoreAdminStub;
import com.google.cloud.datastore.admin.v1.stub.GrpcDatastoreAdminStub;
import com.google.cloud.datastore.admin.v1.stub.HttpJsonDatastoreAdminStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.datastore.admin.v1.CreateIndexRequest;
import com.google.datastore.admin.v1.DeleteIndexRequest;
import com.google.datastore.admin.v1.ExportEntitiesMetadata;
import com.google.datastore.admin.v1.ExportEntitiesRequest;
import com.google.datastore.admin.v1.ExportEntitiesResponse;
import com.google.datastore.admin.v1.GetIndexRequest;
import com.google.datastore.admin.v1.ImportEntitiesMetadata;
import com.google.datastore.admin.v1.ImportEntitiesRequest;
import com.google.datastore.admin.v1.Index;
import com.google.datastore.admin.v1.IndexOperationMetadata;
import com.google.datastore.admin.v1.ListIndexesRequest;
import com.google.datastore.admin.v1.ListIndexesResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DatastoreAdminStubSettings
extends StubSettings<DatastoreAdminStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/datastore").build();
    private final UnaryCallSettings<ExportEntitiesRequest, Operation> exportEntitiesSettings;
    private final OperationCallSettings<ExportEntitiesRequest, ExportEntitiesResponse, ExportEntitiesMetadata> exportEntitiesOperationSettings;
    private final UnaryCallSettings<ImportEntitiesRequest, Operation> importEntitiesSettings;
    private final OperationCallSettings<ImportEntitiesRequest, Empty, ImportEntitiesMetadata> importEntitiesOperationSettings;
    private final UnaryCallSettings<CreateIndexRequest, Operation> createIndexSettings;
    private final OperationCallSettings<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationSettings;
    private final UnaryCallSettings<DeleteIndexRequest, Operation> deleteIndexSettings;
    private final OperationCallSettings<DeleteIndexRequest, Index, IndexOperationMetadata> deleteIndexOperationSettings;
    private final UnaryCallSettings<GetIndexRequest, Index> getIndexSettings;
    private final PagedCallSettings<ListIndexesRequest, ListIndexesResponse, DatastoreAdminClient.ListIndexesPagedResponse> listIndexesSettings;
    private static final PagedListDescriptor<ListIndexesRequest, ListIndexesResponse, Index> LIST_INDEXES_PAGE_STR_DESC = new PagedListDescriptor<ListIndexesRequest, ListIndexesResponse, Index>(){

        public String emptyToken() {
            return "";
        }

        public ListIndexesRequest injectToken(ListIndexesRequest payload, String token) {
            return ListIndexesRequest.newBuilder((ListIndexesRequest)payload).setPageToken(token).build();
        }

        public ListIndexesRequest injectPageSize(ListIndexesRequest payload, int pageSize) {
            return ListIndexesRequest.newBuilder((ListIndexesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListIndexesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListIndexesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Index> extractResources(ListIndexesResponse payload) {
            return payload.getIndexesList();
        }
    };
    private static final PagedListResponseFactory<ListIndexesRequest, ListIndexesResponse, DatastoreAdminClient.ListIndexesPagedResponse> LIST_INDEXES_PAGE_STR_FACT = new PagedListResponseFactory<ListIndexesRequest, ListIndexesResponse, DatastoreAdminClient.ListIndexesPagedResponse>(){

        public ApiFuture<DatastoreAdminClient.ListIndexesPagedResponse> getFuturePagedResponse(UnaryCallable<ListIndexesRequest, ListIndexesResponse> callable, ListIndexesRequest request, ApiCallContext context, ApiFuture<ListIndexesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INDEXES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatastoreAdminClient.ListIndexesPagedResponse.createAsync((PageContext<ListIndexesRequest, ListIndexesResponse, Index>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<ExportEntitiesRequest, Operation> exportEntitiesSettings() {
        return this.exportEntitiesSettings;
    }

    public OperationCallSettings<ExportEntitiesRequest, ExportEntitiesResponse, ExportEntitiesMetadata> exportEntitiesOperationSettings() {
        return this.exportEntitiesOperationSettings;
    }

    public UnaryCallSettings<ImportEntitiesRequest, Operation> importEntitiesSettings() {
        return this.importEntitiesSettings;
    }

    public OperationCallSettings<ImportEntitiesRequest, Empty, ImportEntitiesMetadata> importEntitiesOperationSettings() {
        return this.importEntitiesOperationSettings;
    }

    public UnaryCallSettings<CreateIndexRequest, Operation> createIndexSettings() {
        return this.createIndexSettings;
    }

    public OperationCallSettings<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationSettings() {
        return this.createIndexOperationSettings;
    }

    public UnaryCallSettings<DeleteIndexRequest, Operation> deleteIndexSettings() {
        return this.deleteIndexSettings;
    }

    public OperationCallSettings<DeleteIndexRequest, Index, IndexOperationMetadata> deleteIndexOperationSettings() {
        return this.deleteIndexOperationSettings;
    }

    public UnaryCallSettings<GetIndexRequest, Index> getIndexSettings() {
        return this.getIndexSettings;
    }

    public PagedCallSettings<ListIndexesRequest, ListIndexesResponse, DatastoreAdminClient.ListIndexesPagedResponse> listIndexesSettings() {
        return this.listIndexesSettings;
    }

    public DatastoreAdminStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDatastoreAdminStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDatastoreAdminStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "datastore";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "datastore.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "datastore.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DatastoreAdminStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DatastoreAdminStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DatastoreAdminStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DatastoreAdminStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DatastoreAdminStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.exportEntitiesSettings = settingsBuilder.exportEntitiesSettings().build();
        this.exportEntitiesOperationSettings = settingsBuilder.exportEntitiesOperationSettings().build();
        this.importEntitiesSettings = settingsBuilder.importEntitiesSettings().build();
        this.importEntitiesOperationSettings = settingsBuilder.importEntitiesOperationSettings().build();
        this.createIndexSettings = settingsBuilder.createIndexSettings().build();
        this.createIndexOperationSettings = settingsBuilder.createIndexOperationSettings().build();
        this.deleteIndexSettings = settingsBuilder.deleteIndexSettings().build();
        this.deleteIndexOperationSettings = settingsBuilder.deleteIndexOperationSettings().build();
        this.getIndexSettings = settingsBuilder.getIndexSettings().build();
        this.listIndexesSettings = settingsBuilder.listIndexesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DatastoreAdminStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ExportEntitiesRequest, Operation> exportEntitiesSettings;
        private final OperationCallSettings.Builder<ExportEntitiesRequest, ExportEntitiesResponse, ExportEntitiesMetadata> exportEntitiesOperationSettings;
        private final UnaryCallSettings.Builder<ImportEntitiesRequest, Operation> importEntitiesSettings;
        private final OperationCallSettings.Builder<ImportEntitiesRequest, Empty, ImportEntitiesMetadata> importEntitiesOperationSettings;
        private final UnaryCallSettings.Builder<CreateIndexRequest, Operation> createIndexSettings;
        private final OperationCallSettings.Builder<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationSettings;
        private final UnaryCallSettings.Builder<DeleteIndexRequest, Operation> deleteIndexSettings;
        private final OperationCallSettings.Builder<DeleteIndexRequest, Index, IndexOperationMetadata> deleteIndexOperationSettings;
        private final UnaryCallSettings.Builder<GetIndexRequest, Index> getIndexSettings;
        private final PagedCallSettings.Builder<ListIndexesRequest, ListIndexesResponse, DatastoreAdminClient.ListIndexesPagedResponse> listIndexesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.exportEntitiesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportEntitiesOperationSettings = OperationCallSettings.newBuilder();
            this.importEntitiesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importEntitiesOperationSettings = OperationCallSettings.newBuilder();
            this.createIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createIndexOperationSettings = OperationCallSettings.newBuilder();
            this.deleteIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteIndexOperationSettings = OperationCallSettings.newBuilder();
            this.getIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listIndexesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INDEXES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.exportEntitiesSettings, this.importEntitiesSettings, this.createIndexSettings, this.deleteIndexSettings, this.getIndexSettings, this.listIndexesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DatastoreAdminStubSettings settings) {
            super((StubSettings)settings);
            this.exportEntitiesSettings = settings.exportEntitiesSettings.toBuilder();
            this.exportEntitiesOperationSettings = settings.exportEntitiesOperationSettings.toBuilder();
            this.importEntitiesSettings = settings.importEntitiesSettings.toBuilder();
            this.importEntitiesOperationSettings = settings.importEntitiesOperationSettings.toBuilder();
            this.createIndexSettings = settings.createIndexSettings.toBuilder();
            this.createIndexOperationSettings = settings.createIndexOperationSettings.toBuilder();
            this.deleteIndexSettings = settings.deleteIndexSettings.toBuilder();
            this.deleteIndexOperationSettings = settings.deleteIndexOperationSettings.toBuilder();
            this.getIndexSettings = settings.getIndexSettings.toBuilder();
            this.listIndexesSettings = settings.listIndexesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.exportEntitiesSettings, this.importEntitiesSettings, this.createIndexSettings, this.deleteIndexSettings, this.getIndexSettings, this.listIndexesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DatastoreAdminStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DatastoreAdminStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DatastoreAdminStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DatastoreAdminStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DatastoreAdminStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DatastoreAdminStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DatastoreAdminStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DatastoreAdminStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.exportEntitiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.importEntitiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listIndexesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.exportEntitiesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportEntitiesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ExportEntitiesMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.importEntitiesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportEntitiesMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createIndexOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Index.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(IndexOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteIndexOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Index.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(IndexOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ExportEntitiesRequest, Operation> exportEntitiesSettings() {
            return this.exportEntitiesSettings;
        }

        public OperationCallSettings.Builder<ExportEntitiesRequest, ExportEntitiesResponse, ExportEntitiesMetadata> exportEntitiesOperationSettings() {
            return this.exportEntitiesOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportEntitiesRequest, Operation> importEntitiesSettings() {
            return this.importEntitiesSettings;
        }

        public OperationCallSettings.Builder<ImportEntitiesRequest, Empty, ImportEntitiesMetadata> importEntitiesOperationSettings() {
            return this.importEntitiesOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateIndexRequest, Operation> createIndexSettings() {
            return this.createIndexSettings;
        }

        public OperationCallSettings.Builder<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationSettings() {
            return this.createIndexOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteIndexRequest, Operation> deleteIndexSettings() {
            return this.deleteIndexSettings;
        }

        public OperationCallSettings.Builder<DeleteIndexRequest, Index, IndexOperationMetadata> deleteIndexOperationSettings() {
            return this.deleteIndexOperationSettings;
        }

        public UnaryCallSettings.Builder<GetIndexRequest, Index> getIndexSettings() {
            return this.getIndexSettings;
        }

        public PagedCallSettings.Builder<ListIndexesRequest, ListIndexesResponse, DatastoreAdminClient.ListIndexesPagedResponse> listIndexesSettings() {
            return this.listIndexesSettings;
        }

        public DatastoreAdminStubSettings build() throws IOException {
            return new DatastoreAdminStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

