/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.testing;

import com.google.api.core.InternalApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.util.TimeConversionUtils;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.testing.BaseEmulatorHelper;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.threeten.bp.Duration;

@InternalApi
public class LocalDatastoreHelper
extends BaseEmulatorHelper<DatastoreOptions> {
    private final List<BaseEmulatorHelper.EmulatorRunner> emulatorRunners;
    private final double consistency;
    private final Path gcdPath;
    private boolean storeOnDisk;
    private static final String GCLOUD_CMD_TEXT = "gcloud beta emulators datastore start";
    private static final String GCLOUD_CMD_PORT_FLAG = "--host-port=";
    private static final String VERSION_PREFIX = "cloud-datastore-emulator ";
    private static final String MIN_VERSION = "2.0.2";
    private static final String BIN_NAME = "cloud-datastore-emulator/cloud_datastore_emulator";
    private static final String FILENAME = "cloud-datastore-emulator-2.0.2.zip";
    private static final String MD5_CHECKSUM = "e0d1170519cf52e2e5f9f93892cdf70c";
    private static final String BIN_CMD_PORT_FLAG = "--port=";
    private static final URL EMULATOR_URL;
    private static final String EMULATOR_URL_ENV_VAR = "DATASTORE_EMULATOR_URL";
    private static final String ACCESS_TOKEN;
    private static final String CONSISTENCY_FLAG = "--consistency=";
    private static final String PROJECT_FLAG = "--project=";
    private static final double DEFAULT_CONSISTENCY = 0.9;
    private static final String DEFAULT_PROJECT_ID;
    private static final Logger LOGGER;
    private final DatastoreOptions.Builder optionsBuilder = (DatastoreOptions.Builder)((DatastoreOptions.Builder)((DatastoreOptions.Builder)((DatastoreOptions.Builder)DatastoreOptions.newBuilder().setProjectId(this.getProjectId())).setHost("localhost:" + this.getPort())).setCredentials((Credentials)NoCredentials.getInstance())).setRetrySettings(ServiceOptions.getNoRetrySettings());

    private LocalDatastoreHelper(Builder builder) {
        super("datastore", builder.port > 0 ? builder.port : BaseEmulatorHelper.findAvailablePort((int)8080), (String)MoreObjects.firstNonNull((Object)builder.projectId, (Object)DEFAULT_PROJECT_ID));
        String projectId = (String)MoreObjects.firstNonNull((Object)builder.projectId, (Object)DEFAULT_PROJECT_ID);
        this.consistency = builder.consistency > 0.0 ? builder.consistency : 0.9;
        this.gcdPath = builder.dataDir;
        this.storeOnDisk = builder.storeOnDisk;
        String binName = BIN_NAME;
        if (LocalDatastoreHelper.isWindows()) {
            binName = BIN_NAME.replace("/", "\\");
        }
        ArrayList<String> gcloudCommand = new ArrayList<String>(Arrays.asList(GCLOUD_CMD_TEXT.split(" ")));
        gcloudCommand.add("--host-port=localhost:" + this.getPort());
        gcloudCommand.add(CONSISTENCY_FLAG + builder.consistency);
        gcloudCommand.add(PROJECT_FLAG + projectId);
        if (!builder.storeOnDisk) {
            gcloudCommand.add("--no-store-on-disk");
        }
        if (builder.dataDir != null) {
            gcloudCommand.add("--data-dir=" + this.getGcdPath());
        }
        BaseEmulatorHelper.GcloudEmulatorRunner gcloudRunner = new BaseEmulatorHelper.GcloudEmulatorRunner(gcloudCommand, VERSION_PREFIX, MIN_VERSION);
        ArrayList<String> binCommand = new ArrayList<String>(Arrays.asList(binName, "start"));
        binCommand.add("--testing");
        binCommand.add(BIN_CMD_PORT_FLAG + this.getPort());
        binCommand.add(CONSISTENCY_FLAG + this.getConsistency());
        BaseEmulatorHelper.DownloadableEmulatorRunner downloadRunner = new BaseEmulatorHelper.DownloadableEmulatorRunner(binCommand, EMULATOR_URL, MD5_CHECKSUM, ACCESS_TOKEN);
        this.emulatorRunners = ImmutableList.of((Object)gcloudRunner, (Object)downloadRunner);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    protected List<BaseEmulatorHelper.EmulatorRunner> getEmulatorRunners() {
        return this.emulatorRunners;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public DatastoreOptions getOptions() {
        return this.optionsBuilder.build();
    }

    public DatastoreOptions getOptions(String namespace) {
        return this.optionsBuilder.setNamespace(namespace).build();
    }

    public DatastoreOptions.Builder setNamespace(String namespace) {
        return this.optionsBuilder.setNamespace(namespace);
    }

    public double getConsistency() {
        return this.consistency;
    }

    public Path getGcdPath() {
        return this.gcdPath;
    }

    public boolean isStoreOnDisk() {
        return this.storeOnDisk;
    }

    public static LocalDatastoreHelper create(double consistency) {
        return LocalDatastoreHelper.newBuilder().setConsistency(consistency).setPort(0).build();
    }

    public static LocalDatastoreHelper create(double consistency, int port) {
        return LocalDatastoreHelper.newBuilder().setConsistency(consistency).setPort(port).build();
    }

    public static LocalDatastoreHelper create(int port) {
        return LocalDatastoreHelper.newBuilder().setConsistency(0.9).setPort(port).build();
    }

    public static LocalDatastoreHelper create() {
        return LocalDatastoreHelper.newBuilder().setConsistency(0.9).build();
    }

    public void start() throws IOException, InterruptedException {
        String blockUntilOutput = "Dev App Server is now running";
        this.startProcess(blockUntilOutput);
    }

    public void reset() throws IOException {
        this.sendPostRequest("/reset");
    }

    @ObsoleteApi(value="Use stopDuration(java.time.Duration) instead")
    public void stop(Duration timeout) throws IOException, InterruptedException, TimeoutException {
        this.stopDuration(TimeConversionUtils.toJavaTimeDuration((Duration)timeout));
    }

    public void stopDuration(java.time.Duration timeout) throws IOException, InterruptedException, TimeoutException {
        this.sendPostRequest("/shutdown");
        this.waitForProcessDuration(timeout);
        LocalDatastoreHelper.deleteRecursively(this.gcdPath);
    }

    public void stop() throws IOException, InterruptedException, TimeoutException {
        this.stopDuration(java.time.Duration.ofSeconds(20L));
    }

    static void deleteRecursively(Path path) throws IOException {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static {
        ACCESS_TOKEN = System.getenv("DATASTORE_EMULATOR_ACCESS_TOKEN");
        DEFAULT_PROJECT_ID = "test-project-" + UUID.randomUUID();
        LOGGER = Logger.getLogger(LocalDatastoreHelper.class.getName());
        try {
            EMULATOR_URL = System.getenv(EMULATOR_URL_ENV_VAR) == null ? new URL("http://storage.googleapis.com/gcd/tools/cloud-datastore-emulator-2.0.2.zip") : new URL(System.getenv(EMULATOR_URL_ENV_VAR));
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static class Builder {
        private double consistency;
        private int port;
        private Path dataDir;
        private boolean storeOnDisk = true;
        private String projectId;

        private Builder() {
        }

        private Builder(LocalDatastoreHelper helper) {
            this.consistency = helper.consistency;
            this.dataDir = helper.gcdPath;
            this.storeOnDisk = helper.storeOnDisk;
        }

        public Builder setConsistency(double consistency) {
            this.consistency = consistency;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setDataDir(Path dataDir) {
            this.dataDir = dataDir;
            return this;
        }

        public Builder setStoreOnDisk(boolean storeOnDisk) {
            this.storeOnDisk = storeOnDisk;
            return this;
        }

        public LocalDatastoreHelper build() {
            return new LocalDatastoreHelper(this);
        }
    }
}

