/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.core.ApiClock;
import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.BaseService;
import com.google.cloud.RetryHelper;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.spi.v1.DatastoreRpc;
import com.google.cloud.datastore.telemetry.TraceUtil;
import com.google.datastore.v1.AllocateIdsRequest;
import com.google.datastore.v1.AllocateIdsResponse;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.BeginTransactionResponse;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.LookupRequest;
import com.google.datastore.v1.LookupResponse;
import com.google.datastore.v1.ReadOptions;
import com.google.datastore.v1.ReserveIdsRequest;
import com.google.datastore.v1.ReserveIdsResponse;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.RollbackResponse;
import com.google.datastore.v1.RunAggregationQueryRequest;
import com.google.datastore.v1.RunAggregationQueryResponse;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import java.util.concurrent.Callable;

@InternalApi
public class RetryAndTraceDatastoreRpcDecorator
implements DatastoreRpc {
    private final DatastoreRpc datastoreRpc;
    private final TraceUtil otelTraceUtil;
    private final RetrySettings retrySettings;
    private final DatastoreOptions datastoreOptions;

    public RetryAndTraceDatastoreRpcDecorator(DatastoreRpc datastoreRpc, TraceUtil otelTraceUtil, RetrySettings retrySettings, DatastoreOptions datastoreOptions) {
        this.datastoreRpc = datastoreRpc;
        this.retrySettings = retrySettings;
        this.datastoreOptions = datastoreOptions;
        this.otelTraceUtil = otelTraceUtil;
    }

    @Override
    public AllocateIdsResponse allocateIds(AllocateIdsRequest request) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public BeginTransactionResponse beginTransaction(BeginTransactionRequest request) throws DatastoreException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public CommitResponse commit(CommitRequest request) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public LookupResponse lookup(LookupRequest request) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public ReserveIdsResponse reserveIds(ReserveIdsRequest request) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public RollbackResponse rollback(RollbackRequest request) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public RunQueryResponse runQuery(RunQueryRequest request) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public RunAggregationQueryResponse runAggregationQuery(RunAggregationQueryRequest request) {
        ReadOptions readOptions = request.getReadOptions();
        boolean isTransactional = readOptions.hasTransaction() || readOptions.hasNewTransaction();
        String spanName = isTransactional ? "Transaction.RunAggregationQuery" : "RunAggregationQuery";
        return this.invokeRpc(() -> this.datastoreRpc.runAggregationQuery(request), spanName);
    }

    public <O> O invokeRpc(Callable<O> block, String startSpan) {
        TraceUtil.Span span = this.otelTraceUtil.startSpan(startSpan);
        try {
            Object object;
            block11: {
                TraceUtil.Scope ignored = span.makeCurrent();
                try {
                    object = RetryHelper.runWithRetries(block, (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)BaseService.EXCEPTION_HANDLER, (ApiClock)this.datastoreOptions.getClock());
                    if (ignored == null) break block11;
                    ignored.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RetryHelper.RetryHelperException e) {
                        span.end(e);
                        throw DatastoreException.translateAndThrow(e);
                    }
                }
            }
            return (O)object;
        }
        finally {
            span.end();
        }
    }
}

