/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.datastore.v1.stub.DatastoreStub;
import com.google.cloud.datastore.v1.stub.GrpcDatastoreStub;
import com.google.cloud.datastore.v1.stub.HttpJsonDatastoreStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.datastore.v1.AllocateIdsRequest;
import com.google.datastore.v1.AllocateIdsResponse;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.BeginTransactionResponse;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.LookupRequest;
import com.google.datastore.v1.LookupResponse;
import com.google.datastore.v1.ReserveIdsRequest;
import com.google.datastore.v1.ReserveIdsResponse;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.RollbackResponse;
import com.google.datastore.v1.RunAggregationQueryRequest;
import com.google.datastore.v1.RunAggregationQueryResponse;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DatastoreStubSettings
extends StubSettings<DatastoreStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/datastore").build();
    private final UnaryCallSettings<LookupRequest, LookupResponse> lookupSettings;
    private final UnaryCallSettings<RunQueryRequest, RunQueryResponse> runQuerySettings;
    private final UnaryCallSettings<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQuerySettings;
    private final UnaryCallSettings<BeginTransactionRequest, BeginTransactionResponse> beginTransactionSettings;
    private final UnaryCallSettings<CommitRequest, CommitResponse> commitSettings;
    private final UnaryCallSettings<RollbackRequest, RollbackResponse> rollbackSettings;
    private final UnaryCallSettings<AllocateIdsRequest, AllocateIdsResponse> allocateIdsSettings;
    private final UnaryCallSettings<ReserveIdsRequest, ReserveIdsResponse> reserveIdsSettings;

    public UnaryCallSettings<LookupRequest, LookupResponse> lookupSettings() {
        return this.lookupSettings;
    }

    public UnaryCallSettings<RunQueryRequest, RunQueryResponse> runQuerySettings() {
        return this.runQuerySettings;
    }

    public UnaryCallSettings<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQuerySettings() {
        return this.runAggregationQuerySettings;
    }

    public UnaryCallSettings<BeginTransactionRequest, BeginTransactionResponse> beginTransactionSettings() {
        return this.beginTransactionSettings;
    }

    public UnaryCallSettings<CommitRequest, CommitResponse> commitSettings() {
        return this.commitSettings;
    }

    public UnaryCallSettings<RollbackRequest, RollbackResponse> rollbackSettings() {
        return this.rollbackSettings;
    }

    public UnaryCallSettings<AllocateIdsRequest, AllocateIdsResponse> allocateIdsSettings() {
        return this.allocateIdsSettings;
    }

    public UnaryCallSettings<ReserveIdsRequest, ReserveIdsResponse> reserveIdsSettings() {
        return this.reserveIdsSettings;
    }

    public DatastoreStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDatastoreStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDatastoreStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "datastore";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "datastore.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "datastore.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DatastoreStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DatastoreStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DatastoreStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DatastoreStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DatastoreStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.lookupSettings = settingsBuilder.lookupSettings().build();
        this.runQuerySettings = settingsBuilder.runQuerySettings().build();
        this.runAggregationQuerySettings = settingsBuilder.runAggregationQuerySettings().build();
        this.beginTransactionSettings = settingsBuilder.beginTransactionSettings().build();
        this.commitSettings = settingsBuilder.commitSettings().build();
        this.rollbackSettings = settingsBuilder.rollbackSettings().build();
        this.allocateIdsSettings = settingsBuilder.allocateIdsSettings().build();
        this.reserveIdsSettings = settingsBuilder.reserveIdsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DatastoreStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<LookupRequest, LookupResponse> lookupSettings;
        private final UnaryCallSettings.Builder<RunQueryRequest, RunQueryResponse> runQuerySettings;
        private final UnaryCallSettings.Builder<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQuerySettings;
        private final UnaryCallSettings.Builder<BeginTransactionRequest, BeginTransactionResponse> beginTransactionSettings;
        private final UnaryCallSettings.Builder<CommitRequest, CommitResponse> commitSettings;
        private final UnaryCallSettings.Builder<RollbackRequest, RollbackResponse> rollbackSettings;
        private final UnaryCallSettings.Builder<AllocateIdsRequest, AllocateIdsResponse> allocateIdsSettings;
        private final UnaryCallSettings.Builder<ReserveIdsRequest, ReserveIdsResponse> reserveIdsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.lookupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runQuerySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runAggregationQuerySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.beginTransactionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.commitSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.rollbackSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.allocateIdsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.reserveIdsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.lookupSettings, this.runQuerySettings, this.runAggregationQuerySettings, this.beginTransactionSettings, this.commitSettings, this.rollbackSettings, this.allocateIdsSettings, this.reserveIdsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DatastoreStubSettings settings) {
            super((StubSettings)settings);
            this.lookupSettings = settings.lookupSettings.toBuilder();
            this.runQuerySettings = settings.runQuerySettings.toBuilder();
            this.runAggregationQuerySettings = settings.runAggregationQuerySettings.toBuilder();
            this.beginTransactionSettings = settings.beginTransactionSettings.toBuilder();
            this.commitSettings = settings.commitSettings.toBuilder();
            this.rollbackSettings = settings.rollbackSettings.toBuilder();
            this.allocateIdsSettings = settings.allocateIdsSettings.toBuilder();
            this.reserveIdsSettings = settings.reserveIdsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.lookupSettings, this.runQuerySettings, this.runAggregationQuerySettings, this.beginTransactionSettings, this.commitSettings, this.rollbackSettings, this.allocateIdsSettings, this.reserveIdsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DatastoreStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DatastoreStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DatastoreStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DatastoreStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DatastoreStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DatastoreStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DatastoreStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DatastoreStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.lookupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.runQuerySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.runAggregationQuerySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.beginTransactionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.commitSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.rollbackSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.allocateIdsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.reserveIdsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<LookupRequest, LookupResponse> lookupSettings() {
            return this.lookupSettings;
        }

        public UnaryCallSettings.Builder<RunQueryRequest, RunQueryResponse> runQuerySettings() {
            return this.runQuerySettings;
        }

        public UnaryCallSettings.Builder<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQuerySettings() {
            return this.runAggregationQuerySettings;
        }

        public UnaryCallSettings.Builder<BeginTransactionRequest, BeginTransactionResponse> beginTransactionSettings() {
            return this.beginTransactionSettings;
        }

        public UnaryCallSettings.Builder<CommitRequest, CommitResponse> commitSettings() {
            return this.commitSettings;
        }

        public UnaryCallSettings.Builder<RollbackRequest, RollbackResponse> rollbackSettings() {
            return this.rollbackSettings;
        }

        public UnaryCallSettings.Builder<AllocateIdsRequest, AllocateIdsResponse> allocateIdsSettings() {
            return this.allocateIdsSettings;
        }

        public UnaryCallSettings.Builder<ReserveIdsRequest, ReserveIdsResponse> reserveIdsSettings() {
            return this.reserveIdsSettings;
        }

        public DatastoreStubSettings build() throws IOException {
            return new DatastoreStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

