/*
 * Copyright 2015 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.cloud.datastore.spi;

import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.spi.ServiceRpcFactory;

/**
 * An interface for Datastore RPC factory. Implementation will be loaded via {@link
 * java.util.ServiceLoader}.
 */
@InternalExtensionOnly
public interface DatastoreRpcFactory extends ServiceRpcFactory<DatastoreOptions> {}
