/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.ServiceRpc;
import com.google.cloud.TransportOptions;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreFactory;
import com.google.cloud.datastore.DatastoreImpl;
import com.google.cloud.datastore.DatastoreOpenTelemetryOptions;
import com.google.cloud.datastore.Validator;
import com.google.cloud.datastore.spi.DatastoreRpcFactory;
import com.google.cloud.datastore.spi.v1.DatastoreRpc;
import com.google.cloud.datastore.spi.v1.GrpcDatastoreRpc;
import com.google.cloud.datastore.spi.v1.HttpDatastoreRpc;
import com.google.cloud.datastore.telemetry.TraceUtil;
import com.google.cloud.datastore.v1.DatastoreSettings;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DatastoreOptions
extends ServiceOptions<Datastore, DatastoreOptions> {
    private static final long serialVersionUID = -1018382430058137336L;
    private static final String API_SHORT_NAME = "Datastore";
    private static final String DATASTORE_SCOPE = "https://www.googleapis.com/auth/datastore";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/datastore");
    private static final String DEFAULT_DATABASE_ID = "";
    public static final String PROJECT_ID_ENV_VAR = "DATASTORE_PROJECT_ID";
    public static final String LOCAL_HOST_ENV_VAR = "DATASTORE_EMULATOR_HOST";
    public static final int INIT_CHANNEL_COUNT = 1;
    public static final int MIN_CHANNEL_COUNT = 1;
    public static final int MAX_CHANNEL_COUNT = 4;
    private transient TransportChannelProvider channelProvider = null;
    private final String namespace;
    private final String databaseId;
    @Nonnull
    private final transient DatastoreOpenTelemetryOptions openTelemetryOptions;
    @Nonnull
    private final transient TraceUtil traceUtil;

    @Nonnull
    TraceUtil getTraceUtil() {
        return this.traceUtil;
    }

    @BetaApi
    @Nonnull
    public DatastoreOpenTelemetryOptions getOpenTelemetryOptions() {
        return this.openTelemetryOptions;
    }

    private static TransportChannelProvider validateChannelProvider(TransportChannelProvider channelProvider) {
        if (channelProvider != null && !(channelProvider instanceof InstantiatingGrpcChannelProvider)) {
            throw new IllegalArgumentException("Only GRPC channels are allowed for Datastore.");
        }
        return channelProvider;
    }

    private DatastoreOptions(Builder builder) {
        super(DatastoreFactory.class, DatastoreRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new DatastoreDefaults());
        this.openTelemetryOptions = builder.openTelemetryOptions != null ? builder.openTelemetryOptions : DatastoreOpenTelemetryOptions.newBuilder().build();
        this.traceUtil = TraceUtil.getInstance(this);
        this.namespace = (String)MoreObjects.firstNonNull((Object)builder.namespace, (Object)DatastoreOptions.defaultNamespace());
        this.databaseId = (String)MoreObjects.firstNonNull((Object)builder.databaseId, (Object)DEFAULT_DATABASE_ID);
        if (this.getTransportOptions() instanceof HttpTransportOptions && builder.channelProvider != null) {
            throw new IllegalArgumentException("Only gRPC transport allows setting of channel provider or credentials provider");
        }
        if (this.getTransportOptions() instanceof GrpcTransportOptions) {
            this.channelProvider = builder.channelProvider != null ? builder.channelProvider : GrpcTransportOptions.setUpChannelProvider((InstantiatingGrpcChannelProvider.Builder)DatastoreSettings.defaultGrpcTransportProviderBuilder().setChannelPoolSettings(ChannelPoolSettings.builder().setInitialChannelCount(1).setMinChannelCount(1).setMaxChannelCount(4).build()), (ServiceOptions)this);
        }
    }

    public TransportChannelProvider getTransportChannelProvider() {
        return this.channelProvider;
    }

    protected String getDefaultHost() {
        String host = System.getProperty(LOCAL_HOST_ENV_VAR, System.getenv(LOCAL_HOST_ENV_VAR));
        return host != null ? host : "https://datastore.googleapis.com";
    }

    protected String getDefaultProject() {
        String projectId = System.getProperty(PROJECT_ID_ENV_VAR, System.getenv(PROJECT_ID_ENV_VAR));
        return projectId != null ? projectId : super.getDefaultProject();
    }

    public static HttpTransportOptions getDefaultHttpTransportOptions() {
        return HttpTransportOptions.newBuilder().build();
    }

    public static GrpcTransportOptions getDefaultGrpcTransportOptions() {
        return GrpcTransportOptions.newBuilder().build();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public static DatastoreOptions getDefaultInstance() {
        return DatastoreOptions.newBuilder().build();
    }

    private static String defaultNamespace() {
        try {
            Class<?> clazz = Class.forName("com.google.appengine.api.NamespaceManager");
            Method method = clazz.getMethod("get", new Class[0]);
            String namespace = (String)method.invoke(null, new Object[0]);
            return (String)MoreObjects.firstNonNull((Object)namespace, (Object)DEFAULT_DATABASE_ID);
        }
        catch (Exception ignore) {
            return DEFAULT_DATABASE_ID;
        }
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    protected DatastoreRpc getDatastoreRpcV1() {
        return (DatastoreRpc)this.getRpc();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.namespace, this.databaseId);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DatastoreOptions)) {
            return false;
        }
        DatastoreOptions other = (DatastoreOptions)((Object)obj);
        return this.baseEquals(other) && Objects.equals(this.namespace, other.namespace) && Objects.equals(this.databaseId, other.databaseId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceOptions.Builder<Datastore, DatastoreOptions, Builder> {
        private String namespace;
        private String databaseId;
        private TransportChannelProvider channelProvider = null;
        private String host;
        private TransportOptions transportOptions;
        @Nullable
        private DatastoreOpenTelemetryOptions openTelemetryOptions = null;

        private Builder() {
        }

        private Builder(DatastoreOptions options) {
            super((ServiceOptions)options);
            this.namespace = options.namespace;
            this.databaseId = options.databaseId;
            this.openTelemetryOptions = options.openTelemetryOptions;
            this.channelProvider = DatastoreOptions.validateChannelProvider(options.channelProvider);
        }

        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof HttpTransportOptions)) {
                throw new IllegalArgumentException("Only http transport is allowed for Datastore.");
            }
            this.transportOptions = transportOptions;
            return (Builder)super.setTransportOptions(transportOptions);
        }

        @BetaApi
        public Builder setTransportOptions(GrpcTransportOptions transportOptions) {
            this.transportOptions = transportOptions;
            return (Builder)super.setTransportOptions((TransportOptions)transportOptions);
        }

        public Builder setHost(String host) {
            this.host = host;
            return (Builder)super.setHost(host);
        }

        @BetaApi
        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = DatastoreOptions.validateChannelProvider(channelProvider);
            return this;
        }

        public DatastoreOptions build() {
            if (this.host == null && this.transportOptions instanceof GrpcTransportOptions) {
                this.setHost(DatastoreSettings.getDefaultEndpoint());
            }
            return new DatastoreOptions(this);
        }

        public Builder setNamespace(String namespace) {
            this.namespace = Validator.validateNamespace(namespace);
            return this;
        }

        public Builder setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        @BetaApi
        @Nonnull
        public Builder setOpenTelemetryOptions(@Nonnull DatastoreOpenTelemetryOptions openTelemetryOptions) {
            this.openTelemetryOptions = openTelemetryOptions;
            return this;
        }
    }

    private static class DatastoreDefaults
    implements ServiceDefaults<Datastore, DatastoreOptions> {
        private final TransportOptions TRANSPORT_OPTIONS = DatastoreDefaults.getDefaultTransportOptionsBuilder().build();

        private DatastoreDefaults() {
        }

        public DatastoreFactory getDefaultServiceFactory() {
            return DefaultDatastoreFactory.INSTANCE;
        }

        public DatastoreRpcFactory getDefaultRpcFactory() {
            return DefaultDatastoreRpcFactory.INSTANCE;
        }

        public TransportOptions getDefaultTransportOptions() {
            return this.TRANSPORT_OPTIONS;
        }

        public static HttpTransportOptions.Builder getDefaultTransportOptionsBuilder() {
            return HttpTransportOptions.newBuilder();
        }
    }

    public static class DefaultDatastoreRpcFactory
    implements DatastoreRpcFactory {
        private static final DatastoreRpcFactory INSTANCE = new DefaultDatastoreRpcFactory();

        public ServiceRpc create(DatastoreOptions options) {
            try {
                if (options.getTransportOptions() instanceof GrpcTransportOptions) {
                    return new GrpcDatastoreRpc(options);
                }
                return new HttpDatastoreRpc(options);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class DefaultDatastoreFactory
    implements DatastoreFactory {
        private static final DatastoreFactory INSTANCE = new DefaultDatastoreFactory();

        public Datastore create(DatastoreOptions options) {
            return new DatastoreImpl(options);
        }
    }
}

