/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.BaseServiceException;
import com.google.cloud.RetryHelper;
import com.google.cloud.datastore.GrpcToDatastoreCodeTranslation;
import com.google.cloud.http.BaseHttpServiceException;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Set;

public final class DatastoreException
extends BaseHttpServiceException {
    private static final Set<BaseServiceException.Error> RETRYABLE_ERRORS = ImmutableSet.of((Object)new BaseServiceException.Error(Integer.valueOf(10), "ABORTED", false), (Object)new BaseServiceException.Error(Integer.valueOf(4), "DEADLINE_EXCEEDED", false), (Object)new BaseServiceException.Error(Integer.valueOf(14), "UNAVAILABLE", true));
    private static final long serialVersionUID = 2663750991205874435L;

    public DatastoreException(int code, String message, String reason) {
        this(code, message, reason, true, null);
    }

    public DatastoreException(int code, String message, Throwable cause) {
        super(code, message, null, true, RETRYABLE_ERRORS, cause);
    }

    public DatastoreException(int code, String message, String reason, Throwable cause) {
        super(code, message, reason, true, RETRYABLE_ERRORS, cause);
    }

    public DatastoreException(int code, String message, String reason, boolean idempotent, Throwable cause) {
        super(code, message, reason, idempotent, RETRYABLE_ERRORS, cause);
    }

    public DatastoreException(IOException exception) {
        super(exception, true, RETRYABLE_ERRORS);
    }

    static DatastoreException translateAndThrow(RetryHelper.RetryHelperException ex) {
        BaseServiceException.translate((RetryHelper.RetryHelperException)ex);
        throw DatastoreException.transformThrowable((Throwable)ex);
    }

    static BaseServiceException transformThrowable(Throwable t) {
        if (t instanceof BaseServiceException) {
            return (BaseServiceException)t;
        }
        if (t.getCause() instanceof BaseServiceException) {
            return (BaseServiceException)t.getCause();
        }
        if (t instanceof ApiException) {
            return DatastoreException.asDatastoreException((ApiException)t);
        }
        if (t.getCause() instanceof ApiException) {
            return DatastoreException.asDatastoreException((ApiException)t.getCause());
        }
        return DatastoreException.getDatastoreException(t);
    }

    private static DatastoreException getDatastoreException(Throwable t) {
        if (t instanceof RetryHelper.RetryHelperException) {
            return new DatastoreException(0, t.getMessage(), null, t.getCause());
        }
        return new DatastoreException(0, t.getMessage(), t);
    }

    static DatastoreException asDatastoreException(ApiException apiEx) {
        int datastoreStatusCode = 0;
        StatusCode statusCode = apiEx.getStatusCode();
        if (statusCode instanceof GrpcStatusCode) {
            GrpcStatusCode gsc = (GrpcStatusCode)statusCode;
            datastoreStatusCode = GrpcToDatastoreCodeTranslation.grpcCodeToDatastoreStatusCode(gsc.getTransportCode());
        }
        String statusCodeName = statusCode.getCode().name();
        String statusExceptionMessage = DatastoreException.getStatusExceptionMessage((Exception)apiEx);
        String message = statusExceptionMessage != null ? statusCodeName + ": " + statusExceptionMessage : "Error: " + statusCodeName;
        String reason = "";
        if (Strings.isNullOrEmpty((String)apiEx.getReason()) && apiEx.getStatusCode() != null) {
            reason = apiEx.getStatusCode().getCode().name();
        }
        return new DatastoreException(datastoreStatusCode, message, reason, (Throwable)apiEx);
    }

    private static String getStatusExceptionMessage(Exception apiEx) {
        if (apiEx.getMessage() != null) {
            return apiEx.getMessage();
        }
        Throwable cause = apiEx.getCause();
        if (cause instanceof StatusRuntimeException || cause instanceof StatusException) {
            return cause.getMessage();
        }
        return null;
    }

    static DatastoreException throwInvalidRequest(String massage, Object ... params) {
        throw new DatastoreException(0, String.format(massage, params), "FAILED_PRECONDITION");
    }

    static DatastoreException propagateUserException(Exception ex) {
        throw new DatastoreException(0, ex.getMessage(), null, ex);
    }
}

