/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.Timestamp;
import com.google.cloud.datastore.Blob;
import com.google.cloud.datastore.BlobValue;
import com.google.cloud.datastore.BooleanValue;
import com.google.cloud.datastore.DoubleValue;
import com.google.cloud.datastore.EntityValue;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyValue;
import com.google.cloud.datastore.LatLng;
import com.google.cloud.datastore.LatLngValue;
import com.google.cloud.datastore.LongValue;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.TimestampValue;
import com.google.cloud.datastore.Value;
import com.google.cloud.datastore.ValueType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.datastore.v1.ArrayValue;
import com.google.datastore.v1.Value;
import java.util.ArrayList;
import java.util.List;

public final class ListValue
extends Value<List<? extends Value<?>>> {
    private static final long serialVersionUID = -5121887228607148857L;
    static final Value.BaseMarshaller<List<? extends Value<?>>, ListValue, Builder> MARSHALLER = new Value.BaseMarshaller<List<? extends Value<?>>, ListValue, Builder>(){
        private static final long serialVersionUID = 7720473855548179942L;

        @Override
        public int getProtoFieldId() {
            return 9;
        }

        @Override
        public Builder newBuilder(List<? extends Value<?>> values) {
            return ListValue.newBuilder().set(values);
        }

        @Override
        protected List<Value<?>> getValue(com.google.datastore.v1.Value from) {
            ArrayList properties = new ArrayList(from.getArrayValue().getValuesCount());
            for (com.google.datastore.v1.Value valuePb : from.getArrayValue().getValuesList()) {
                properties.add(Value.fromPb(valuePb));
            }
            return properties;
        }

        @Override
        protected void setValue(ListValue from, Value.Builder to) {
            ArrayList<com.google.datastore.v1.Value> propertiesPb = new ArrayList<com.google.datastore.v1.Value>();
            for (Value property : (List)from.get()) {
                propertiesPb.add(property.toPb());
            }
            to.setArrayValue(ArrayValue.newBuilder().addAllValues(propertiesPb));
        }
    };

    public ListValue(List<? extends Value<?>> values) {
        this(ListValue.newBuilder().set(values));
    }

    public ListValue(Value<?> first, Value<?> ... other) {
        this(new Builder().addValue(first, other));
    }

    private ListValue(Builder builder) {
        super(builder);
    }

    public Builder toBuilder() {
        return (Builder)new Builder().mergeFrom(this);
    }

    public static ListValue of(List<? extends Value<?>> values) {
        return new ListValue(values);
    }

    public static ListValue of(Value<?> first, Value<?> ... other) {
        return new ListValue(first, other);
    }

    public static ListValue of(String first, String ... other) {
        return ListValue.newBuilder().addValue(first, other).build();
    }

    public static ListValue of(long first, long ... other) {
        return ListValue.newBuilder().addValue(first, other).build();
    }

    public static ListValue of(double first, double ... other) {
        return ListValue.newBuilder().addValue(first, other).build();
    }

    public static ListValue of(boolean first, boolean ... other) {
        return ListValue.newBuilder().addValue(first, other).build();
    }

    public static ListValue of(Timestamp first, Timestamp ... other) {
        return ListValue.newBuilder().addValue(first, other).build();
    }

    public static ListValue of(LatLng first, LatLng ... other) {
        return ListValue.newBuilder().addValue(first, other).build();
    }

    public static ListValue of(Key first, Key ... other) {
        return ListValue.newBuilder().addValue(first, other).build();
    }

    public static ListValue of(FullEntity<?> first, FullEntity<?> ... other) {
        return ListValue.newBuilder().addValue(first, other).build();
    }

    public static ListValue of(Blob first, Blob ... other) {
        return ListValue.newBuilder().addValue(first, other).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    extends Value.BaseBuilder<List<? extends Value<?>>, ListValue, Builder> {
        private ImmutableList.Builder<Value<?>> listBuilder = ImmutableList.builder();

        private Builder() {
            super(ValueType.LIST);
        }

        private void addValueHelper(Value<?> value) {
            Preconditions.checkArgument((value.getType() != ValueType.LIST ? 1 : 0) != 0, (Object)"Cannot contain another list");
            this.listBuilder.add(value);
        }

        public Builder addValue(Value<?> first, Value<?> ... other) {
            this.addValueHelper(first);
            for (Value<?> value : other) {
                this.addValueHelper(value);
            }
            return this;
        }

        public Builder addValue(String first, String ... other) {
            this.listBuilder.add((Object)StringValue.of(first));
            for (String value : other) {
                this.listBuilder.add((Object)StringValue.of(value));
            }
            return this;
        }

        public Builder addValue(long first, long ... other) {
            this.listBuilder.add((Object)LongValue.of(first));
            for (long value : other) {
                this.listBuilder.add((Object)LongValue.of(value));
            }
            return this;
        }

        public Builder addValue(double first, double ... other) {
            this.listBuilder.add((Object)DoubleValue.of(first));
            for (double value : other) {
                this.listBuilder.add((Object)DoubleValue.of(value));
            }
            return this;
        }

        public Builder addValue(boolean first, boolean ... other) {
            this.listBuilder.add((Object)BooleanValue.of(first));
            for (boolean value : other) {
                this.listBuilder.add((Object)BooleanValue.of(value));
            }
            return this;
        }

        public Builder addValue(Timestamp first, Timestamp ... other) {
            this.listBuilder.add((Object)TimestampValue.of(first));
            for (Timestamp value : other) {
                this.listBuilder.add((Object)TimestampValue.of(value));
            }
            return this;
        }

        public Builder addValue(LatLng first, LatLng ... other) {
            this.listBuilder.add((Object)LatLngValue.of(first));
            for (LatLng value : other) {
                this.listBuilder.add((Object)LatLngValue.of(value));
            }
            return this;
        }

        public Builder addValue(Key first, Key ... other) {
            this.listBuilder.add((Object)KeyValue.of(first));
            for (Key value : other) {
                this.listBuilder.add((Object)KeyValue.of(value));
            }
            return this;
        }

        public Builder addValue(FullEntity<?> first, FullEntity<?> ... other) {
            this.listBuilder.add((Object)EntityValue.of(first));
            for (FullEntity<?> value : other) {
                this.listBuilder.add((Object)EntityValue.of(value));
            }
            return this;
        }

        public Builder addValue(Blob first, Blob ... other) {
            this.listBuilder.add((Object)BlobValue.of(first));
            for (Blob value : other) {
                this.listBuilder.add((Object)BlobValue.of(value));
            }
            return this;
        }

        @Override
        public Builder set(List<? extends Value<?>> values) {
            this.listBuilder = ImmutableList.builder();
            for (Value<?> value : values) {
                this.addValue(value, new Value[0]);
            }
            return this;
        }

        @Override
        public List<? extends Value<?>> get() {
            return this.listBuilder.build();
        }

        @Override
        public ListValue build() {
            return new ListValue(this);
        }
    }
}

