/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datastore.v1.DatastoreSettings;
import com.google.cloud.datastore.v1.stub.DatastoreStub;
import com.google.cloud.datastore.v1.stub.DatastoreStubSettings;
import com.google.datastore.v1.AllocateIdsRequest;
import com.google.datastore.v1.AllocateIdsResponse;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.BeginTransactionResponse;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.LookupRequest;
import com.google.datastore.v1.LookupResponse;
import com.google.datastore.v1.Mutation;
import com.google.datastore.v1.ReadOptions;
import com.google.datastore.v1.ReserveIdsRequest;
import com.google.datastore.v1.ReserveIdsResponse;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.RollbackResponse;
import com.google.datastore.v1.RunAggregationQueryRequest;
import com.google.datastore.v1.RunAggregationQueryResponse;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DatastoreClient
implements BackgroundResource {
    private final DatastoreSettings settings;
    private final DatastoreStub stub;

    public static final DatastoreClient create() throws IOException {
        return DatastoreClient.create(DatastoreSettings.newBuilder().build());
    }

    public static final DatastoreClient create(DatastoreSettings settings) throws IOException {
        return new DatastoreClient(settings);
    }

    public static final DatastoreClient create(DatastoreStub stub) {
        return new DatastoreClient(stub);
    }

    protected DatastoreClient(DatastoreSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DatastoreStubSettings)settings.getStubSettings()).createStub();
    }

    protected DatastoreClient(DatastoreStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DatastoreSettings getSettings() {
        return this.settings;
    }

    public DatastoreStub getStub() {
        return this.stub;
    }

    public final LookupResponse lookup(String projectId, ReadOptions readOptions, List<Key> keys) {
        LookupRequest request = LookupRequest.newBuilder().setProjectId(projectId).setReadOptions(readOptions).addAllKeys(keys).build();
        return this.lookup(request);
    }

    public final LookupResponse lookup(LookupRequest request) {
        return (LookupResponse)this.lookupCallable().call((Object)request);
    }

    public final UnaryCallable<LookupRequest, LookupResponse> lookupCallable() {
        return this.stub.lookupCallable();
    }

    public final RunQueryResponse runQuery(RunQueryRequest request) {
        return (RunQueryResponse)this.runQueryCallable().call((Object)request);
    }

    public final UnaryCallable<RunQueryRequest, RunQueryResponse> runQueryCallable() {
        return this.stub.runQueryCallable();
    }

    public final RunAggregationQueryResponse runAggregationQuery(RunAggregationQueryRequest request) {
        return (RunAggregationQueryResponse)this.runAggregationQueryCallable().call((Object)request);
    }

    public final UnaryCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryCallable() {
        return this.stub.runAggregationQueryCallable();
    }

    public final BeginTransactionResponse beginTransaction(String projectId) {
        BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setProjectId(projectId).build();
        return this.beginTransaction(request);
    }

    public final BeginTransactionResponse beginTransaction(BeginTransactionRequest request) {
        return (BeginTransactionResponse)this.beginTransactionCallable().call((Object)request);
    }

    public final UnaryCallable<BeginTransactionRequest, BeginTransactionResponse> beginTransactionCallable() {
        return this.stub.beginTransactionCallable();
    }

    public final CommitResponse commit(String projectId, CommitRequest.Mode mode, List<Mutation> mutations) {
        CommitRequest request = CommitRequest.newBuilder().setProjectId(projectId).setMode(mode).addAllMutations(mutations).build();
        return this.commit(request);
    }

    public final CommitResponse commit(String projectId, CommitRequest.Mode mode, ByteString transaction, List<Mutation> mutations) {
        CommitRequest request = CommitRequest.newBuilder().setProjectId(projectId).setMode(mode).setTransaction(transaction).addAllMutations(mutations).build();
        return this.commit(request);
    }

    public final CommitResponse commit(CommitRequest request) {
        return (CommitResponse)this.commitCallable().call((Object)request);
    }

    public final UnaryCallable<CommitRequest, CommitResponse> commitCallable() {
        return this.stub.commitCallable();
    }

    public final RollbackResponse rollback(String projectId, ByteString transaction) {
        RollbackRequest request = RollbackRequest.newBuilder().setProjectId(projectId).setTransaction(transaction).build();
        return this.rollback(request);
    }

    public final RollbackResponse rollback(RollbackRequest request) {
        return (RollbackResponse)this.rollbackCallable().call((Object)request);
    }

    public final UnaryCallable<RollbackRequest, RollbackResponse> rollbackCallable() {
        return this.stub.rollbackCallable();
    }

    public final AllocateIdsResponse allocateIds(String projectId, List<Key> keys) {
        AllocateIdsRequest request = AllocateIdsRequest.newBuilder().setProjectId(projectId).addAllKeys(keys).build();
        return this.allocateIds(request);
    }

    public final AllocateIdsResponse allocateIds(AllocateIdsRequest request) {
        return (AllocateIdsResponse)this.allocateIdsCallable().call((Object)request);
    }

    public final UnaryCallable<AllocateIdsRequest, AllocateIdsResponse> allocateIdsCallable() {
        return this.stub.allocateIdsCallable();
    }

    public final ReserveIdsResponse reserveIds(String projectId, List<Key> keys) {
        ReserveIdsRequest request = ReserveIdsRequest.newBuilder().setProjectId(projectId).addAllKeys(keys).build();
        return this.reserveIds(request);
    }

    public final ReserveIdsResponse reserveIds(ReserveIdsRequest request) {
        return (ReserveIdsResponse)this.reserveIdsCallable().call((Object)request);
    }

    public final UnaryCallable<ReserveIdsRequest, ReserveIdsResponse> reserveIdsCallable() {
        return this.stub.reserveIdsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

