/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.datastore.v1.stub.DatastoreStub;
import com.google.cloud.datastore.v1.stub.DatastoreStubSettings;
import com.google.cloud.datastore.v1.stub.GrpcDatastoreCallableFactory;
import com.google.datastore.v1.AllocateIdsRequest;
import com.google.datastore.v1.AllocateIdsResponse;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.BeginTransactionResponse;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.LookupRequest;
import com.google.datastore.v1.LookupResponse;
import com.google.datastore.v1.ReserveIdsRequest;
import com.google.datastore.v1.ReserveIdsResponse;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.RollbackResponse;
import com.google.datastore.v1.RunAggregationQueryRequest;
import com.google.datastore.v1.RunAggregationQueryResponse;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcDatastoreStub
extends DatastoreStub {
    private static final MethodDescriptor<LookupRequest, LookupResponse> lookupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.datastore.v1.Datastore/Lookup").setRequestMarshaller(ProtoUtils.marshaller((Message)LookupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)LookupResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<RunQueryRequest, RunQueryResponse> runQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.datastore.v1.Datastore/RunQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)RunQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RunQueryResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.datastore.v1.Datastore/RunAggregationQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)RunAggregationQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RunAggregationQueryResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<BeginTransactionRequest, BeginTransactionResponse> beginTransactionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.datastore.v1.Datastore/BeginTransaction").setRequestMarshaller(ProtoUtils.marshaller((Message)BeginTransactionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BeginTransactionResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CommitRequest, CommitResponse> commitMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.datastore.v1.Datastore/Commit").setRequestMarshaller(ProtoUtils.marshaller((Message)CommitRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CommitResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<RollbackRequest, RollbackResponse> rollbackMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.datastore.v1.Datastore/Rollback").setRequestMarshaller(ProtoUtils.marshaller((Message)RollbackRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RollbackResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<AllocateIdsRequest, AllocateIdsResponse> allocateIdsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.datastore.v1.Datastore/AllocateIds").setRequestMarshaller(ProtoUtils.marshaller((Message)AllocateIdsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AllocateIdsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ReserveIdsRequest, ReserveIdsResponse> reserveIdsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.datastore.v1.Datastore/ReserveIds").setRequestMarshaller(ProtoUtils.marshaller((Message)ReserveIdsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReserveIdsResponse.getDefaultInstance())).build();
    private final UnaryCallable<LookupRequest, LookupResponse> lookupCallable;
    private final UnaryCallable<RunQueryRequest, RunQueryResponse> runQueryCallable;
    private final UnaryCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryCallable;
    private final UnaryCallable<BeginTransactionRequest, BeginTransactionResponse> beginTransactionCallable;
    private final UnaryCallable<CommitRequest, CommitResponse> commitCallable;
    private final UnaryCallable<RollbackRequest, RollbackResponse> rollbackCallable;
    private final UnaryCallable<AllocateIdsRequest, AllocateIdsResponse> allocateIdsCallable;
    private final UnaryCallable<ReserveIdsRequest, ReserveIdsResponse> reserveIdsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;
    private static final PathTemplate LOOKUP_0_PATH_TEMPLATE = PathTemplate.create((String)"{project_id=**}");
    private static final PathTemplate LOOKUP_1_PATH_TEMPLATE = PathTemplate.create((String)"{database_id=**}");
    private static final PathTemplate RUN_QUERY_0_PATH_TEMPLATE = PathTemplate.create((String)"{project_id=**}");
    private static final PathTemplate RUN_QUERY_1_PATH_TEMPLATE = PathTemplate.create((String)"{database_id=**}");
    private static final PathTemplate RUN_AGGREGATION_QUERY_0_PATH_TEMPLATE = PathTemplate.create((String)"{project_id=**}");
    private static final PathTemplate RUN_AGGREGATION_QUERY_1_PATH_TEMPLATE = PathTemplate.create((String)"{database_id=**}");
    private static final PathTemplate BEGIN_TRANSACTION_0_PATH_TEMPLATE = PathTemplate.create((String)"{project_id=**}");
    private static final PathTemplate BEGIN_TRANSACTION_1_PATH_TEMPLATE = PathTemplate.create((String)"{database_id=**}");
    private static final PathTemplate COMMIT_0_PATH_TEMPLATE = PathTemplate.create((String)"{project_id=**}");
    private static final PathTemplate COMMIT_1_PATH_TEMPLATE = PathTemplate.create((String)"{database_id=**}");
    private static final PathTemplate ROLLBACK_0_PATH_TEMPLATE = PathTemplate.create((String)"{project_id=**}");
    private static final PathTemplate ROLLBACK_1_PATH_TEMPLATE = PathTemplate.create((String)"{database_id=**}");
    private static final PathTemplate ALLOCATE_IDS_0_PATH_TEMPLATE = PathTemplate.create((String)"{project_id=**}");
    private static final PathTemplate ALLOCATE_IDS_1_PATH_TEMPLATE = PathTemplate.create((String)"{database_id=**}");
    private static final PathTemplate RESERVE_IDS_0_PATH_TEMPLATE = PathTemplate.create((String)"{project_id=**}");
    private static final PathTemplate RESERVE_IDS_1_PATH_TEMPLATE = PathTemplate.create((String)"{database_id=**}");

    public static final GrpcDatastoreStub create(DatastoreStubSettings settings) throws IOException {
        return new GrpcDatastoreStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDatastoreStub create(ClientContext clientContext) throws IOException {
        return new GrpcDatastoreStub(DatastoreStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDatastoreStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDatastoreStub(DatastoreStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDatastoreStub(DatastoreStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDatastoreCallableFactory());
    }

    protected GrpcDatastoreStub(DatastoreStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings lookupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(lookupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProjectId(), "project_id", LOOKUP_0_PATH_TEMPLATE);
            builder.add(request.getDatabaseId(), "database_id", LOOKUP_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings runQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(runQueryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProjectId(), "project_id", RUN_QUERY_0_PATH_TEMPLATE);
            builder.add(request.getDatabaseId(), "database_id", RUN_QUERY_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings runAggregationQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(runAggregationQueryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProjectId(), "project_id", RUN_AGGREGATION_QUERY_0_PATH_TEMPLATE);
            builder.add(request.getDatabaseId(), "database_id", RUN_AGGREGATION_QUERY_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings beginTransactionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(beginTransactionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProjectId(), "project_id", BEGIN_TRANSACTION_0_PATH_TEMPLATE);
            builder.add(request.getDatabaseId(), "database_id", BEGIN_TRANSACTION_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings commitTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(commitMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProjectId(), "project_id", COMMIT_0_PATH_TEMPLATE);
            builder.add(request.getDatabaseId(), "database_id", COMMIT_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings rollbackTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(rollbackMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProjectId(), "project_id", ROLLBACK_0_PATH_TEMPLATE);
            builder.add(request.getDatabaseId(), "database_id", ROLLBACK_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings allocateIdsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(allocateIdsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProjectId(), "project_id", ALLOCATE_IDS_0_PATH_TEMPLATE);
            builder.add(request.getDatabaseId(), "database_id", ALLOCATE_IDS_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings reserveIdsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(reserveIdsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProjectId(), "project_id", RESERVE_IDS_0_PATH_TEMPLATE);
            builder.add(request.getDatabaseId(), "database_id", RESERVE_IDS_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        this.lookupCallable = callableFactory.createUnaryCallable(lookupTransportSettings, settings.lookupSettings(), clientContext);
        this.runQueryCallable = callableFactory.createUnaryCallable(runQueryTransportSettings, settings.runQuerySettings(), clientContext);
        this.runAggregationQueryCallable = callableFactory.createUnaryCallable(runAggregationQueryTransportSettings, settings.runAggregationQuerySettings(), clientContext);
        this.beginTransactionCallable = callableFactory.createUnaryCallable(beginTransactionTransportSettings, settings.beginTransactionSettings(), clientContext);
        this.commitCallable = callableFactory.createUnaryCallable(commitTransportSettings, settings.commitSettings(), clientContext);
        this.rollbackCallable = callableFactory.createUnaryCallable(rollbackTransportSettings, settings.rollbackSettings(), clientContext);
        this.allocateIdsCallable = callableFactory.createUnaryCallable(allocateIdsTransportSettings, settings.allocateIdsSettings(), clientContext);
        this.reserveIdsCallable = callableFactory.createUnaryCallable(reserveIdsTransportSettings, settings.reserveIdsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<LookupRequest, LookupResponse> lookupCallable() {
        return this.lookupCallable;
    }

    @Override
    public UnaryCallable<RunQueryRequest, RunQueryResponse> runQueryCallable() {
        return this.runQueryCallable;
    }

    @Override
    public UnaryCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryCallable() {
        return this.runAggregationQueryCallable;
    }

    @Override
    public UnaryCallable<BeginTransactionRequest, BeginTransactionResponse> beginTransactionCallable() {
        return this.beginTransactionCallable;
    }

    @Override
    public UnaryCallable<CommitRequest, CommitResponse> commitCallable() {
        return this.commitCallable;
    }

    @Override
    public UnaryCallable<RollbackRequest, RollbackResponse> rollbackCallable() {
        return this.rollbackCallable;
    }

    @Override
    public UnaryCallable<AllocateIdsRequest, AllocateIdsResponse> allocateIdsCallable() {
        return this.allocateIdsCallable;
    }

    @Override
    public UnaryCallable<ReserveIdsRequest, ReserveIdsResponse> reserveIdsCallable() {
        return this.reserveIdsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

