/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.telemetry;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.telemetry.TraceUtil;
import com.google.common.base.Throwables;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class EnabledTraceUtil
implements TraceUtil {
    private final Tracer tracer;
    private final OpenTelemetry openTelemetry;
    private final DatastoreOptions datastoreOptions;

    EnabledTraceUtil(DatastoreOptions datastoreOptions) {
        OpenTelemetry openTelemetry = datastoreOptions.getOpenTelemetryOptions().getOpenTelemetry();
        if (openTelemetry == null) {
            openTelemetry = GlobalOpenTelemetry.get();
        }
        this.datastoreOptions = datastoreOptions;
        this.openTelemetry = openTelemetry;
        this.tracer = openTelemetry.getTracer("com.google.cloud.datastore");
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    @Override
    @Nullable
    public ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> getChannelConfigurator() {
        return null;
    }

    @Override
    public SpanBuilder addSettingsAttributesToCurrentSpan(SpanBuilder spanBuilder) {
        spanBuilder = spanBuilder.setAllAttributes(Attributes.builder().put("gcp.datastore.settings.databaseId", this.datastoreOptions.getDatabaseId()).put("gcp.datastore.settings.host", this.datastoreOptions.getHost()).build());
        if (this.datastoreOptions.getCredentials() != null) {
            spanBuilder = spanBuilder.setAttribute("gcp.datastore.settings.credentials.authenticationType", this.datastoreOptions.getCredentials().getAuthenticationType());
        }
        if (this.datastoreOptions.getRetrySettings() != null) {
            spanBuilder = spanBuilder.setAllAttributes(Attributes.builder().put("gcp.datastore.settings.retrySettings.initialRetryDelay", this.datastoreOptions.getRetrySettings().getInitialRetryDelay().toString()).put("gcp.datastore.settings.retrySettings.maxRetryDelay", this.datastoreOptions.getRetrySettings().getMaxRetryDelay().toString()).put("gcp.datastore.settings.retrySettings.retryDelayMultiplier", String.valueOf(this.datastoreOptions.getRetrySettings().getRetryDelayMultiplier())).put("gcp.datastore.settings.retrySettings.maxAttempts", String.valueOf(this.datastoreOptions.getRetrySettings().getMaxAttempts())).put("gcp.datastore.settings.retrySettings.initialRpcTimeout", this.datastoreOptions.getRetrySettings().getInitialRpcTimeout().toString()).put("gcp.datastore.settings.retrySettings.maxRpcTimeout", this.datastoreOptions.getRetrySettings().getMaxRpcTimeout().toString()).put("gcp.datastore.settings.retrySettings.rpcTimeoutMultiplier", String.valueOf(this.datastoreOptions.getRetrySettings().getRpcTimeoutMultiplier())).put("gcp.datastore.settings.retrySettings.totalTimeout", this.datastoreOptions.getRetrySettings().getTotalTimeout().toString()).build());
        }
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        double memoryUtilization = (double)(totalMemory - freeMemory) / (double)totalMemory;
        spanBuilder.setAttribute("gcp.datastore.memoryUtilization", String.format("%.2f", memoryUtilization * 100.0) + "%");
        return spanBuilder;
    }

    @Override
    public Span startSpan(String spanName) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder(spanName).setSpanKind(SpanKind.PRODUCER);
        io.opentelemetry.api.trace.Span span = this.addSettingsAttributesToCurrentSpan(spanBuilder).startSpan();
        return new Span(span, spanName);
    }

    @Override
    public TraceUtil.Span startSpan(String spanName, TraceUtil.Span parentSpan) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder(spanName).setSpanKind(SpanKind.PRODUCER).setParent(io.opentelemetry.context.Context.current().with((ImplicitContextKeyed)parentSpan.getSpan()));
        return new Span(this.addSettingsAttributesToCurrentSpan(spanBuilder).startSpan(), spanName);
    }

    @Override
    @Nonnull
    public TraceUtil.Span getCurrentSpan() {
        return new Span(io.opentelemetry.api.trace.Span.current(), "");
    }

    @Override
    @Nonnull
    public TraceUtil.Context getCurrentContext() {
        return new Context(io.opentelemetry.context.Context.current());
    }

    @Override
    public Tracer getTracer() {
        return this.tracer;
    }

    static class Span
    implements TraceUtil.Span {
        private final io.opentelemetry.api.trace.Span span;
        private final String spanName;

        public Span(io.opentelemetry.api.trace.Span span, String spanName) {
            this.span = span;
            this.spanName = spanName;
        }

        @Override
        public io.opentelemetry.api.trace.Span getSpan() {
            return this.span;
        }

        @Override
        public void end() {
            this.span.end();
        }

        @Override
        public void end(Throwable error) {
            this.span.setStatus(StatusCode.ERROR, error.getMessage());
            this.span.recordException(error, Attributes.builder().put("exception.message", error.getMessage()).put("exception.type", error.getClass().getName()).put("exception.stacktrace", Throwables.getStackTraceAsString((Throwable)error)).build());
            this.span.end();
        }

        @Override
        public <T> void endAtFuture(ApiFuture<T> futureValue) {
            final io.opentelemetry.context.Context asyncContext = io.opentelemetry.context.Context.current();
            ApiFutures.addCallback(futureValue, (ApiFutureCallback)new ApiFutureCallback<T>(){

                public void onFailure(Throwable t) {
                    try (io.opentelemetry.context.Scope scope = asyncContext.makeCurrent();){
                        span.addEvent(spanName + " failed.");
                        this.end(t);
                    }
                }

                public void onSuccess(T result) {
                    try (io.opentelemetry.context.Scope scope = asyncContext.makeCurrent();){
                        span.addEvent(spanName + " succeeded.");
                        this.end();
                    }
                }
            });
        }

        @Override
        public TraceUtil.Span addEvent(String name) {
            this.span.addEvent(name);
            return this;
        }

        @Override
        public TraceUtil.Span addEvent(String name, Map<String, Object> attributes) {
            AttributesBuilder attributesBuilder = Attributes.builder();
            attributes.forEach((key, value) -> {
                if (value instanceof Integer) {
                    attributesBuilder.put(key, (long)((Integer)value).intValue());
                } else if (value instanceof Long) {
                    attributesBuilder.put(key, ((Long)value).longValue());
                } else if (value instanceof Double) {
                    attributesBuilder.put(key, ((Double)value).doubleValue());
                } else if (value instanceof Float) {
                    attributesBuilder.put(key, (double)((Float)value).floatValue());
                } else if (value instanceof Boolean) {
                    attributesBuilder.put(key, ((Boolean)value).booleanValue());
                } else if (value instanceof String) {
                    attributesBuilder.put(key, (String)value);
                } else {
                    throw new IllegalArgumentException("Unknown attribute type:" + value.getClass().getSimpleName());
                }
            });
            this.span.addEvent(name, attributesBuilder.build());
            return this;
        }

        @Override
        public TraceUtil.Span setAttribute(String key, int value) {
            this.span.setAttribute("gcp.datastore." + key, (long)value);
            return this;
        }

        @Override
        public TraceUtil.Span setAttribute(String key, String value) {
            this.span.setAttribute("gcp.datastore." + key, value);
            return this;
        }

        @Override
        public TraceUtil.Span setAttribute(String key, boolean value) {
            this.span.setAttribute("gcp.datastore." + key, value);
            return this;
        }

        @Override
        public Scope makeCurrent() {
            try (io.opentelemetry.context.Scope scope = this.span.makeCurrent();){
                Scope scope2 = new Scope(scope);
                return scope2;
            }
        }
    }

    static class Context
    implements TraceUtil.Context {
        private final io.opentelemetry.context.Context context;

        Context(io.opentelemetry.context.Context context) {
            this.context = context;
        }

        @Override
        public Scope makeCurrent() {
            try (io.opentelemetry.context.Scope scope = this.context.makeCurrent();){
                Scope scope2 = new Scope(scope);
                return scope2;
            }
        }
    }

    static class Scope
    implements TraceUtil.Scope {
        private final io.opentelemetry.context.Scope scope;

        Scope(io.opentelemetry.context.Scope scope) {
            this.scope = scope;
        }

        @Override
        public void close() {
            this.scope.close();
        }
    }
}

