/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.rpc.Code;
import io.grpc.Status;
import java.util.Map;
import java.util.function.Function;

final class GrpcToDatastoreCodeTranslation {
    private static final ImmutableList<StatusCodeMapping> STATUS_CODE_MAPPINGS = ImmutableList.of((Object)StatusCodeMapping.of(Code.OK.getNumber(), Status.Code.OK), (Object)StatusCodeMapping.of(Code.DATA_LOSS.getNumber(), Status.Code.DATA_LOSS), (Object)StatusCodeMapping.of(Code.INVALID_ARGUMENT.getNumber(), Status.Code.INVALID_ARGUMENT), (Object)StatusCodeMapping.of(Code.OUT_OF_RANGE.getNumber(), Status.Code.OUT_OF_RANGE), (Object)StatusCodeMapping.of(Code.UNAUTHENTICATED.getNumber(), Status.Code.UNAUTHENTICATED), (Object)StatusCodeMapping.of(Code.PERMISSION_DENIED.getNumber(), Status.Code.PERMISSION_DENIED), (Object)StatusCodeMapping.of(Code.NOT_FOUND.getNumber(), Status.Code.NOT_FOUND), (Object)StatusCodeMapping.of(Code.ALREADY_EXISTS.getNumber(), Status.Code.ALREADY_EXISTS), (Object)StatusCodeMapping.of(Code.FAILED_PRECONDITION.getNumber(), Status.Code.FAILED_PRECONDITION), (Object)StatusCodeMapping.of(Code.RESOURCE_EXHAUSTED.getNumber(), Status.Code.RESOURCE_EXHAUSTED), (Object)StatusCodeMapping.of(Code.INTERNAL.getNumber(), Status.Code.INTERNAL), (Object)StatusCodeMapping.of(Code.UNIMPLEMENTED.getNumber(), Status.Code.UNIMPLEMENTED), (Object[])new StatusCodeMapping[]{StatusCodeMapping.of(Code.UNAVAILABLE.getNumber(), Status.Code.UNAVAILABLE), StatusCodeMapping.of(Code.DEADLINE_EXCEEDED.getNumber(), Status.Code.DEADLINE_EXCEEDED), StatusCodeMapping.of(Code.ABORTED.getNumber(), Status.Code.ABORTED), StatusCodeMapping.of(Code.CANCELLED.getNumber(), Status.Code.CANCELLED), StatusCodeMapping.of(Code.UNKNOWN.getNumber(), Status.Code.UNKNOWN)});
    private static final Map<Status.Code, StatusCodeMapping> GRPC_CODE_INDEX = (Map)STATUS_CODE_MAPPINGS.stream().collect(ImmutableMap.toImmutableMap(StatusCodeMapping::getGrpcCode, Function.identity()));

    GrpcToDatastoreCodeTranslation() {
    }

    static int grpcCodeToDatastoreStatusCode(Status.Code code) {
        StatusCodeMapping found = GRPC_CODE_INDEX.get(code);
        if (found != null) {
            return found.getDatastoreCode();
        }
        return 0;
    }

    private static final class StatusCodeMapping {
        private final int datastoreCode;
        private final Status.Code grpcCode;

        private StatusCodeMapping(int datastoreCode, Status.Code grpcCode) {
            this.datastoreCode = datastoreCode;
            this.grpcCode = grpcCode;
        }

        public int getDatastoreCode() {
            return this.datastoreCode;
        }

        public Status.Code getGrpcCode() {
            return this.grpcCode;
        }

        static StatusCodeMapping of(int datastoreCode, Status.Code grpcCode) {
            return new StatusCodeMapping(datastoreCode, grpcCode);
        }
    }
}

