/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.telemetry;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.telemetry.DisabledTraceUtil;
import com.google.cloud.datastore.telemetry.EnabledTraceUtil;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalExtensionOnly
public interface TraceUtil {
    public static final String ATTRIBUTE_SERVICE_PREFIX = "gcp.datastore.";
    public static final String ENABLE_TRACING_ENV_VAR = "DATASTORE_ENABLE_TRACING";
    public static final String LIBRARY_NAME = "com.google.cloud.datastore";
    public static final String SPAN_NAME_LOOKUP = "Lookup";
    public static final String SPAN_NAME_ALLOCATE_IDS = "AllocateIds";
    public static final String SPAN_NAME_RESERVE_IDS = "ReserveIds";
    public static final String SPAN_NAME_COMMIT = "Commit";
    public static final String SPAN_NAME_RUN_QUERY = "RunQuery";
    public static final String SPAN_NAME_RUN_AGGREGATION_QUERY = "RunAggregationQuery";
    public static final String SPAN_NAME_TRANSACTION_RUN = "Transaction.Run";
    public static final String SPAN_NAME_BEGIN_TRANSACTION = "Transaction.Begin";
    public static final String SPAN_NAME_TRANSACTION_LOOKUP = "Transaction.Lookup";
    public static final String SPAN_NAME_TRANSACTION_COMMIT = "Transaction.Commit";
    public static final String SPAN_NAME_TRANSACTION_RUN_QUERY = "Transaction.RunQuery";
    public static final String SPAN_NAME_ROLLBACK = "Transaction.Rollback";
    public static final String SPAN_NAME_TRANSACTION_RUN_AGGREGATION_QUERY = "Transaction.RunAggregationQuery";
    public static final String ATTRIBUTES_KEY_DOCUMENT_COUNT = "doc_count";
    public static final String ATTRIBUTES_KEY_TRANSACTIONAL = "transactional";
    public static final String ATTRIBUTES_KEY_TRANSACTION_ID = "transaction_id";
    public static final String ATTRIBUTES_KEY_READ_CONSISTENCY = "read_consistency";
    public static final String ATTRIBUTES_KEY_RECEIVED = "Received";
    public static final String ATTRIBUTES_KEY_MISSING = "Missing";
    public static final String ATTRIBUTES_KEY_DEFERRED = "Deferred";
    public static final String ATTRIBUTES_KEY_MORE_RESULTS = "mor_results";

    public static TraceUtil getInstance(@Nonnull DatastoreOptions datastoreOptions) {
        boolean createEnabledInstance = datastoreOptions.getOpenTelemetryOptions().isEnabled();
        String enableTracingEnvVar = System.getenv(ENABLE_TRACING_ENV_VAR);
        if (enableTracingEnvVar != null) {
            if (enableTracingEnvVar.equalsIgnoreCase("true") || enableTracingEnvVar.equalsIgnoreCase("on")) {
                createEnabledInstance = true;
            }
            if (enableTracingEnvVar.equalsIgnoreCase("false") || enableTracingEnvVar.equalsIgnoreCase("off")) {
                createEnabledInstance = false;
            }
        }
        if (createEnabledInstance) {
            return new EnabledTraceUtil(datastoreOptions);
        }
        return new DisabledTraceUtil();
    }

    @Nullable
    public ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> getChannelConfigurator();

    public Span startSpan(String var1);

    public Span startSpan(String var1, Span var2);

    public SpanBuilder addSettingsAttributesToCurrentSpan(SpanBuilder var1);

    @Nonnull
    public Span getCurrentSpan();

    @Nonnull
    public Context getCurrentContext();

    public Tracer getTracer();

    public static interface Scope
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static interface Context {
        public Scope makeCurrent();
    }

    public static interface Span {
        public Span addEvent(String var1);

        public Span addEvent(String var1, Map<String, Object> var2);

        public Span setAttribute(String var1, int var2);

        public Span setAttribute(String var1, String var2);

        public Span setAttribute(String var1, boolean var2);

        public io.opentelemetry.api.trace.Span getSpan();

        public Scope makeCurrent();

        public void end();

        public void end(Throwable var1);

        public <T> void endAtFuture(ApiFuture<T> var1);
    }
}

