/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.datastore.v1.Key;
import java.io.Serializable;
import java.util.Objects;

public final class PathElement
implements Serializable {
    private static final long serialVersionUID = -777300414390493910L;
    private final String kind;
    private final Long id;
    private final String name;

    private PathElement(String kind, String name, Long id) {
        this.kind = (String)Preconditions.checkNotNull((Object)kind, (Object)"kind must not be null");
        this.name = name;
        this.id = id;
    }

    public String getKind() {
        return this.kind;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public Long getId() {
        return this.id;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public Object getNameOrId() {
        return this.id == null ? this.name : this.id;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("kind", (Object)this.kind).add("id", (Object)this.id).add("name", (Object)this.name).toString();
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.id, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PathElement)) {
            return false;
        }
        PathElement other = (PathElement)obj;
        return Objects.equals(this.kind, other.kind) && Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name);
    }

    Key.PathElement toPb() {
        Key.PathElement.Builder pathElementPb = Key.PathElement.newBuilder();
        pathElementPb.setKind(this.kind);
        if (this.id != null) {
            pathElementPb.setId(this.id.longValue());
        } else if (this.name != null) {
            pathElementPb.setName(this.name);
        }
        return pathElementPb.build();
    }

    static PathElement fromPb(Key.PathElement pathElementPb) {
        String kind = pathElementPb.getKind();
        switch (pathElementPb.getIdTypeCase()) {
            case ID: {
                return PathElement.of(kind, pathElementPb.getId());
            }
            case NAME: {
                return PathElement.of(kind, pathElementPb.getName());
            }
        }
        return PathElement.of(kind);
    }

    static PathElement of(String kind) {
        return new PathElement(kind, null, null);
    }

    public static PathElement of(String kind, String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name must not be empty or null");
        return new PathElement(kind, name, null);
    }

    public static PathElement of(String kind, long id) {
        Preconditions.checkArgument((id != 0L ? 1 : 0) != 0, (Object)"id must not be equal to zero");
        return new PathElement(kind, null, id);
    }
}

