/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.core.InternalApi;
import com.google.cloud.NoCredentials;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.common.base.Strings;
import java.net.InetAddress;
import java.net.URL;

@InternalApi
public class DatastoreUtils {
    public static boolean isEmulator(DatastoreOptions datastoreOptions) {
        return DatastoreUtils.isLocalHost(datastoreOptions.getHost()) || NoCredentials.getInstance().equals((Object)datastoreOptions.getCredentials());
    }

    public static boolean isLocalHost(String host) {
        if (Strings.isNullOrEmpty((String)host)) {
            return false;
        }
        try {
            String normalizedHost = "http://" + DatastoreUtils.removeScheme(host);
            InetAddress hostAddr = InetAddress.getByName(new URL(normalizedHost).getHost());
            return hostAddr.isAnyLocalAddress() || hostAddr.isLoopbackAddress();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String removeScheme(String url) {
        if (url != null) {
            if ((url = url.toLowerCase()).startsWith("https://")) {
                return url.substring("https://".length());
            }
            if (url.startsWith("http://")) {
                return url.substring("http://".length());
            }
        }
        return url;
    }
}

