/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.admin.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datastore.admin.v1.DatastoreAdminClient;
import com.google.cloud.datastore.admin.v1.stub.DatastoreAdminStub;
import com.google.cloud.datastore.admin.v1.stub.DatastoreAdminStubSettings;
import com.google.cloud.datastore.admin.v1.stub.GrpcDatastoreAdminCallableFactory;
import com.google.datastore.admin.v1.CreateIndexRequest;
import com.google.datastore.admin.v1.DeleteIndexRequest;
import com.google.datastore.admin.v1.ExportEntitiesMetadata;
import com.google.datastore.admin.v1.ExportEntitiesRequest;
import com.google.datastore.admin.v1.ExportEntitiesResponse;
import com.google.datastore.admin.v1.GetIndexRequest;
import com.google.datastore.admin.v1.ImportEntitiesMetadata;
import com.google.datastore.admin.v1.ImportEntitiesRequest;
import com.google.datastore.admin.v1.Index;
import com.google.datastore.admin.v1.IndexOperationMetadata;
import com.google.datastore.admin.v1.ListIndexesRequest;
import com.google.datastore.admin.v1.ListIndexesResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcDatastoreAdminStub
extends DatastoreAdminStub {
    private static final MethodDescriptor<ExportEntitiesRequest, Operation> exportEntitiesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.datastore.admin.v1.DatastoreAdmin/ExportEntities").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportEntitiesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ImportEntitiesRequest, Operation> importEntitiesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.datastore.admin.v1.DatastoreAdmin/ImportEntities").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportEntitiesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateIndexRequest, Operation> createIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.datastore.admin.v1.DatastoreAdmin/CreateIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteIndexRequest, Operation> deleteIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.datastore.admin.v1.DatastoreAdmin/DeleteIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIndexRequest, Index> getIndexMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.datastore.admin.v1.DatastoreAdmin/GetIndex").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIndexRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Index.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListIndexesRequest, ListIndexesResponse> listIndexesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.datastore.admin.v1.DatastoreAdmin/ListIndexes").setRequestMarshaller(ProtoUtils.marshaller((Message)ListIndexesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListIndexesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ExportEntitiesRequest, Operation> exportEntitiesCallable;
    private final OperationCallable<ExportEntitiesRequest, ExportEntitiesResponse, ExportEntitiesMetadata> exportEntitiesOperationCallable;
    private final UnaryCallable<ImportEntitiesRequest, Operation> importEntitiesCallable;
    private final OperationCallable<ImportEntitiesRequest, Empty, ImportEntitiesMetadata> importEntitiesOperationCallable;
    private final UnaryCallable<CreateIndexRequest, Operation> createIndexCallable;
    private final OperationCallable<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationCallable;
    private final UnaryCallable<DeleteIndexRequest, Operation> deleteIndexCallable;
    private final OperationCallable<DeleteIndexRequest, Index, IndexOperationMetadata> deleteIndexOperationCallable;
    private final UnaryCallable<GetIndexRequest, Index> getIndexCallable;
    private final UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable;
    private final UnaryCallable<ListIndexesRequest, DatastoreAdminClient.ListIndexesPagedResponse> listIndexesPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDatastoreAdminStub create(DatastoreAdminStubSettings settings) throws IOException {
        return new GrpcDatastoreAdminStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDatastoreAdminStub create(ClientContext clientContext) throws IOException {
        return new GrpcDatastoreAdminStub(DatastoreAdminStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDatastoreAdminStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDatastoreAdminStub(DatastoreAdminStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDatastoreAdminStub(DatastoreAdminStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDatastoreAdminCallableFactory());
    }

    protected GrpcDatastoreAdminStub(DatastoreAdminStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings exportEntitiesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportEntitiesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project_id", String.valueOf(request.getProjectId()));
            return builder.build();
        }).build();
        GrpcCallSettings importEntitiesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importEntitiesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project_id", String.valueOf(request.getProjectId()));
            return builder.build();
        }).build();
        GrpcCallSettings createIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createIndexMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project_id", String.valueOf(request.getProjectId()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteIndexMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("index_id", String.valueOf(request.getIndexId()));
            builder.add("project_id", String.valueOf(request.getProjectId()));
            return builder.build();
        }).build();
        GrpcCallSettings getIndexTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIndexMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("index_id", String.valueOf(request.getIndexId()));
            builder.add("project_id", String.valueOf(request.getProjectId()));
            return builder.build();
        }).build();
        GrpcCallSettings listIndexesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listIndexesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project_id", String.valueOf(request.getProjectId()));
            return builder.build();
        }).build();
        this.exportEntitiesCallable = callableFactory.createUnaryCallable(exportEntitiesTransportSettings, settings.exportEntitiesSettings(), clientContext);
        this.exportEntitiesOperationCallable = callableFactory.createOperationCallable(exportEntitiesTransportSettings, settings.exportEntitiesOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.importEntitiesCallable = callableFactory.createUnaryCallable(importEntitiesTransportSettings, settings.importEntitiesSettings(), clientContext);
        this.importEntitiesOperationCallable = callableFactory.createOperationCallable(importEntitiesTransportSettings, settings.importEntitiesOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.createIndexCallable = callableFactory.createUnaryCallable(createIndexTransportSettings, settings.createIndexSettings(), clientContext);
        this.createIndexOperationCallable = callableFactory.createOperationCallable(createIndexTransportSettings, settings.createIndexOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteIndexCallable = callableFactory.createUnaryCallable(deleteIndexTransportSettings, settings.deleteIndexSettings(), clientContext);
        this.deleteIndexOperationCallable = callableFactory.createOperationCallable(deleteIndexTransportSettings, settings.deleteIndexOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getIndexCallable = callableFactory.createUnaryCallable(getIndexTransportSettings, settings.getIndexSettings(), clientContext);
        this.listIndexesCallable = callableFactory.createUnaryCallable(listIndexesTransportSettings, settings.listIndexesSettings(), clientContext);
        this.listIndexesPagedCallable = callableFactory.createPagedCallable(listIndexesTransportSettings, settings.listIndexesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ExportEntitiesRequest, Operation> exportEntitiesCallable() {
        return this.exportEntitiesCallable;
    }

    @Override
    public OperationCallable<ExportEntitiesRequest, ExportEntitiesResponse, ExportEntitiesMetadata> exportEntitiesOperationCallable() {
        return this.exportEntitiesOperationCallable;
    }

    @Override
    public UnaryCallable<ImportEntitiesRequest, Operation> importEntitiesCallable() {
        return this.importEntitiesCallable;
    }

    @Override
    public OperationCallable<ImportEntitiesRequest, Empty, ImportEntitiesMetadata> importEntitiesOperationCallable() {
        return this.importEntitiesOperationCallable;
    }

    @Override
    public UnaryCallable<CreateIndexRequest, Operation> createIndexCallable() {
        return this.createIndexCallable;
    }

    @Override
    public OperationCallable<CreateIndexRequest, Index, IndexOperationMetadata> createIndexOperationCallable() {
        return this.createIndexOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteIndexRequest, Operation> deleteIndexCallable() {
        return this.deleteIndexCallable;
    }

    @Override
    public OperationCallable<DeleteIndexRequest, Index, IndexOperationMetadata> deleteIndexOperationCallable() {
        return this.deleteIndexOperationCallable;
    }

    @Override
    public UnaryCallable<GetIndexRequest, Index> getIndexCallable() {
        return this.getIndexCallable;
    }

    @Override
    public UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable() {
        return this.listIndexesCallable;
    }

    @Override
    public UnaryCallable<ListIndexesRequest, DatastoreAdminClient.ListIndexesPagedResponse> listIndexesPagedCallable() {
        return this.listIndexesPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

