/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.datastore.v1.stub.DatastoreStub;
import com.google.cloud.datastore.v1.stub.DatastoreStubSettings;
import com.google.cloud.datastore.v1.stub.HttpJsonDatastoreCallableFactory;
import com.google.datastore.v1.AllocateIdsRequest;
import com.google.datastore.v1.AllocateIdsResponse;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.BeginTransactionResponse;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.LookupRequest;
import com.google.datastore.v1.LookupResponse;
import com.google.datastore.v1.ReserveIdsRequest;
import com.google.datastore.v1.ReserveIdsResponse;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.RollbackResponse;
import com.google.datastore.v1.RunAggregationQueryRequest;
import com.google.datastore.v1.RunAggregationQueryResponse;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonDatastoreStub
extends DatastoreStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<LookupRequest, LookupResponse> lookupMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.datastore.v1.Datastore/Lookup").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}:lookup", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearProjectId().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)LookupResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RunQueryRequest, RunQueryResponse> runQueryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.datastore.v1.Datastore/RunQuery").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}:runQuery", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearProjectId().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RunQueryResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.datastore.v1.Datastore/RunAggregationQuery").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}:runAggregationQuery", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearProjectId().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RunAggregationQueryResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BeginTransactionRequest, BeginTransactionResponse> beginTransactionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.datastore.v1.Datastore/BeginTransaction").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}:beginTransaction", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearProjectId().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BeginTransactionResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CommitRequest, CommitResponse> commitMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.datastore.v1.Datastore/Commit").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}:commit", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearProjectId().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CommitResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RollbackRequest, RollbackResponse> rollbackMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.datastore.v1.Datastore/Rollback").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}:rollback", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearProjectId().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RollbackResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<AllocateIdsRequest, AllocateIdsResponse> allocateIdsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.datastore.v1.Datastore/AllocateIds").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}:allocateIds", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearProjectId().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AllocateIdsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ReserveIdsRequest, ReserveIdsResponse> reserveIdsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.datastore.v1.Datastore/ReserveIds").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}:reserveIds", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearProjectId().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ReserveIdsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<LookupRequest, LookupResponse> lookupCallable;
    private final UnaryCallable<RunQueryRequest, RunQueryResponse> runQueryCallable;
    private final UnaryCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryCallable;
    private final UnaryCallable<BeginTransactionRequest, BeginTransactionResponse> beginTransactionCallable;
    private final UnaryCallable<CommitRequest, CommitResponse> commitCallable;
    private final UnaryCallable<RollbackRequest, RollbackResponse> rollbackCallable;
    private final UnaryCallable<AllocateIdsRequest, AllocateIdsResponse> allocateIdsCallable;
    private final UnaryCallable<ReserveIdsRequest, ReserveIdsResponse> reserveIdsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;
    private static final PathTemplate LOOKUP_0_PATH_TEMPLATE = PathTemplate.create((String)"{project_id=**}");
    private static final PathTemplate LOOKUP_1_PATH_TEMPLATE = PathTemplate.create((String)"{database_id=**}");
    private static final PathTemplate RUN_QUERY_0_PATH_TEMPLATE = PathTemplate.create((String)"{project_id=**}");
    private static final PathTemplate RUN_QUERY_1_PATH_TEMPLATE = PathTemplate.create((String)"{database_id=**}");
    private static final PathTemplate RUN_AGGREGATION_QUERY_0_PATH_TEMPLATE = PathTemplate.create((String)"{project_id=**}");
    private static final PathTemplate RUN_AGGREGATION_QUERY_1_PATH_TEMPLATE = PathTemplate.create((String)"{database_id=**}");
    private static final PathTemplate BEGIN_TRANSACTION_0_PATH_TEMPLATE = PathTemplate.create((String)"{project_id=**}");
    private static final PathTemplate BEGIN_TRANSACTION_1_PATH_TEMPLATE = PathTemplate.create((String)"{database_id=**}");
    private static final PathTemplate COMMIT_0_PATH_TEMPLATE = PathTemplate.create((String)"{project_id=**}");
    private static final PathTemplate COMMIT_1_PATH_TEMPLATE = PathTemplate.create((String)"{database_id=**}");
    private static final PathTemplate ROLLBACK_0_PATH_TEMPLATE = PathTemplate.create((String)"{project_id=**}");
    private static final PathTemplate ROLLBACK_1_PATH_TEMPLATE = PathTemplate.create((String)"{database_id=**}");
    private static final PathTemplate ALLOCATE_IDS_0_PATH_TEMPLATE = PathTemplate.create((String)"{project_id=**}");
    private static final PathTemplate ALLOCATE_IDS_1_PATH_TEMPLATE = PathTemplate.create((String)"{database_id=**}");
    private static final PathTemplate RESERVE_IDS_0_PATH_TEMPLATE = PathTemplate.create((String)"{project_id=**}");
    private static final PathTemplate RESERVE_IDS_1_PATH_TEMPLATE = PathTemplate.create((String)"{database_id=**}");

    public static final HttpJsonDatastoreStub create(DatastoreStubSettings settings) throws IOException {
        return new HttpJsonDatastoreStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDatastoreStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDatastoreStub(DatastoreStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDatastoreStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDatastoreStub(DatastoreStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDatastoreStub(DatastoreStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDatastoreCallableFactory());
    }

    protected HttpJsonDatastoreStub(DatastoreStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings lookupTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(lookupMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProjectId(), "project_id", LOOKUP_0_PATH_TEMPLATE);
            builder.add(request.getDatabaseId(), "database_id", LOOKUP_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings runQueryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(runQueryMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProjectId(), "project_id", RUN_QUERY_0_PATH_TEMPLATE);
            builder.add(request.getDatabaseId(), "database_id", RUN_QUERY_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings runAggregationQueryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(runAggregationQueryMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProjectId(), "project_id", RUN_AGGREGATION_QUERY_0_PATH_TEMPLATE);
            builder.add(request.getDatabaseId(), "database_id", RUN_AGGREGATION_QUERY_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings beginTransactionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(beginTransactionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProjectId(), "project_id", BEGIN_TRANSACTION_0_PATH_TEMPLATE);
            builder.add(request.getDatabaseId(), "database_id", BEGIN_TRANSACTION_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings commitTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(commitMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProjectId(), "project_id", COMMIT_0_PATH_TEMPLATE);
            builder.add(request.getDatabaseId(), "database_id", COMMIT_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings rollbackTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(rollbackMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProjectId(), "project_id", ROLLBACK_0_PATH_TEMPLATE);
            builder.add(request.getDatabaseId(), "database_id", ROLLBACK_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings allocateIdsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(allocateIdsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProjectId(), "project_id", ALLOCATE_IDS_0_PATH_TEMPLATE);
            builder.add(request.getDatabaseId(), "database_id", ALLOCATE_IDS_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings reserveIdsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(reserveIdsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProjectId(), "project_id", RESERVE_IDS_0_PATH_TEMPLATE);
            builder.add(request.getDatabaseId(), "database_id", RESERVE_IDS_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        this.lookupCallable = callableFactory.createUnaryCallable(lookupTransportSettings, settings.lookupSettings(), clientContext);
        this.runQueryCallable = callableFactory.createUnaryCallable(runQueryTransportSettings, settings.runQuerySettings(), clientContext);
        this.runAggregationQueryCallable = callableFactory.createUnaryCallable(runAggregationQueryTransportSettings, settings.runAggregationQuerySettings(), clientContext);
        this.beginTransactionCallable = callableFactory.createUnaryCallable(beginTransactionTransportSettings, settings.beginTransactionSettings(), clientContext);
        this.commitCallable = callableFactory.createUnaryCallable(commitTransportSettings, settings.commitSettings(), clientContext);
        this.rollbackCallable = callableFactory.createUnaryCallable(rollbackTransportSettings, settings.rollbackSettings(), clientContext);
        this.allocateIdsCallable = callableFactory.createUnaryCallable(allocateIdsTransportSettings, settings.allocateIdsSettings(), clientContext);
        this.reserveIdsCallable = callableFactory.createUnaryCallable(reserveIdsTransportSettings, settings.reserveIdsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(lookupMethodDescriptor);
        methodDescriptors.add(runQueryMethodDescriptor);
        methodDescriptors.add(runAggregationQueryMethodDescriptor);
        methodDescriptors.add(beginTransactionMethodDescriptor);
        methodDescriptors.add(commitMethodDescriptor);
        methodDescriptors.add(rollbackMethodDescriptor);
        methodDescriptors.add(allocateIdsMethodDescriptor);
        methodDescriptors.add(reserveIdsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<LookupRequest, LookupResponse> lookupCallable() {
        return this.lookupCallable;
    }

    @Override
    public UnaryCallable<RunQueryRequest, RunQueryResponse> runQueryCallable() {
        return this.runQueryCallable;
    }

    @Override
    public UnaryCallable<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQueryCallable() {
        return this.runAggregationQueryCallable;
    }

    @Override
    public UnaryCallable<BeginTransactionRequest, BeginTransactionResponse> beginTransactionCallable() {
        return this.beginTransactionCallable;
    }

    @Override
    public UnaryCallable<CommitRequest, CommitResponse> commitCallable() {
        return this.commitCallable;
    }

    @Override
    public UnaryCallable<RollbackRequest, RollbackResponse> rollbackCallable() {
        return this.rollbackCallable;
    }

    @Override
    public UnaryCallable<AllocateIdsRequest, AllocateIdsResponse> allocateIdsCallable() {
        return this.allocateIdsCallable;
    }

    @Override
    public UnaryCallable<ReserveIdsRequest, ReserveIdsResponse> reserveIdsCallable() {
        return this.reserveIdsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

