/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.core.ApiClock;
import com.google.api.core.BetaApi;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.BaseService;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.RetryHelper;
import com.google.cloud.ServiceOptions;
import com.google.cloud.datastore.AggregationQuery;
import com.google.cloud.datastore.AggregationResults;
import com.google.cloud.datastore.Batch;
import com.google.cloud.datastore.BatchImpl;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.DatastoreHelper;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.QueryResultsImpl;
import com.google.cloud.datastore.ReadOption;
import com.google.cloud.datastore.ReadOptionProtoPreparer;
import com.google.cloud.datastore.RecordQuery;
import com.google.cloud.datastore.RetryAndTraceDatastoreRpcDecorator;
import com.google.cloud.datastore.Transaction;
import com.google.cloud.datastore.TransactionExceptionHandler;
import com.google.cloud.datastore.TransactionImpl;
import com.google.cloud.datastore.TransactionOperationExceptionHandler;
import com.google.cloud.datastore.execution.AggregationQueryExecutor;
import com.google.cloud.datastore.models.ExplainOptions;
import com.google.cloud.datastore.spi.v1.DatastoreRpc;
import com.google.cloud.datastore.telemetry.TraceUtil;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.datastore.v1.AllocateIdsRequest;
import com.google.datastore.v1.AllocateIdsResponse;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.BeginTransactionResponse;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.EntityResult;
import com.google.datastore.v1.LookupRequest;
import com.google.datastore.v1.LookupResponse;
import com.google.datastore.v1.Mutation;
import com.google.datastore.v1.MutationResult;
import com.google.datastore.v1.ReadOptions;
import com.google.datastore.v1.ReserveIdsRequest;
import com.google.datastore.v1.ReserveIdsResponse;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.datastore.v1.TransactionOptions;
import com.google.protobuf.ByteString;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class DatastoreImpl
extends BaseService<DatastoreOptions>
implements Datastore {
    Logger logger = Logger.getLogger(Datastore.class.getName());
    private final DatastoreRpc datastoreRpc;
    private final RetrySettings retrySettings;
    private static final ExceptionHandler TRANSACTION_EXCEPTION_HANDLER = TransactionExceptionHandler.build();
    private static final ExceptionHandler TRANSACTION_OPERATION_EXCEPTION_HANDLER = TransactionOperationExceptionHandler.build();
    private final TraceUtil otelTraceUtil = ((DatastoreOptions)this.getOptions()).getTraceUtil();
    private final ReadOptionProtoPreparer readOptionProtoPreparer;
    private final AggregationQueryExecutor aggregationQueryExecutor;

    DatastoreImpl(DatastoreOptions options) {
        super((ServiceOptions)options);
        this.datastoreRpc = options.getDatastoreRpcV1();
        this.retrySettings = (RetrySettings)MoreObjects.firstNonNull((Object)options.getRetrySettings(), (Object)ServiceOptions.getNoRetrySettings());
        this.readOptionProtoPreparer = new ReadOptionProtoPreparer();
        this.aggregationQueryExecutor = new AggregationQueryExecutor(new RetryAndTraceDatastoreRpcDecorator(this.datastoreRpc, this.otelTraceUtil, this.retrySettings, options), options);
    }

    @Override
    public Batch newBatch() {
        return new BatchImpl(this);
    }

    @Override
    public Transaction newTransaction(TransactionOptions transactionOptions) {
        return new TransactionImpl(this, transactionOptions);
    }

    @Override
    public Transaction newTransaction() {
        return new TransactionImpl(this);
    }

    @Override
    public void close() throws Exception {
        try {
            this.datastoreRpc.close();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Failed to close channels", e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.datastoreRpc.isClosed();
    }

    @Override
    public <T> T runInTransaction(Datastore.TransactionCallable<T> callable) {
        TraceUtil.Span span = this.otelTraceUtil.startSpan("Transaction.Run");
        Callable<T> transactionCallable = ((DatastoreOptions)this.getOptions()).getOpenTelemetryOptions().isEnabled() ? new TracedReadWriteTransactionCallable<T>(this, callable, null, span) : new ReadWriteTransactionCallable<T>(this, callable, null);
        try {
            Object object;
            block11: {
                TraceUtil.Scope ignored = span.makeCurrent();
                try {
                    object = RetryHelper.runWithRetries(transactionCallable, (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)TRANSACTION_EXCEPTION_HANDLER, (ApiClock)((DatastoreOptions)this.getOptions()).getClock());
                    if (ignored == null) break block11;
                    ignored.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RetryHelper.RetryHelperException e) {
                        span.end(e);
                        throw DatastoreException.translateAndThrow(e);
                    }
                }
            }
            return (T)object;
        }
        finally {
            span.end();
        }
    }

    @Override
    public <T> T runInTransaction(Datastore.TransactionCallable<T> callable, TransactionOptions transactionOptions) {
        TraceUtil.Span span = this.otelTraceUtil.startSpan("Transaction.Run");
        Callable<T> transactionCallable = ((DatastoreOptions)this.getOptions()).getOpenTelemetryOptions().isEnabled() ? new TracedReadWriteTransactionCallable<T>(this, callable, transactionOptions, span) : new ReadWriteTransactionCallable<T>(this, callable, transactionOptions);
        try {
            Object object;
            block11: {
                TraceUtil.Scope ignored = span.makeCurrent();
                try {
                    object = RetryHelper.runWithRetries(transactionCallable, (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)TRANSACTION_EXCEPTION_HANDLER, (ApiClock)((DatastoreOptions)this.getOptions()).getClock());
                    if (ignored == null) break block11;
                    ignored.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RetryHelper.RetryHelperException e) {
                        span.end(e);
                        throw DatastoreException.translateAndThrow(e);
                    }
                }
            }
            return (T)object;
        }
        finally {
            span.end();
        }
    }

    @Override
    public <T> QueryResults<T> run(Query<T> query) {
        return this.run(Optional.empty(), query, null);
    }

    @Override
    public <T> QueryResults<T> run(Query<T> query, ReadOption ... options) {
        return this.run(this.toReadOptionsPb(options), query, null);
    }

    @Override
    @BetaApi
    public <T> QueryResults<T> run(Query<T> query, ExplainOptions explainOptions, ReadOption ... options) {
        return this.run(this.toReadOptionsPb(options), query, explainOptions.toPb());
    }

    <T> QueryResults<T> run(Optional<ReadOptions> readOptionsPb, Query<T> query, com.google.datastore.v1.ExplainOptions explainOptions) {
        return new QueryResultsImpl(this, readOptionsPb, (RecordQuery)((Object)query), query.getNamespace(), explainOptions);
    }

    @Override
    public AggregationResults runAggregation(AggregationQuery query) {
        return this.aggregationQueryExecutor.execute(query, (ExplainOptions)null, new ReadOption[0]);
    }

    @Override
    public AggregationResults runAggregation(AggregationQuery query, ReadOption ... options) {
        return this.aggregationQueryExecutor.execute(query, (ExplainOptions)null, options);
    }

    @Override
    @BetaApi
    public AggregationResults runAggregation(AggregationQuery query, ExplainOptions explainOptions) {
        return this.aggregationQueryExecutor.execute(query, explainOptions, new ReadOption[0]);
    }

    @Override
    @BetaApi
    public AggregationResults runAggregation(AggregationQuery query, ExplainOptions explainOptions, ReadOption ... options) {
        return this.aggregationQueryExecutor.execute(query, explainOptions, options);
    }

    RunQueryResponse runQuery(RunQueryRequest requestPb) {
        ReadOptions readOptions = requestPb.getReadOptions();
        boolean isTransactional = readOptions.hasTransaction() || readOptions.hasNewTransaction();
        String spanName = isTransactional ? "Transaction.RunQuery" : "RunQuery";
        TraceUtil.Span span = this.otelTraceUtil.startSpan(spanName);
        try {
            TraceUtil.Scope ignored = span.makeCurrent();
            try {
                RunQueryResponse response = (RunQueryResponse)RetryHelper.runWithRetries(() -> this.datastoreRpc.runQuery(requestPb), (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)(requestPb.getReadOptions().getTransaction().isEmpty() ? EXCEPTION_HANDLER : TRANSACTION_OPERATION_EXCEPTION_HANDLER), (ApiClock)((DatastoreOptions)this.getOptions()).getClock());
                span.addEvent(spanName + " complete.", (Map<String, Object>)new ImmutableMap.Builder().put((Object)"doc_count", (Object)response.getBatch().getEntityResultsCount()).put((Object)"transactional", (Object)isTransactional).put((Object)"read_consistency", (Object)readOptions.getReadConsistency().toString()).put((Object)"transaction_id", (Object)(isTransactional ? requestPb.getReadOptions().getTransaction().toStringUtf8() : "")).put((Object)"mor_results", (Object)response.getBatch().getMoreResults().toString()).build());
                RunQueryResponse runQueryResponse = response;
                if (ignored != null) {
                    ignored.close();
                }
                return runQueryResponse;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RetryHelper.RetryHelperException e) {
                    span.end(e);
                    throw DatastoreException.translateAndThrow(e);
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Key allocateId(IncompleteKey key) {
        return DatastoreHelper.allocateId(this, key);
    }

    private boolean verifyIncompleteKeyType(IncompleteKey ... keys) {
        for (IncompleteKey key : keys) {
            if (!(key instanceof Key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Key> allocateId(IncompleteKey ... keys) {
        Preconditions.checkArgument((boolean)this.verifyIncompleteKeyType(keys), (Object)"keys must be IncompleteKey instances");
        if (keys.length == 0) {
            return Collections.emptyList();
        }
        AllocateIdsRequest.Builder requestPb = AllocateIdsRequest.newBuilder();
        for (IncompleteKey key : keys) {
            requestPb.addKeys(this.trimNameOrId(key).toPb());
        }
        requestPb.setProjectId(((DatastoreOptions)this.getOptions()).getProjectId());
        requestPb.setDatabaseId(((DatastoreOptions)this.getOptions()).getDatabaseId());
        AllocateIdsResponse responsePb = this.allocateIds(requestPb.build());
        ImmutableList.Builder keyList = ImmutableList.builder();
        for (com.google.datastore.v1.Key keyPb : responsePb.getKeysList()) {
            keyList.add((Object)Key.fromPb(keyPb));
        }
        return keyList.build();
    }

    private AllocateIdsResponse allocateIds(final AllocateIdsRequest requestPb) {
        TraceUtil.Span span = this.otelTraceUtil.startSpan("AllocateIds");
        try {
            TraceUtil.Scope ignored = span.makeCurrent();
            try {
                AllocateIdsResponse allocateIdsResponse = (AllocateIdsResponse)RetryHelper.runWithRetries((Callable)new Callable<AllocateIdsResponse>(){

                    @Override
                    public AllocateIdsResponse call() throws DatastoreException {
                        return DatastoreImpl.this.datastoreRpc.allocateIds(requestPb);
                    }
                }, (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((DatastoreOptions)this.getOptions()).getClock());
                if (ignored != null) {
                    ignored.close();
                }
                return allocateIdsResponse;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RetryHelper.RetryHelperException e) {
                    span.end(e);
                    throw DatastoreException.translateAndThrow(e);
                }
            }
        }
        finally {
            span.end();
        }
    }

    private IncompleteKey trimNameOrId(IncompleteKey key) {
        if (key instanceof Key) {
            return IncompleteKey.newBuilder(key).build();
        }
        return key;
    }

    @Override
    public Entity add(FullEntity<?> entity) {
        return DatastoreHelper.add(this, entity);
    }

    @Override
    public List<Entity> add(FullEntity<?> ... entities) {
        if (entities.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Mutation> mutationsPb = new ArrayList<Mutation>();
        LinkedHashMap<Key, Entity> completeEntities = new LinkedHashMap<Key, Entity>();
        for (FullEntity<Key> fullEntity : entities) {
            Entity completeEntity = null;
            if (fullEntity.getKey() instanceof Key) {
                completeEntity = Entity.convert(fullEntity);
            }
            if (completeEntity != null) {
                if (completeEntities.put((Key)completeEntity.getKey(), completeEntity) != null) {
                    throw DatastoreException.throwInvalidRequest("Duplicate entity with the key %s", fullEntity.getKey());
                }
            } else {
                Preconditions.checkArgument((boolean)fullEntity.hasKey(), (String)"Entity %s is missing a key", fullEntity);
            }
            mutationsPb.add(Mutation.newBuilder().setInsert(fullEntity.toPb()).build());
        }
        CommitResponse commitResponse = this.commitMutation(mutationsPb);
        Iterator mutationResults = commitResponse.getMutationResultsList().iterator();
        ImmutableList.Builder responseBuilder = ImmutableList.builder();
        for (FullEntity<?> entity : entities) {
            Entity completeEntity = (Entity)completeEntities.get(entity.getKey());
            if (completeEntity != null) {
                responseBuilder.add((Object)completeEntity);
                mutationResults.next();
                continue;
            }
            responseBuilder.add((Object)Entity.newBuilder(Key.fromPb(((MutationResult)mutationResults.next()).getKey()), entity).build());
        }
        return responseBuilder.build();
    }

    @Override
    public Entity get(Key key) {
        return DatastoreHelper.get(this, key, new ReadOption[0]);
    }

    @Override
    public Entity get(Key key, ReadOption ... options) {
        return DatastoreHelper.get(this, key, options);
    }

    @Override
    public Iterator<Entity> get(Key ... keys) {
        return this.get(Optional.empty(), keys);
    }

    @Override
    public Iterator<Entity> get(Iterable<Key> keys, ReadOption ... options) {
        return this.get(this.toReadOptionsPb(options), (Key[])Iterables.toArray(keys, Key.class));
    }

    private Optional<ReadOptions> toReadOptionsPb(ReadOption ... options) {
        if (options == null) {
            return Optional.empty();
        }
        return this.readOptionProtoPreparer.prepare(Arrays.asList(options));
    }

    @Override
    public List<Entity> fetch(Key ... keys) {
        return DatastoreHelper.fetch(this, keys, new ReadOption[0]);
    }

    @Override
    public List<Entity> fetch(Iterable<Key> keys, ReadOption ... options) {
        return DatastoreHelper.fetch(this, (Key[])Iterables.toArray(keys, Key.class), options);
    }

    Iterator<Entity> get(Optional<ReadOptions> readOptionsPb, Key ... keys) {
        if (keys.length == 0) {
            return Collections.emptyIterator();
        }
        LookupRequest.Builder requestPb = LookupRequest.newBuilder();
        readOptionsPb.ifPresent(arg_0 -> ((LookupRequest.Builder)requestPb).setReadOptions(arg_0));
        for (Key k : Sets.newLinkedHashSet(Arrays.asList(keys))) {
            requestPb.addKeys(k.toPb());
        }
        requestPb.setProjectId(((DatastoreOptions)this.getOptions()).getProjectId());
        requestPb.setDatabaseId(((DatastoreOptions)this.getOptions()).getDatabaseId());
        return new ResultsIterator(requestPb);
    }

    LookupResponse lookup(LookupRequest requestPb) {
        ReadOptions readOptions = requestPb.getReadOptions();
        boolean isTransactional = readOptions.hasTransaction() || readOptions.hasNewTransaction();
        String spanName = isTransactional ? "Transaction.Lookup" : "Lookup";
        TraceUtil.Span span = this.otelTraceUtil.startSpan(spanName);
        try {
            TraceUtil.Scope ignored = span.makeCurrent();
            try {
                LookupResponse lookupResponse = (LookupResponse)RetryHelper.runWithRetries(() -> {
                    LookupResponse response = this.datastoreRpc.lookup(requestPb);
                    span.addEvent(spanName + " complete.", (Map<String, Object>)new ImmutableMap.Builder().put((Object)"Received", (Object)response.getFoundCount()).put((Object)"Missing", (Object)response.getMissingCount()).put((Object)"Deferred", (Object)response.getDeferredCount()).put((Object)"transactional", (Object)isTransactional).put((Object)"transaction_id", (Object)(isTransactional ? readOptions.getTransaction().toStringUtf8() : "")).build());
                    return response;
                }, (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)(requestPb.getReadOptions().getTransaction().isEmpty() ? EXCEPTION_HANDLER : TRANSACTION_OPERATION_EXCEPTION_HANDLER), (ApiClock)((DatastoreOptions)this.getOptions()).getClock());
                if (ignored != null) {
                    ignored.close();
                }
                return lookupResponse;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RetryHelper.RetryHelperException e) {
                    span.end(e);
                    throw DatastoreException.translateAndThrow(e);
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Key> reserveIds(Key ... keys) {
        ReserveIdsRequest.Builder requestPb = ReserveIdsRequest.newBuilder();
        for (Key key : keys) {
            requestPb.addKeys(key.toPb());
        }
        requestPb.setProjectId(((DatastoreOptions)this.getOptions()).getProjectId());
        requestPb.setDatabaseId(((DatastoreOptions)this.getOptions()).getDatabaseId());
        ReserveIdsResponse responsePb = this.reserveIds(requestPb.build());
        ImmutableList.Builder keyList = ImmutableList.builder();
        if (responsePb.isInitialized()) {
            for (Key key : keys) {
                keyList.add((Object)key);
            }
        }
        return keyList.build();
    }

    ReserveIdsResponse reserveIds(final ReserveIdsRequest requestPb) {
        TraceUtil.Span span = this.otelTraceUtil.startSpan("ReserveIds");
        try {
            TraceUtil.Scope ignored = span.makeCurrent();
            try {
                ReserveIdsResponse reserveIdsResponse = (ReserveIdsResponse)RetryHelper.runWithRetries((Callable)new Callable<ReserveIdsResponse>(){

                    @Override
                    public ReserveIdsResponse call() throws DatastoreException {
                        return DatastoreImpl.this.datastoreRpc.reserveIds(requestPb);
                    }
                }, (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((DatastoreOptions)this.getOptions()).getClock());
                if (ignored != null) {
                    ignored.close();
                }
                return reserveIdsResponse;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RetryHelper.RetryHelperException e) {
                    span.end(e);
                    throw DatastoreException.translateAndThrow(e);
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public void update(Entity ... entities) {
        if (entities.length > 0) {
            ArrayList<Mutation> mutationsPb = new ArrayList<Mutation>();
            LinkedHashMap<Key, Entity> dedupEntities = new LinkedHashMap<Key, Entity>();
            for (Entity entity : entities) {
                dedupEntities.put((Key)entity.getKey(), entity);
            }
            for (Entity entity : dedupEntities.values()) {
                mutationsPb.add(Mutation.newBuilder().setUpdate(entity.toPb()).build());
            }
            this.commitMutation(mutationsPb);
        }
    }

    @Override
    public Entity put(FullEntity<?> entity) {
        return DatastoreHelper.put(this, entity);
    }

    @Override
    public List<Entity> put(FullEntity<?> ... entities) {
        if (entities.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Mutation> mutationsPb = new ArrayList<Mutation>();
        LinkedHashMap<Key, Entity> dedupEntities = new LinkedHashMap<Key, Entity>();
        for (FullEntity<Key> fullEntity : entities) {
            Preconditions.checkArgument((boolean)fullEntity.hasKey(), (String)"Entity %s is missing a key", fullEntity);
            if (fullEntity.getKey() instanceof Key) {
                Entity completeEntity = Entity.convert(fullEntity);
                dedupEntities.put((Key)completeEntity.getKey(), completeEntity);
                continue;
            }
            mutationsPb.add(Mutation.newBuilder().setUpsert(fullEntity.toPb()).build());
        }
        for (Entity entity : dedupEntities.values()) {
            mutationsPb.add(Mutation.newBuilder().setUpsert(entity.toPb()).build());
        }
        CommitResponse commitResponse = this.commitMutation(mutationsPb);
        Iterator mutationResults = commitResponse.getMutationResultsList().iterator();
        ImmutableList.Builder responseBuilder = ImmutableList.builder();
        for (FullEntity<?> entity : entities) {
            Entity completeEntity = (Entity)dedupEntities.get(entity.getKey());
            if (completeEntity != null) {
                responseBuilder.add((Object)completeEntity);
                continue;
            }
            responseBuilder.add((Object)Entity.newBuilder(Key.fromPb(((MutationResult)mutationResults.next()).getKey()), entity).build());
        }
        return responseBuilder.build();
    }

    @Override
    public void delete(Key ... keys) {
        if (keys.length > 0) {
            ArrayList<Mutation> mutationsPb = new ArrayList<Mutation>();
            LinkedHashSet<Key> dedupKeys = new LinkedHashSet<Key>(Arrays.asList(keys));
            for (Key key : dedupKeys) {
                mutationsPb.add(Mutation.newBuilder().setDelete(key.toPb()).build());
            }
            this.commitMutation(mutationsPb);
        }
    }

    @Override
    public KeyFactory newKeyFactory() {
        return DatastoreHelper.newKeyFactory((DatastoreOptions)this.getOptions());
    }

    private CommitResponse commitMutation(List<Mutation> mutationsPb) {
        CommitRequest.Builder requestPb = CommitRequest.newBuilder();
        requestPb.setMode(CommitRequest.Mode.NON_TRANSACTIONAL);
        requestPb.setProjectId(((DatastoreOptions)this.getOptions()).getProjectId());
        requestPb.setDatabaseId(((DatastoreOptions)this.getOptions()).getDatabaseId());
        requestPb.addAllMutations(mutationsPb);
        return this.commit(requestPb.build());
    }

    CommitResponse commit(CommitRequest requestPb) {
        boolean isTransactional = requestPb.hasTransaction() || requestPb.hasSingleUseTransaction();
        String spanName = isTransactional ? "Transaction.Commit" : "Commit";
        TraceUtil.Span span = this.otelTraceUtil.startSpan(spanName);
        try {
            TraceUtil.Scope ignored = span.makeCurrent();
            try {
                CommitResponse response = (CommitResponse)RetryHelper.runWithRetries(() -> this.datastoreRpc.commit(requestPb), (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)(requestPb.getTransaction().isEmpty() ? EXCEPTION_HANDLER : TRANSACTION_OPERATION_EXCEPTION_HANDLER), (ApiClock)((DatastoreOptions)this.getOptions()).getClock());
                span.addEvent(spanName + " complete.", (Map<String, Object>)new ImmutableMap.Builder().put((Object)"doc_count", (Object)response.getMutationResultsCount()).put((Object)"transactional", (Object)isTransactional).put((Object)"transaction_id", (Object)(isTransactional ? requestPb.getTransaction().toStringUtf8() : "")).build());
                CommitResponse commitResponse = response;
                if (ignored != null) {
                    ignored.close();
                }
                return commitResponse;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RetryHelper.RetryHelperException e) {
                    span.end(e);
                    throw DatastoreException.translateAndThrow(e);
                }
            }
        }
        finally {
            span.end();
        }
    }

    ByteString requestTransactionId(BeginTransactionRequest.Builder requestPb) {
        return this.beginTransaction(requestPb.build()).getTransaction();
    }

    BeginTransactionResponse beginTransaction(BeginTransactionRequest requestPb) {
        TraceUtil.Span span = this.otelTraceUtil.startSpan("Transaction.Begin");
        try {
            TraceUtil.Scope scope = span.makeCurrent();
            try {
                BeginTransactionResponse beginTransactionResponse = (BeginTransactionResponse)RetryHelper.runWithRetries(() -> this.datastoreRpc.beginTransaction(requestPb), (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((DatastoreOptions)this.getOptions()).getClock());
                if (scope != null) {
                    scope.close();
                }
                return beginTransactionResponse;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RetryHelper.RetryHelperException e) {
                    span.end(e);
                    throw DatastoreException.translateAndThrow(e);
                }
            }
        }
        finally {
            span.end();
        }
    }

    void rollbackTransaction(ByteString transaction) {
        RollbackRequest.Builder requestPb = RollbackRequest.newBuilder();
        requestPb.setTransaction(transaction);
        requestPb.setProjectId(((DatastoreOptions)this.getOptions()).getProjectId());
        requestPb.setDatabaseId(((DatastoreOptions)this.getOptions()).getDatabaseId());
        this.rollback(requestPb.build());
    }

    void rollback(final RollbackRequest requestPb) {
        TraceUtil.Span span = this.otelTraceUtil.startSpan("Transaction.Rollback");
        try (TraceUtil.Scope scope = span.makeCurrent();){
            RetryHelper.runWithRetries((Callable)new Callable<Void>(){

                @Override
                public Void call() throws DatastoreException {
                    DatastoreImpl.this.datastoreRpc.rollback(requestPb);
                    return null;
                }
            }, (RetrySettings)this.retrySettings, (ResultRetryAlgorithm)EXCEPTION_HANDLER, (ApiClock)((DatastoreOptions)this.getOptions()).getClock());
            span.addEvent("Transaction.Rollback", (Map<String, Object>)new ImmutableMap.Builder().put((Object)"transaction_id", (Object)requestPb.getTransaction().toStringUtf8()).build());
        }
        catch (RetryHelper.RetryHelperException e) {
            span.end(e);
            throw DatastoreException.translateAndThrow(e);
        }
        finally {
            span.end();
        }
    }

    static class TracedReadWriteTransactionCallable<T>
    implements Callable<T> {
        private final Datastore datastore;
        private final Datastore.TransactionCallable<T> callable;
        private volatile TransactionOptions options;
        private volatile Transaction transaction;
        private final TraceUtil.Span parentSpan;

        TracedReadWriteTransactionCallable(Datastore datastore, Datastore.TransactionCallable<T> callable, TransactionOptions options, @Nullable TraceUtil.Span parentSpan) {
            this.datastore = datastore;
            this.callable = callable;
            this.options = options;
            this.transaction = null;
            this.parentSpan = parentSpan;
        }

        Datastore getDatastore() {
            return this.datastore;
        }

        TransactionOptions getOptions() {
            return this.options;
        }

        Transaction getTransaction() {
            return this.transaction;
        }

        void setPrevTransactionId(ByteString transactionId) {
            TransactionOptions.ReadWrite readWrite = TransactionOptions.ReadWrite.newBuilder().setPreviousTransaction(transactionId).build();
            this.options = this.options.toBuilder().setReadWrite(readWrite).build();
        }

        @Override
        public T call() throws DatastoreException {
            try {
                T t;
                block13: {
                    Scope ignored = Context.current().with((ImplicitContextKeyed)this.parentSpan.getSpan()).makeCurrent();
                    try {
                        this.transaction = this.datastore.newTransaction(this.options);
                        T value = this.callable.run(this.transaction);
                        this.transaction.commit();
                        t = value;
                        if (ignored == null) break block13;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception ex) {
                            this.transaction.rollback();
                            throw DatastoreException.propagateUserException(ex);
                        }
                    }
                    ignored.close();
                }
                return t;
            }
            finally {
                if (this.transaction.isActive()) {
                    this.transaction.rollback();
                }
                if (this.options != null && this.options.getModeCase().equals((Object)TransactionOptions.ModeCase.READ_WRITE)) {
                    this.setPrevTransactionId(this.transaction.getTransactionId());
                }
            }
        }
    }

    static class ReadWriteTransactionCallable<T>
    implements Callable<T> {
        private final Datastore datastore;
        private final Datastore.TransactionCallable<T> callable;
        private volatile TransactionOptions options;
        private volatile Transaction transaction;

        ReadWriteTransactionCallable(Datastore datastore, Datastore.TransactionCallable<T> callable, TransactionOptions options) {
            this.datastore = datastore;
            this.callable = callable;
            this.options = options;
            this.transaction = null;
        }

        Datastore getDatastore() {
            return this.datastore;
        }

        TransactionOptions getOptions() {
            return this.options;
        }

        Transaction getTransaction() {
            return this.transaction;
        }

        void setPrevTransactionId(ByteString transactionId) {
            TransactionOptions.ReadWrite readWrite = TransactionOptions.ReadWrite.newBuilder().setPreviousTransaction(transactionId).build();
            this.options = this.options.toBuilder().setReadWrite(readWrite).build();
        }

        @Override
        public T call() throws DatastoreException {
            try {
                this.transaction = this.datastore.newTransaction(this.options);
                T value = this.callable.run(this.transaction);
                this.transaction.commit();
                T t = value;
                return t;
            }
            catch (Exception ex) {
                this.transaction.rollback();
                throw DatastoreException.propagateUserException(ex);
            }
            finally {
                if (this.transaction.isActive()) {
                    this.transaction.rollback();
                }
                if (this.options != null && this.options.getModeCase().equals((Object)TransactionOptions.ModeCase.READ_WRITE)) {
                    this.setPrevTransactionId(this.transaction.getTransactionId());
                }
            }
        }
    }

    final class ResultsIterator
    extends AbstractIterator<Entity> {
        private final LookupRequest.Builder requestPb;
        Iterator<EntityResult> iter;

        ResultsIterator(LookupRequest.Builder requestPb) {
            this.requestPb = requestPb;
            this.loadResults();
        }

        private void loadResults() {
            LookupResponse responsePb = DatastoreImpl.this.lookup(this.requestPb.build());
            this.iter = responsePb.getFoundList().iterator();
            this.requestPb.clearKeys();
            if (responsePb.getDeferredCount() > 0) {
                this.requestPb.addAllKeys((Iterable)responsePb.getDeferredList());
            }
        }

        protected Entity computeNext() {
            while (!this.iter.hasNext()) {
                if (this.requestPb.getKeysCount() == 0) {
                    return (Entity)this.endOfData();
                }
                this.loadResults();
            }
            return Entity.fromPb(this.iter.next().getEntity());
        }
    }
}

