/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.spi.v1;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.NoHeaderProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.ServiceOptions;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.DatastoreUtils;
import com.google.cloud.datastore.spi.v1.DatastoreRpc;
import com.google.cloud.datastore.spi.v1.RpcUtils;
import com.google.cloud.datastore.v1.DatastoreSettings;
import com.google.cloud.datastore.v1.stub.DatastoreStubSettings;
import com.google.cloud.datastore.v1.stub.GrpcDatastoreStub;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.common.base.Strings;
import com.google.datastore.v1.AllocateIdsRequest;
import com.google.datastore.v1.AllocateIdsResponse;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.BeginTransactionResponse;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.LookupRequest;
import com.google.datastore.v1.LookupResponse;
import com.google.datastore.v1.ReserveIdsRequest;
import com.google.datastore.v1.ReserveIdsResponse;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.RollbackResponse;
import com.google.datastore.v1.RunAggregationQueryRequest;
import com.google.datastore.v1.RunAggregationQueryResponse;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

@InternalApi
public class GrpcDatastoreRpc
implements DatastoreRpc {
    private final GrpcDatastoreStub datastoreStub;
    private final ClientContext clientContext;
    private boolean closed;

    public GrpcDatastoreRpc(DatastoreOptions datastoreOptions) throws IOException {
        try {
            this.clientContext = DatastoreUtils.isEmulator(datastoreOptions) ? this.getClientContextForEmulator(datastoreOptions) : this.getClientContext(datastoreOptions);
            DatastoreStubSettings datastoreStubSettings = ((DatastoreStubSettings.Builder)DatastoreStubSettings.newBuilder(this.clientContext).applyToAllUnaryMethods(RpcUtils.retrySettingSetter(datastoreOptions)).setTransportChannelProvider((TransportChannelProvider)DatastoreSettings.defaultGrpcTransportProviderBuilder().setChannelPoolSettings(ChannelPoolSettings.builder().setInitialChannelCount(1).setMinChannelCount(1).build()).build())).build();
            this.datastoreStub = GrpcDatastoreStub.create(datastoreStubSettings);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.datastoreStub.close();
            for (BackgroundResource resource : this.clientContext.getBackgroundResources()) {
                resource.close();
            }
            this.closed = true;
        }
        for (BackgroundResource resource : this.clientContext.getBackgroundResources()) {
            resource.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    @Override
    public AllocateIdsResponse allocateIds(AllocateIdsRequest request) {
        return (AllocateIdsResponse)this.datastoreStub.allocateIdsCallable().call((Object)request);
    }

    @Override
    public BeginTransactionResponse beginTransaction(BeginTransactionRequest request) throws DatastoreException {
        return (BeginTransactionResponse)this.datastoreStub.beginTransactionCallable().call((Object)request);
    }

    @Override
    public CommitResponse commit(CommitRequest request) {
        return (CommitResponse)this.datastoreStub.commitCallable().call((Object)request);
    }

    @Override
    public LookupResponse lookup(LookupRequest request) {
        return (LookupResponse)this.datastoreStub.lookupCallable().call((Object)request);
    }

    @Override
    public ReserveIdsResponse reserveIds(ReserveIdsRequest request) {
        return (ReserveIdsResponse)this.datastoreStub.reserveIdsCallable().call((Object)request);
    }

    @Override
    public RollbackResponse rollback(RollbackRequest request) {
        return (RollbackResponse)this.datastoreStub.rollbackCallable().call((Object)request);
    }

    @Override
    public RunQueryResponse runQuery(RunQueryRequest request) {
        return (RunQueryResponse)this.datastoreStub.runQueryCallable().call((Object)request);
    }

    @Override
    public RunAggregationQueryResponse runAggregationQuery(RunAggregationQueryRequest request) {
        return (RunAggregationQueryResponse)this.datastoreStub.runAggregationQueryCallable().call((Object)request);
    }

    @Override
    public boolean isClosed() {
        return this.closed && this.datastoreStub.isShutdown();
    }

    private ClientContext getClientContextForEmulator(DatastoreOptions datastoreOptions) throws IOException {
        ManagedChannel managedChannel = ManagedChannelBuilder.forTarget((String)DatastoreUtils.removeScheme(datastoreOptions.getHost())).usePlaintext().build();
        GrpcTransportChannel transportChannel = GrpcTransportChannel.create((ManagedChannel)managedChannel);
        return ClientContext.newBuilder().setCredentials(null).setTransportChannel((TransportChannel)transportChannel).setDefaultCallContext((ApiCallContext)GrpcCallContext.of((Channel)managedChannel, (CallOptions)CallOptions.DEFAULT)).setBackgroundResources(Collections.singletonList(transportChannel)).build();
    }

    private ClientContext getClientContext(DatastoreOptions datastoreOptions) throws IOException {
        ApiClientHeaderProvider internalHeaderProvider = DatastoreSettings.defaultApiClientHeaderProviderBuilder().setClientLibToken(ServiceOptions.getGoogApiClientLibName(), GaxProperties.getLibraryVersion(((Object)((Object)datastoreOptions)).getClass())).setResourceToken(this.getResourceToken(datastoreOptions)).build();
        DatastoreRpc.DatastoreSettingsBuilder settingsBuilder = new DatastoreRpc.DatastoreSettingsBuilder(DatastoreSettings.newBuilder().build());
        settingsBuilder.setCredentialsProvider(GrpcTransportOptions.setUpCredentialsProvider((ServiceOptions)datastoreOptions));
        settingsBuilder.setTransportChannelProvider(datastoreOptions.getTransportChannelProvider());
        settingsBuilder.setInternalHeaderProvider((HeaderProvider)internalHeaderProvider);
        settingsBuilder.setHeaderProvider(datastoreOptions.getMergedHeaderProvider((HeaderProvider)new NoHeaderProvider()));
        return ClientContext.create((ClientSettings)settingsBuilder.build());
    }

    private String getResourceToken(DatastoreOptions datastoreOptions) {
        StringBuilder builder = new StringBuilder("project_id=");
        builder.append(datastoreOptions.getProjectId());
        if (!Strings.isNullOrEmpty((String)datastoreOptions.getDatabaseId())) {
            builder.append("&database_id=");
            builder.append(datastoreOptions.getDatabaseId());
        }
        return builder.toString();
    }
}

