/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.core.BetaApi;
import com.google.cloud.Timestamp;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;

public abstract class ReadOption
implements Serializable {
    private static final long serialVersionUID = -4406964829189800528L;

    private ReadOption() {
    }

    public static EventualConsistency eventualConsistency() {
        return new EventualConsistency(true);
    }

    @BetaApi
    public static ReadTime readTime(Timestamp time) {
        return new ReadTime(time);
    }

    static Map<Class<? extends ReadOption>, ReadOption> asImmutableMap(ReadOption ... options) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ReadOption option : options) {
            builder.put(option.getClass(), (Object)option);
        }
        return builder.buildOrThrow();
    }

    public static final class ReadTime
    extends ReadOption {
        private static final long serialVersionUID = -6780321449114616067L;
        private final Timestamp time;

        private ReadTime(Timestamp time) {
            this.time = time;
        }

        public Timestamp time() {
            return this.time;
        }
    }

    public static final class EventualConsistency
    extends ReadOption {
        private static final long serialVersionUID = -6959530217724666172L;
        private final boolean eventualConsistency;

        private EventualConsistency(boolean eventualConsistency) {
            this.eventualConsistency = eventualConsistency;
        }

        public boolean isEventual() {
            return this.eventualConsistency;
        }
    }
}

