/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastream.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datastream.v1.ConnectionProfile;
import com.google.cloud.datastream.v1.CreateConnectionProfileRequest;
import com.google.cloud.datastream.v1.CreatePrivateConnectionRequest;
import com.google.cloud.datastream.v1.CreateRouteRequest;
import com.google.cloud.datastream.v1.CreateStreamRequest;
import com.google.cloud.datastream.v1.DatastreamClient;
import com.google.cloud.datastream.v1.DeleteConnectionProfileRequest;
import com.google.cloud.datastream.v1.DeletePrivateConnectionRequest;
import com.google.cloud.datastream.v1.DeleteRouteRequest;
import com.google.cloud.datastream.v1.DeleteStreamRequest;
import com.google.cloud.datastream.v1.DiscoverConnectionProfileRequest;
import com.google.cloud.datastream.v1.DiscoverConnectionProfileResponse;
import com.google.cloud.datastream.v1.FetchStaticIpsRequest;
import com.google.cloud.datastream.v1.FetchStaticIpsResponse;
import com.google.cloud.datastream.v1.GetConnectionProfileRequest;
import com.google.cloud.datastream.v1.GetPrivateConnectionRequest;
import com.google.cloud.datastream.v1.GetRouteRequest;
import com.google.cloud.datastream.v1.GetStreamObjectRequest;
import com.google.cloud.datastream.v1.GetStreamRequest;
import com.google.cloud.datastream.v1.ListConnectionProfilesRequest;
import com.google.cloud.datastream.v1.ListConnectionProfilesResponse;
import com.google.cloud.datastream.v1.ListPrivateConnectionsRequest;
import com.google.cloud.datastream.v1.ListPrivateConnectionsResponse;
import com.google.cloud.datastream.v1.ListRoutesRequest;
import com.google.cloud.datastream.v1.ListRoutesResponse;
import com.google.cloud.datastream.v1.ListStreamObjectsRequest;
import com.google.cloud.datastream.v1.ListStreamObjectsResponse;
import com.google.cloud.datastream.v1.ListStreamsRequest;
import com.google.cloud.datastream.v1.ListStreamsResponse;
import com.google.cloud.datastream.v1.LookupStreamObjectRequest;
import com.google.cloud.datastream.v1.OperationMetadata;
import com.google.cloud.datastream.v1.PrivateConnection;
import com.google.cloud.datastream.v1.Route;
import com.google.cloud.datastream.v1.RunStreamRequest;
import com.google.cloud.datastream.v1.StartBackfillJobRequest;
import com.google.cloud.datastream.v1.StartBackfillJobResponse;
import com.google.cloud.datastream.v1.StopBackfillJobRequest;
import com.google.cloud.datastream.v1.StopBackfillJobResponse;
import com.google.cloud.datastream.v1.Stream;
import com.google.cloud.datastream.v1.StreamObject;
import com.google.cloud.datastream.v1.UpdateConnectionProfileRequest;
import com.google.cloud.datastream.v1.UpdateStreamRequest;
import com.google.cloud.datastream.v1.stub.DatastreamStub;
import com.google.cloud.datastream.v1.stub.DatastreamStubSettings;
import com.google.cloud.datastream.v1.stub.GrpcDatastreamCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcDatastreamStub
extends DatastreamStub {
    private static final MethodDescriptor<ListConnectionProfilesRequest, ListConnectionProfilesResponse> listConnectionProfilesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/ListConnectionProfiles").setRequestMarshaller(ProtoUtils.marshaller((Message)ListConnectionProfilesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListConnectionProfilesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/GetConnectionProfile").setRequestMarshaller(ProtoUtils.marshaller((Message)GetConnectionProfileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ConnectionProfile.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateConnectionProfileRequest, Operation> createConnectionProfileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/CreateConnectionProfile").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateConnectionProfileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateConnectionProfileRequest, Operation> updateConnectionProfileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/UpdateConnectionProfile").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateConnectionProfileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/DeleteConnectionProfile").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteConnectionProfileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DiscoverConnectionProfileRequest, DiscoverConnectionProfileResponse> discoverConnectionProfileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/DiscoverConnectionProfile").setRequestMarshaller(ProtoUtils.marshaller((Message)DiscoverConnectionProfileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DiscoverConnectionProfileResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListStreamsRequest, ListStreamsResponse> listStreamsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/ListStreams").setRequestMarshaller(ProtoUtils.marshaller((Message)ListStreamsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListStreamsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetStreamRequest, Stream> getStreamMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/GetStream").setRequestMarshaller(ProtoUtils.marshaller((Message)GetStreamRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Stream.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateStreamRequest, Operation> createStreamMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/CreateStream").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateStreamRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateStreamRequest, Operation> updateStreamMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/UpdateStream").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateStreamRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteStreamRequest, Operation> deleteStreamMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/DeleteStream").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteStreamRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<RunStreamRequest, Operation> runStreamMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/RunStream").setRequestMarshaller(ProtoUtils.marshaller((Message)RunStreamRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetStreamObjectRequest, StreamObject> getStreamObjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/GetStreamObject").setRequestMarshaller(ProtoUtils.marshaller((Message)GetStreamObjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StreamObject.getDefaultInstance())).build();
    private static final MethodDescriptor<LookupStreamObjectRequest, StreamObject> lookupStreamObjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/LookupStreamObject").setRequestMarshaller(ProtoUtils.marshaller((Message)LookupStreamObjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StreamObject.getDefaultInstance())).build();
    private static final MethodDescriptor<ListStreamObjectsRequest, ListStreamObjectsResponse> listStreamObjectsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/ListStreamObjects").setRequestMarshaller(ProtoUtils.marshaller((Message)ListStreamObjectsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListStreamObjectsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<StartBackfillJobRequest, StartBackfillJobResponse> startBackfillJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/StartBackfillJob").setRequestMarshaller(ProtoUtils.marshaller((Message)StartBackfillJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StartBackfillJobResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<StopBackfillJobRequest, StopBackfillJobResponse> stopBackfillJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/StopBackfillJob").setRequestMarshaller(ProtoUtils.marshaller((Message)StopBackfillJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StopBackfillJobResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<FetchStaticIpsRequest, FetchStaticIpsResponse> fetchStaticIpsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/FetchStaticIps").setRequestMarshaller(ProtoUtils.marshaller((Message)FetchStaticIpsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FetchStaticIpsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreatePrivateConnectionRequest, Operation> createPrivateConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/CreatePrivateConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)CreatePrivateConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetPrivateConnectionRequest, PrivateConnection> getPrivateConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/GetPrivateConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPrivateConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PrivateConnection.getDefaultInstance())).build();
    private static final MethodDescriptor<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse> listPrivateConnectionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/ListPrivateConnections").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPrivateConnectionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPrivateConnectionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeletePrivateConnectionRequest, Operation> deletePrivateConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/DeletePrivateConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)DeletePrivateConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateRouteRequest, Operation> createRouteMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/CreateRoute").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateRouteRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetRouteRequest, Route> getRouteMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/GetRoute").setRequestMarshaller(ProtoUtils.marshaller((Message)GetRouteRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Route.getDefaultInstance())).build();
    private static final MethodDescriptor<ListRoutesRequest, ListRoutesResponse> listRoutesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/ListRoutes").setRequestMarshaller(ProtoUtils.marshaller((Message)ListRoutesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListRoutesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteRouteRequest, Operation> deleteRouteMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datastream.v1.Datastream/DeleteRoute").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteRouteRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<ListConnectionProfilesRequest, ListConnectionProfilesResponse> listConnectionProfilesCallable;
    private final UnaryCallable<ListConnectionProfilesRequest, DatastreamClient.ListConnectionProfilesPagedResponse> listConnectionProfilesPagedCallable;
    private final UnaryCallable<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileCallable;
    private final UnaryCallable<CreateConnectionProfileRequest, Operation> createConnectionProfileCallable;
    private final OperationCallable<CreateConnectionProfileRequest, ConnectionProfile, OperationMetadata> createConnectionProfileOperationCallable;
    private final UnaryCallable<UpdateConnectionProfileRequest, Operation> updateConnectionProfileCallable;
    private final OperationCallable<UpdateConnectionProfileRequest, ConnectionProfile, OperationMetadata> updateConnectionProfileOperationCallable;
    private final UnaryCallable<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileCallable;
    private final OperationCallable<DeleteConnectionProfileRequest, Empty, OperationMetadata> deleteConnectionProfileOperationCallable;
    private final UnaryCallable<DiscoverConnectionProfileRequest, DiscoverConnectionProfileResponse> discoverConnectionProfileCallable;
    private final UnaryCallable<ListStreamsRequest, ListStreamsResponse> listStreamsCallable;
    private final UnaryCallable<ListStreamsRequest, DatastreamClient.ListStreamsPagedResponse> listStreamsPagedCallable;
    private final UnaryCallable<GetStreamRequest, Stream> getStreamCallable;
    private final UnaryCallable<CreateStreamRequest, Operation> createStreamCallable;
    private final OperationCallable<CreateStreamRequest, Stream, OperationMetadata> createStreamOperationCallable;
    private final UnaryCallable<UpdateStreamRequest, Operation> updateStreamCallable;
    private final OperationCallable<UpdateStreamRequest, Stream, OperationMetadata> updateStreamOperationCallable;
    private final UnaryCallable<DeleteStreamRequest, Operation> deleteStreamCallable;
    private final OperationCallable<DeleteStreamRequest, Empty, OperationMetadata> deleteStreamOperationCallable;
    private final UnaryCallable<RunStreamRequest, Operation> runStreamCallable;
    private final OperationCallable<RunStreamRequest, Stream, OperationMetadata> runStreamOperationCallable;
    private final UnaryCallable<GetStreamObjectRequest, StreamObject> getStreamObjectCallable;
    private final UnaryCallable<LookupStreamObjectRequest, StreamObject> lookupStreamObjectCallable;
    private final UnaryCallable<ListStreamObjectsRequest, ListStreamObjectsResponse> listStreamObjectsCallable;
    private final UnaryCallable<ListStreamObjectsRequest, DatastreamClient.ListStreamObjectsPagedResponse> listStreamObjectsPagedCallable;
    private final UnaryCallable<StartBackfillJobRequest, StartBackfillJobResponse> startBackfillJobCallable;
    private final UnaryCallable<StopBackfillJobRequest, StopBackfillJobResponse> stopBackfillJobCallable;
    private final UnaryCallable<FetchStaticIpsRequest, FetchStaticIpsResponse> fetchStaticIpsCallable;
    private final UnaryCallable<FetchStaticIpsRequest, DatastreamClient.FetchStaticIpsPagedResponse> fetchStaticIpsPagedCallable;
    private final UnaryCallable<CreatePrivateConnectionRequest, Operation> createPrivateConnectionCallable;
    private final OperationCallable<CreatePrivateConnectionRequest, PrivateConnection, OperationMetadata> createPrivateConnectionOperationCallable;
    private final UnaryCallable<GetPrivateConnectionRequest, PrivateConnection> getPrivateConnectionCallable;
    private final UnaryCallable<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse> listPrivateConnectionsCallable;
    private final UnaryCallable<ListPrivateConnectionsRequest, DatastreamClient.ListPrivateConnectionsPagedResponse> listPrivateConnectionsPagedCallable;
    private final UnaryCallable<DeletePrivateConnectionRequest, Operation> deletePrivateConnectionCallable;
    private final OperationCallable<DeletePrivateConnectionRequest, Empty, OperationMetadata> deletePrivateConnectionOperationCallable;
    private final UnaryCallable<CreateRouteRequest, Operation> createRouteCallable;
    private final OperationCallable<CreateRouteRequest, Route, OperationMetadata> createRouteOperationCallable;
    private final UnaryCallable<GetRouteRequest, Route> getRouteCallable;
    private final UnaryCallable<ListRoutesRequest, ListRoutesResponse> listRoutesCallable;
    private final UnaryCallable<ListRoutesRequest, DatastreamClient.ListRoutesPagedResponse> listRoutesPagedCallable;
    private final UnaryCallable<DeleteRouteRequest, Operation> deleteRouteCallable;
    private final OperationCallable<DeleteRouteRequest, Empty, OperationMetadata> deleteRouteOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, DatastreamClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDatastreamStub create(DatastreamStubSettings settings) throws IOException {
        return new GrpcDatastreamStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDatastreamStub create(ClientContext clientContext) throws IOException {
        return new GrpcDatastreamStub(DatastreamStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDatastreamStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDatastreamStub(DatastreamStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDatastreamStub(DatastreamStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDatastreamCallableFactory());
    }

    protected GrpcDatastreamStub(DatastreamStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listConnectionProfilesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listConnectionProfilesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getConnectionProfileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConnectionProfileMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createConnectionProfileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createConnectionProfileMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateConnectionProfileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateConnectionProfileMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("connection_profile.name", String.valueOf(request.getConnectionProfile().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteConnectionProfileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteConnectionProfileMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings discoverConnectionProfileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(discoverConnectionProfileMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listStreamsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listStreamsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getStreamTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getStreamMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createStreamTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createStreamMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateStreamTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateStreamMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("stream.name", String.valueOf(request.getStream().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteStreamTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteStreamMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings runStreamTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(runStreamMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getStreamObjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getStreamObjectMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings lookupStreamObjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(lookupStreamObjectMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listStreamObjectsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listStreamObjectsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings startBackfillJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(startBackfillJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("object", String.valueOf(request.getObject()));
            return builder.build();
        }).build();
        GrpcCallSettings stopBackfillJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(stopBackfillJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("object", String.valueOf(request.getObject()));
            return builder.build();
        }).build();
        GrpcCallSettings fetchStaticIpsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(fetchStaticIpsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createPrivateConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createPrivateConnectionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getPrivateConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPrivateConnectionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listPrivateConnectionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPrivateConnectionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deletePrivateConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deletePrivateConnectionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createRouteTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createRouteMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getRouteTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getRouteMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listRoutesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRoutesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteRouteTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteRouteMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listConnectionProfilesCallable = callableFactory.createUnaryCallable(listConnectionProfilesTransportSettings, settings.listConnectionProfilesSettings(), clientContext);
        this.listConnectionProfilesPagedCallable = callableFactory.createPagedCallable(listConnectionProfilesTransportSettings, settings.listConnectionProfilesSettings(), clientContext);
        this.getConnectionProfileCallable = callableFactory.createUnaryCallable(getConnectionProfileTransportSettings, settings.getConnectionProfileSettings(), clientContext);
        this.createConnectionProfileCallable = callableFactory.createUnaryCallable(createConnectionProfileTransportSettings, settings.createConnectionProfileSettings(), clientContext);
        this.createConnectionProfileOperationCallable = callableFactory.createOperationCallable(createConnectionProfileTransportSettings, settings.createConnectionProfileOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateConnectionProfileCallable = callableFactory.createUnaryCallable(updateConnectionProfileTransportSettings, settings.updateConnectionProfileSettings(), clientContext);
        this.updateConnectionProfileOperationCallable = callableFactory.createOperationCallable(updateConnectionProfileTransportSettings, settings.updateConnectionProfileOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteConnectionProfileCallable = callableFactory.createUnaryCallable(deleteConnectionProfileTransportSettings, settings.deleteConnectionProfileSettings(), clientContext);
        this.deleteConnectionProfileOperationCallable = callableFactory.createOperationCallable(deleteConnectionProfileTransportSettings, settings.deleteConnectionProfileOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.discoverConnectionProfileCallable = callableFactory.createUnaryCallable(discoverConnectionProfileTransportSettings, settings.discoverConnectionProfileSettings(), clientContext);
        this.listStreamsCallable = callableFactory.createUnaryCallable(listStreamsTransportSettings, settings.listStreamsSettings(), clientContext);
        this.listStreamsPagedCallable = callableFactory.createPagedCallable(listStreamsTransportSettings, settings.listStreamsSettings(), clientContext);
        this.getStreamCallable = callableFactory.createUnaryCallable(getStreamTransportSettings, settings.getStreamSettings(), clientContext);
        this.createStreamCallable = callableFactory.createUnaryCallable(createStreamTransportSettings, settings.createStreamSettings(), clientContext);
        this.createStreamOperationCallable = callableFactory.createOperationCallable(createStreamTransportSettings, settings.createStreamOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateStreamCallable = callableFactory.createUnaryCallable(updateStreamTransportSettings, settings.updateStreamSettings(), clientContext);
        this.updateStreamOperationCallable = callableFactory.createOperationCallable(updateStreamTransportSettings, settings.updateStreamOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteStreamCallable = callableFactory.createUnaryCallable(deleteStreamTransportSettings, settings.deleteStreamSettings(), clientContext);
        this.deleteStreamOperationCallable = callableFactory.createOperationCallable(deleteStreamTransportSettings, settings.deleteStreamOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.runStreamCallable = callableFactory.createUnaryCallable(runStreamTransportSettings, settings.runStreamSettings(), clientContext);
        this.runStreamOperationCallable = callableFactory.createOperationCallable(runStreamTransportSettings, settings.runStreamOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getStreamObjectCallable = callableFactory.createUnaryCallable(getStreamObjectTransportSettings, settings.getStreamObjectSettings(), clientContext);
        this.lookupStreamObjectCallable = callableFactory.createUnaryCallable(lookupStreamObjectTransportSettings, settings.lookupStreamObjectSettings(), clientContext);
        this.listStreamObjectsCallable = callableFactory.createUnaryCallable(listStreamObjectsTransportSettings, settings.listStreamObjectsSettings(), clientContext);
        this.listStreamObjectsPagedCallable = callableFactory.createPagedCallable(listStreamObjectsTransportSettings, settings.listStreamObjectsSettings(), clientContext);
        this.startBackfillJobCallable = callableFactory.createUnaryCallable(startBackfillJobTransportSettings, settings.startBackfillJobSettings(), clientContext);
        this.stopBackfillJobCallable = callableFactory.createUnaryCallable(stopBackfillJobTransportSettings, settings.stopBackfillJobSettings(), clientContext);
        this.fetchStaticIpsCallable = callableFactory.createUnaryCallable(fetchStaticIpsTransportSettings, settings.fetchStaticIpsSettings(), clientContext);
        this.fetchStaticIpsPagedCallable = callableFactory.createPagedCallable(fetchStaticIpsTransportSettings, settings.fetchStaticIpsSettings(), clientContext);
        this.createPrivateConnectionCallable = callableFactory.createUnaryCallable(createPrivateConnectionTransportSettings, settings.createPrivateConnectionSettings(), clientContext);
        this.createPrivateConnectionOperationCallable = callableFactory.createOperationCallable(createPrivateConnectionTransportSettings, settings.createPrivateConnectionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getPrivateConnectionCallable = callableFactory.createUnaryCallable(getPrivateConnectionTransportSettings, settings.getPrivateConnectionSettings(), clientContext);
        this.listPrivateConnectionsCallable = callableFactory.createUnaryCallable(listPrivateConnectionsTransportSettings, settings.listPrivateConnectionsSettings(), clientContext);
        this.listPrivateConnectionsPagedCallable = callableFactory.createPagedCallable(listPrivateConnectionsTransportSettings, settings.listPrivateConnectionsSettings(), clientContext);
        this.deletePrivateConnectionCallable = callableFactory.createUnaryCallable(deletePrivateConnectionTransportSettings, settings.deletePrivateConnectionSettings(), clientContext);
        this.deletePrivateConnectionOperationCallable = callableFactory.createOperationCallable(deletePrivateConnectionTransportSettings, settings.deletePrivateConnectionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.createRouteCallable = callableFactory.createUnaryCallable(createRouteTransportSettings, settings.createRouteSettings(), clientContext);
        this.createRouteOperationCallable = callableFactory.createOperationCallable(createRouteTransportSettings, settings.createRouteOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getRouteCallable = callableFactory.createUnaryCallable(getRouteTransportSettings, settings.getRouteSettings(), clientContext);
        this.listRoutesCallable = callableFactory.createUnaryCallable(listRoutesTransportSettings, settings.listRoutesSettings(), clientContext);
        this.listRoutesPagedCallable = callableFactory.createPagedCallable(listRoutesTransportSettings, settings.listRoutesSettings(), clientContext);
        this.deleteRouteCallable = callableFactory.createUnaryCallable(deleteRouteTransportSettings, settings.deleteRouteSettings(), clientContext);
        this.deleteRouteOperationCallable = callableFactory.createOperationCallable(deleteRouteTransportSettings, settings.deleteRouteOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListConnectionProfilesRequest, ListConnectionProfilesResponse> listConnectionProfilesCallable() {
        return this.listConnectionProfilesCallable;
    }

    @Override
    public UnaryCallable<ListConnectionProfilesRequest, DatastreamClient.ListConnectionProfilesPagedResponse> listConnectionProfilesPagedCallable() {
        return this.listConnectionProfilesPagedCallable;
    }

    @Override
    public UnaryCallable<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileCallable() {
        return this.getConnectionProfileCallable;
    }

    @Override
    public UnaryCallable<CreateConnectionProfileRequest, Operation> createConnectionProfileCallable() {
        return this.createConnectionProfileCallable;
    }

    @Override
    public OperationCallable<CreateConnectionProfileRequest, ConnectionProfile, OperationMetadata> createConnectionProfileOperationCallable() {
        return this.createConnectionProfileOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateConnectionProfileRequest, Operation> updateConnectionProfileCallable() {
        return this.updateConnectionProfileCallable;
    }

    @Override
    public OperationCallable<UpdateConnectionProfileRequest, ConnectionProfile, OperationMetadata> updateConnectionProfileOperationCallable() {
        return this.updateConnectionProfileOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileCallable() {
        return this.deleteConnectionProfileCallable;
    }

    @Override
    public OperationCallable<DeleteConnectionProfileRequest, Empty, OperationMetadata> deleteConnectionProfileOperationCallable() {
        return this.deleteConnectionProfileOperationCallable;
    }

    @Override
    public UnaryCallable<DiscoverConnectionProfileRequest, DiscoverConnectionProfileResponse> discoverConnectionProfileCallable() {
        return this.discoverConnectionProfileCallable;
    }

    @Override
    public UnaryCallable<ListStreamsRequest, ListStreamsResponse> listStreamsCallable() {
        return this.listStreamsCallable;
    }

    @Override
    public UnaryCallable<ListStreamsRequest, DatastreamClient.ListStreamsPagedResponse> listStreamsPagedCallable() {
        return this.listStreamsPagedCallable;
    }

    @Override
    public UnaryCallable<GetStreamRequest, Stream> getStreamCallable() {
        return this.getStreamCallable;
    }

    @Override
    public UnaryCallable<CreateStreamRequest, Operation> createStreamCallable() {
        return this.createStreamCallable;
    }

    @Override
    public OperationCallable<CreateStreamRequest, Stream, OperationMetadata> createStreamOperationCallable() {
        return this.createStreamOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateStreamRequest, Operation> updateStreamCallable() {
        return this.updateStreamCallable;
    }

    @Override
    public OperationCallable<UpdateStreamRequest, Stream, OperationMetadata> updateStreamOperationCallable() {
        return this.updateStreamOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteStreamRequest, Operation> deleteStreamCallable() {
        return this.deleteStreamCallable;
    }

    @Override
    public OperationCallable<DeleteStreamRequest, Empty, OperationMetadata> deleteStreamOperationCallable() {
        return this.deleteStreamOperationCallable;
    }

    @Override
    public UnaryCallable<RunStreamRequest, Operation> runStreamCallable() {
        return this.runStreamCallable;
    }

    @Override
    public OperationCallable<RunStreamRequest, Stream, OperationMetadata> runStreamOperationCallable() {
        return this.runStreamOperationCallable;
    }

    @Override
    public UnaryCallable<GetStreamObjectRequest, StreamObject> getStreamObjectCallable() {
        return this.getStreamObjectCallable;
    }

    @Override
    public UnaryCallable<LookupStreamObjectRequest, StreamObject> lookupStreamObjectCallable() {
        return this.lookupStreamObjectCallable;
    }

    @Override
    public UnaryCallable<ListStreamObjectsRequest, ListStreamObjectsResponse> listStreamObjectsCallable() {
        return this.listStreamObjectsCallable;
    }

    @Override
    public UnaryCallable<ListStreamObjectsRequest, DatastreamClient.ListStreamObjectsPagedResponse> listStreamObjectsPagedCallable() {
        return this.listStreamObjectsPagedCallable;
    }

    @Override
    public UnaryCallable<StartBackfillJobRequest, StartBackfillJobResponse> startBackfillJobCallable() {
        return this.startBackfillJobCallable;
    }

    @Override
    public UnaryCallable<StopBackfillJobRequest, StopBackfillJobResponse> stopBackfillJobCallable() {
        return this.stopBackfillJobCallable;
    }

    @Override
    public UnaryCallable<FetchStaticIpsRequest, FetchStaticIpsResponse> fetchStaticIpsCallable() {
        return this.fetchStaticIpsCallable;
    }

    @Override
    public UnaryCallable<FetchStaticIpsRequest, DatastreamClient.FetchStaticIpsPagedResponse> fetchStaticIpsPagedCallable() {
        return this.fetchStaticIpsPagedCallable;
    }

    @Override
    public UnaryCallable<CreatePrivateConnectionRequest, Operation> createPrivateConnectionCallable() {
        return this.createPrivateConnectionCallable;
    }

    @Override
    public OperationCallable<CreatePrivateConnectionRequest, PrivateConnection, OperationMetadata> createPrivateConnectionOperationCallable() {
        return this.createPrivateConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<GetPrivateConnectionRequest, PrivateConnection> getPrivateConnectionCallable() {
        return this.getPrivateConnectionCallable;
    }

    @Override
    public UnaryCallable<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse> listPrivateConnectionsCallable() {
        return this.listPrivateConnectionsCallable;
    }

    @Override
    public UnaryCallable<ListPrivateConnectionsRequest, DatastreamClient.ListPrivateConnectionsPagedResponse> listPrivateConnectionsPagedCallable() {
        return this.listPrivateConnectionsPagedCallable;
    }

    @Override
    public UnaryCallable<DeletePrivateConnectionRequest, Operation> deletePrivateConnectionCallable() {
        return this.deletePrivateConnectionCallable;
    }

    @Override
    public OperationCallable<DeletePrivateConnectionRequest, Empty, OperationMetadata> deletePrivateConnectionOperationCallable() {
        return this.deletePrivateConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<CreateRouteRequest, Operation> createRouteCallable() {
        return this.createRouteCallable;
    }

    @Override
    public OperationCallable<CreateRouteRequest, Route, OperationMetadata> createRouteOperationCallable() {
        return this.createRouteOperationCallable;
    }

    @Override
    public UnaryCallable<GetRouteRequest, Route> getRouteCallable() {
        return this.getRouteCallable;
    }

    @Override
    public UnaryCallable<ListRoutesRequest, ListRoutesResponse> listRoutesCallable() {
        return this.listRoutesCallable;
    }

    @Override
    public UnaryCallable<ListRoutesRequest, DatastreamClient.ListRoutesPagedResponse> listRoutesPagedCallable() {
        return this.listRoutesPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteRouteRequest, Operation> deleteRouteCallable() {
        return this.deleteRouteCallable;
    }

    @Override
    public OperationCallable<DeleteRouteRequest, Empty, OperationMetadata> deleteRouteOperationCallable() {
        return this.deleteRouteOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, DatastreamClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

