/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.debugger.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.debugger.v2.stub.Debugger2Stub;
import com.google.cloud.debugger.v2.stub.Debugger2StubSettings;
import com.google.cloud.debugger.v2.stub.HttpJsonDebugger2CallableFactory;
import com.google.devtools.clouddebugger.v2.DeleteBreakpointRequest;
import com.google.devtools.clouddebugger.v2.GetBreakpointRequest;
import com.google.devtools.clouddebugger.v2.GetBreakpointResponse;
import com.google.devtools.clouddebugger.v2.ListBreakpointsRequest;
import com.google.devtools.clouddebugger.v2.ListBreakpointsResponse;
import com.google.devtools.clouddebugger.v2.ListDebuggeesRequest;
import com.google.devtools.clouddebugger.v2.ListDebuggeesResponse;
import com.google.devtools.clouddebugger.v2.SetBreakpointRequest;
import com.google.devtools.clouddebugger.v2.SetBreakpointResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonDebugger2Stub
extends Debugger2Stub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<SetBreakpointRequest, SetBreakpointResponse> setBreakpointMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.clouddebugger.v2.Debugger2/SetBreakpoint").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/debugger/debuggees/{debuggeeId}/breakpoints/set", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "debuggeeId", (Object)request.getDebuggeeId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "clientVersion", (Object)request.getClientVersion());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("breakpoint", (Message)request.getBreakpoint(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SetBreakpointResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetBreakpointRequest, GetBreakpointResponse> getBreakpointMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.clouddebugger.v2.Debugger2/GetBreakpoint").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/debugger/debuggees/{debuggeeId}/breakpoints/{breakpointId}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "breakpointId", (Object)request.getBreakpointId());
        serializer.putPathParam(fields, "debuggeeId", (Object)request.getDebuggeeId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "clientVersion", (Object)request.getClientVersion());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GetBreakpointResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteBreakpointRequest, Empty> deleteBreakpointMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.clouddebugger.v2.Debugger2/DeleteBreakpoint").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/debugger/debuggees/{debuggeeId}/breakpoints/{breakpointId}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "breakpointId", (Object)request.getBreakpointId());
        serializer.putPathParam(fields, "debuggeeId", (Object)request.getDebuggeeId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "clientVersion", (Object)request.getClientVersion());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListBreakpointsRequest, ListBreakpointsResponse> listBreakpointsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.clouddebugger.v2.Debugger2/ListBreakpoints").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/debugger/debuggees/{debuggeeId}/breakpoints", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "debuggeeId", (Object)request.getDebuggeeId());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "action", (Object)request.getAction());
        serializer.putQueryParam(fields, "clientVersion", (Object)request.getClientVersion());
        serializer.putQueryParam(fields, "includeAllUsers", (Object)request.getIncludeAllUsers());
        serializer.putQueryParam(fields, "includeInactive", (Object)request.getIncludeInactive());
        serializer.putQueryParam(fields, "stripResults", (Object)request.getStripResults());
        serializer.putQueryParam(fields, "waitToken", (Object)request.getWaitToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListBreakpointsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListDebuggeesRequest, ListDebuggeesResponse> listDebuggeesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.clouddebugger.v2.Debugger2/ListDebuggees").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/debugger/debuggees", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "clientVersion", (Object)request.getClientVersion());
        serializer.putQueryParam(fields, "includeInactive", (Object)request.getIncludeInactive());
        serializer.putQueryParam(fields, "project", (Object)request.getProject());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListDebuggeesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<SetBreakpointRequest, SetBreakpointResponse> setBreakpointCallable;
    private final UnaryCallable<GetBreakpointRequest, GetBreakpointResponse> getBreakpointCallable;
    private final UnaryCallable<DeleteBreakpointRequest, Empty> deleteBreakpointCallable;
    private final UnaryCallable<ListBreakpointsRequest, ListBreakpointsResponse> listBreakpointsCallable;
    private final UnaryCallable<ListDebuggeesRequest, ListDebuggeesResponse> listDebuggeesCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDebugger2Stub create(Debugger2StubSettings settings) throws IOException {
        return new HttpJsonDebugger2Stub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDebugger2Stub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDebugger2Stub(Debugger2StubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDebugger2Stub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDebugger2Stub(Debugger2StubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDebugger2Stub(Debugger2StubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDebugger2CallableFactory());
    }

    protected HttpJsonDebugger2Stub(Debugger2StubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings setBreakpointTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setBreakpointMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getBreakpointTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getBreakpointMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteBreakpointTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteBreakpointMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listBreakpointsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listBreakpointsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listDebuggeesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listDebuggeesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.setBreakpointCallable = callableFactory.createUnaryCallable(setBreakpointTransportSettings, settings.setBreakpointSettings(), clientContext);
        this.getBreakpointCallable = callableFactory.createUnaryCallable(getBreakpointTransportSettings, settings.getBreakpointSettings(), clientContext);
        this.deleteBreakpointCallable = callableFactory.createUnaryCallable(deleteBreakpointTransportSettings, settings.deleteBreakpointSettings(), clientContext);
        this.listBreakpointsCallable = callableFactory.createUnaryCallable(listBreakpointsTransportSettings, settings.listBreakpointsSettings(), clientContext);
        this.listDebuggeesCallable = callableFactory.createUnaryCallable(listDebuggeesTransportSettings, settings.listDebuggeesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(setBreakpointMethodDescriptor);
        methodDescriptors.add(getBreakpointMethodDescriptor);
        methodDescriptors.add(deleteBreakpointMethodDescriptor);
        methodDescriptors.add(listBreakpointsMethodDescriptor);
        methodDescriptors.add(listDebuggeesMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<SetBreakpointRequest, SetBreakpointResponse> setBreakpointCallable() {
        return this.setBreakpointCallable;
    }

    @Override
    public UnaryCallable<GetBreakpointRequest, GetBreakpointResponse> getBreakpointCallable() {
        return this.getBreakpointCallable;
    }

    @Override
    public UnaryCallable<DeleteBreakpointRequest, Empty> deleteBreakpointCallable() {
        return this.deleteBreakpointCallable;
    }

    @Override
    public UnaryCallable<ListBreakpointsRequest, ListBreakpointsResponse> listBreakpointsCallable() {
        return this.listBreakpointsCallable;
    }

    @Override
    public UnaryCallable<ListDebuggeesRequest, ListDebuggeesResponse> listDebuggeesCallable() {
        return this.listDebuggeesCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

