/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.debugger.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.debugger.v2.stub.Controller2Stub;
import com.google.cloud.debugger.v2.stub.Controller2StubSettings;
import com.google.cloud.debugger.v2.stub.GrpcController2CallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.clouddebugger.v2.ListActiveBreakpointsRequest;
import com.google.devtools.clouddebugger.v2.ListActiveBreakpointsResponse;
import com.google.devtools.clouddebugger.v2.RegisterDebuggeeRequest;
import com.google.devtools.clouddebugger.v2.RegisterDebuggeeResponse;
import com.google.devtools.clouddebugger.v2.UpdateActiveBreakpointRequest;
import com.google.devtools.clouddebugger.v2.UpdateActiveBreakpointResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcController2Stub
extends Controller2Stub {
    private static final MethodDescriptor<RegisterDebuggeeRequest, RegisterDebuggeeResponse> registerDebuggeeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.clouddebugger.v2.Controller2/RegisterDebuggee").setRequestMarshaller(ProtoUtils.marshaller((Message)RegisterDebuggeeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RegisterDebuggeeResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListActiveBreakpointsRequest, ListActiveBreakpointsResponse> listActiveBreakpointsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.clouddebugger.v2.Controller2/ListActiveBreakpoints").setRequestMarshaller(ProtoUtils.marshaller((Message)ListActiveBreakpointsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListActiveBreakpointsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateActiveBreakpointRequest, UpdateActiveBreakpointResponse> updateActiveBreakpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.clouddebugger.v2.Controller2/UpdateActiveBreakpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateActiveBreakpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)UpdateActiveBreakpointResponse.getDefaultInstance())).build();
    private final UnaryCallable<RegisterDebuggeeRequest, RegisterDebuggeeResponse> registerDebuggeeCallable;
    private final UnaryCallable<ListActiveBreakpointsRequest, ListActiveBreakpointsResponse> listActiveBreakpointsCallable;
    private final UnaryCallable<UpdateActiveBreakpointRequest, UpdateActiveBreakpointResponse> updateActiveBreakpointCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcController2Stub create(Controller2StubSettings settings) throws IOException {
        return new GrpcController2Stub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcController2Stub create(ClientContext clientContext) throws IOException {
        return new GrpcController2Stub(Controller2StubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcController2Stub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcController2Stub(Controller2StubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcController2Stub(Controller2StubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcController2CallableFactory());
    }

    protected GrpcController2Stub(Controller2StubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings registerDebuggeeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(registerDebuggeeMethodDescriptor).build();
        GrpcCallSettings listActiveBreakpointsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listActiveBreakpointsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"debuggee_id", (Object)String.valueOf(request.getDebuggeeId()));
            return params.build();
        }).build();
        GrpcCallSettings updateActiveBreakpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateActiveBreakpointMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"breakpoint.id", (Object)String.valueOf(request.getBreakpoint().getId()));
            params.put((Object)"debuggee_id", (Object)String.valueOf(request.getDebuggeeId()));
            return params.build();
        }).build();
        this.registerDebuggeeCallable = callableFactory.createUnaryCallable(registerDebuggeeTransportSettings, settings.registerDebuggeeSettings(), clientContext);
        this.listActiveBreakpointsCallable = callableFactory.createUnaryCallable(listActiveBreakpointsTransportSettings, settings.listActiveBreakpointsSettings(), clientContext);
        this.updateActiveBreakpointCallable = callableFactory.createUnaryCallable(updateActiveBreakpointTransportSettings, settings.updateActiveBreakpointSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<RegisterDebuggeeRequest, RegisterDebuggeeResponse> registerDebuggeeCallable() {
        return this.registerDebuggeeCallable;
    }

    @Override
    public UnaryCallable<ListActiveBreakpointsRequest, ListActiveBreakpointsResponse> listActiveBreakpointsCallable() {
        return this.listActiveBreakpointsCallable;
    }

    @Override
    public UnaryCallable<UpdateActiveBreakpointRequest, UpdateActiveBreakpointResponse> updateActiveBreakpointCallable() {
        return this.updateActiveBreakpointCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

