/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.debugger.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.debugger.v2.stub.Debugger2Stub;
import com.google.cloud.debugger.v2.stub.Debugger2StubSettings;
import com.google.cloud.debugger.v2.stub.GrpcDebugger2CallableFactory;
import com.google.devtools.clouddebugger.v2.DeleteBreakpointRequest;
import com.google.devtools.clouddebugger.v2.GetBreakpointRequest;
import com.google.devtools.clouddebugger.v2.GetBreakpointResponse;
import com.google.devtools.clouddebugger.v2.ListBreakpointsRequest;
import com.google.devtools.clouddebugger.v2.ListBreakpointsResponse;
import com.google.devtools.clouddebugger.v2.ListDebuggeesRequest;
import com.google.devtools.clouddebugger.v2.ListDebuggeesResponse;
import com.google.devtools.clouddebugger.v2.SetBreakpointRequest;
import com.google.devtools.clouddebugger.v2.SetBreakpointResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcDebugger2Stub
extends Debugger2Stub {
    private static final MethodDescriptor<SetBreakpointRequest, SetBreakpointResponse> setBreakpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.clouddebugger.v2.Debugger2/SetBreakpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)SetBreakpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SetBreakpointResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetBreakpointRequest, GetBreakpointResponse> getBreakpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.clouddebugger.v2.Debugger2/GetBreakpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)GetBreakpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GetBreakpointResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteBreakpointRequest, Empty> deleteBreakpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.clouddebugger.v2.Debugger2/DeleteBreakpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteBreakpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListBreakpointsRequest, ListBreakpointsResponse> listBreakpointsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.clouddebugger.v2.Debugger2/ListBreakpoints").setRequestMarshaller(ProtoUtils.marshaller((Message)ListBreakpointsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListBreakpointsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListDebuggeesRequest, ListDebuggeesResponse> listDebuggeesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.clouddebugger.v2.Debugger2/ListDebuggees").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDebuggeesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDebuggeesResponse.getDefaultInstance())).build();
    private final UnaryCallable<SetBreakpointRequest, SetBreakpointResponse> setBreakpointCallable;
    private final UnaryCallable<GetBreakpointRequest, GetBreakpointResponse> getBreakpointCallable;
    private final UnaryCallable<DeleteBreakpointRequest, Empty> deleteBreakpointCallable;
    private final UnaryCallable<ListBreakpointsRequest, ListBreakpointsResponse> listBreakpointsCallable;
    private final UnaryCallable<ListDebuggeesRequest, ListDebuggeesResponse> listDebuggeesCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDebugger2Stub create(Debugger2StubSettings settings) throws IOException {
        return new GrpcDebugger2Stub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDebugger2Stub create(ClientContext clientContext) throws IOException {
        return new GrpcDebugger2Stub(Debugger2StubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDebugger2Stub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDebugger2Stub(Debugger2StubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDebugger2Stub(Debugger2StubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDebugger2CallableFactory());
    }

    protected GrpcDebugger2Stub(Debugger2StubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings setBreakpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setBreakpointMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("debuggee_id", String.valueOf(request.getDebuggeeId()));
            return builder.build();
        }).build();
        GrpcCallSettings getBreakpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getBreakpointMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("breakpoint_id", String.valueOf(request.getBreakpointId()));
            builder.add("debuggee_id", String.valueOf(request.getDebuggeeId()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteBreakpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteBreakpointMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("breakpoint_id", String.valueOf(request.getBreakpointId()));
            builder.add("debuggee_id", String.valueOf(request.getDebuggeeId()));
            return builder.build();
        }).build();
        GrpcCallSettings listBreakpointsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listBreakpointsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("debuggee_id", String.valueOf(request.getDebuggeeId()));
            return builder.build();
        }).build();
        GrpcCallSettings listDebuggeesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDebuggeesMethodDescriptor).build();
        this.setBreakpointCallable = callableFactory.createUnaryCallable(setBreakpointTransportSettings, settings.setBreakpointSettings(), clientContext);
        this.getBreakpointCallable = callableFactory.createUnaryCallable(getBreakpointTransportSettings, settings.getBreakpointSettings(), clientContext);
        this.deleteBreakpointCallable = callableFactory.createUnaryCallable(deleteBreakpointTransportSettings, settings.deleteBreakpointSettings(), clientContext);
        this.listBreakpointsCallable = callableFactory.createUnaryCallable(listBreakpointsTransportSettings, settings.listBreakpointsSettings(), clientContext);
        this.listDebuggeesCallable = callableFactory.createUnaryCallable(listDebuggeesTransportSettings, settings.listDebuggeesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<SetBreakpointRequest, SetBreakpointResponse> setBreakpointCallable() {
        return this.setBreakpointCallable;
    }

    @Override
    public UnaryCallable<GetBreakpointRequest, GetBreakpointResponse> getBreakpointCallable() {
        return this.getBreakpointCallable;
    }

    @Override
    public UnaryCallable<DeleteBreakpointRequest, Empty> deleteBreakpointCallable() {
        return this.deleteBreakpointCallable;
    }

    @Override
    public UnaryCallable<ListBreakpointsRequest, ListBreakpointsResponse> listBreakpointsCallable() {
        return this.listBreakpointsCallable;
    }

    @Override
    public UnaryCallable<ListDebuggeesRequest, ListDebuggeesResponse> listDebuggeesCallable() {
        return this.listDebuggeesCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

