/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.debugger.v2;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.debugger.v2.Debugger2Settings;
import com.google.cloud.debugger.v2.stub.Debugger2Stub;
import com.google.cloud.debugger.v2.stub.Debugger2StubSettings;
import com.google.devtools.clouddebugger.v2.Breakpoint;
import com.google.devtools.clouddebugger.v2.DeleteBreakpointRequest;
import com.google.devtools.clouddebugger.v2.GetBreakpointRequest;
import com.google.devtools.clouddebugger.v2.GetBreakpointResponse;
import com.google.devtools.clouddebugger.v2.ListBreakpointsRequest;
import com.google.devtools.clouddebugger.v2.ListBreakpointsResponse;
import com.google.devtools.clouddebugger.v2.ListDebuggeesRequest;
import com.google.devtools.clouddebugger.v2.ListDebuggeesResponse;
import com.google.devtools.clouddebugger.v2.SetBreakpointRequest;
import com.google.devtools.clouddebugger.v2.SetBreakpointResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class Debugger2Client
implements BackgroundResource {
    private final Debugger2Settings settings;
    private final Debugger2Stub stub;

    public static final Debugger2Client create() throws IOException {
        return Debugger2Client.create(Debugger2Settings.newBuilder().build());
    }

    public static final Debugger2Client create(Debugger2Settings settings) throws IOException {
        return new Debugger2Client(settings);
    }

    public static final Debugger2Client create(Debugger2Stub stub) {
        return new Debugger2Client(stub);
    }

    protected Debugger2Client(Debugger2Settings settings) throws IOException {
        this.settings = settings;
        this.stub = ((Debugger2StubSettings)settings.getStubSettings()).createStub();
    }

    protected Debugger2Client(Debugger2Stub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final Debugger2Settings getSettings() {
        return this.settings;
    }

    public Debugger2Stub getStub() {
        return this.stub;
    }

    public final SetBreakpointResponse setBreakpoint(String debuggeeId, Breakpoint breakpoint, String clientVersion) {
        SetBreakpointRequest request = SetBreakpointRequest.newBuilder().setDebuggeeId(debuggeeId).setBreakpoint(breakpoint).setClientVersion(clientVersion).build();
        return this.setBreakpoint(request);
    }

    public final SetBreakpointResponse setBreakpoint(SetBreakpointRequest request) {
        return (SetBreakpointResponse)this.setBreakpointCallable().call((Object)request);
    }

    public final UnaryCallable<SetBreakpointRequest, SetBreakpointResponse> setBreakpointCallable() {
        return this.stub.setBreakpointCallable();
    }

    public final GetBreakpointResponse getBreakpoint(String debuggeeId, String breakpointId, String clientVersion) {
        GetBreakpointRequest request = GetBreakpointRequest.newBuilder().setDebuggeeId(debuggeeId).setBreakpointId(breakpointId).setClientVersion(clientVersion).build();
        return this.getBreakpoint(request);
    }

    public final GetBreakpointResponse getBreakpoint(GetBreakpointRequest request) {
        return (GetBreakpointResponse)this.getBreakpointCallable().call((Object)request);
    }

    public final UnaryCallable<GetBreakpointRequest, GetBreakpointResponse> getBreakpointCallable() {
        return this.stub.getBreakpointCallable();
    }

    public final void deleteBreakpoint(String debuggeeId, String breakpointId, String clientVersion) {
        DeleteBreakpointRequest request = DeleteBreakpointRequest.newBuilder().setDebuggeeId(debuggeeId).setBreakpointId(breakpointId).setClientVersion(clientVersion).build();
        this.deleteBreakpoint(request);
    }

    public final void deleteBreakpoint(DeleteBreakpointRequest request) {
        this.deleteBreakpointCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteBreakpointRequest, Empty> deleteBreakpointCallable() {
        return this.stub.deleteBreakpointCallable();
    }

    public final ListBreakpointsResponse listBreakpoints(String debuggeeId, String clientVersion) {
        ListBreakpointsRequest request = ListBreakpointsRequest.newBuilder().setDebuggeeId(debuggeeId).setClientVersion(clientVersion).build();
        return this.listBreakpoints(request);
    }

    public final ListBreakpointsResponse listBreakpoints(ListBreakpointsRequest request) {
        return (ListBreakpointsResponse)this.listBreakpointsCallable().call((Object)request);
    }

    public final UnaryCallable<ListBreakpointsRequest, ListBreakpointsResponse> listBreakpointsCallable() {
        return this.stub.listBreakpointsCallable();
    }

    public final ListDebuggeesResponse listDebuggees(String project, String clientVersion) {
        ListDebuggeesRequest request = ListDebuggeesRequest.newBuilder().setProject(project).setClientVersion(clientVersion).build();
        return this.listDebuggees(request);
    }

    public final ListDebuggeesResponse listDebuggees(ListDebuggeesRequest request) {
        return (ListDebuggeesResponse)this.listDebuggeesCallable().call((Object)request);
    }

    public final UnaryCallable<ListDebuggeesRequest, ListDebuggeesResponse> listDebuggeesCallable() {
        return this.stub.listDebuggeesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

