/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.CreateDocumentRequest;
import com.google.cloud.dialogflow.v2.DeleteDocumentRequest;
import com.google.cloud.dialogflow.v2.Document;
import com.google.cloud.dialogflow.v2.DocumentsClient;
import com.google.cloud.dialogflow.v2.ExportDocumentRequest;
import com.google.cloud.dialogflow.v2.GetDocumentRequest;
import com.google.cloud.dialogflow.v2.KnowledgeOperationMetadata;
import com.google.cloud.dialogflow.v2.ListDocumentsRequest;
import com.google.cloud.dialogflow.v2.ListDocumentsResponse;
import com.google.cloud.dialogflow.v2.ReloadDocumentRequest;
import com.google.cloud.dialogflow.v2.UpdateDocumentRequest;
import com.google.cloud.dialogflow.v2.stub.DocumentsStub;
import com.google.cloud.dialogflow.v2.stub.DocumentsStubSettings;
import com.google.cloud.dialogflow.v2.stub.GrpcDocumentsCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcDocumentsStub
extends DocumentsStub {
    private static final MethodDescriptor<ListDocumentsRequest, ListDocumentsResponse> listDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Documents/ListDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDocumentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetDocumentRequest, Document> getDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Documents/GetDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Document.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateDocumentRequest, Operation> createDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Documents/CreateDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteDocumentRequest, Operation> deleteDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Documents/DeleteDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateDocumentRequest, Operation> updateDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Documents/UpdateDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ReloadDocumentRequest, Operation> reloadDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Documents/ReloadDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)ReloadDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ExportDocumentRequest, Operation> exportDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Documents/ExportDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable;
    private final UnaryCallable<ListDocumentsRequest, DocumentsClient.ListDocumentsPagedResponse> listDocumentsPagedCallable;
    private final UnaryCallable<GetDocumentRequest, Document> getDocumentCallable;
    private final UnaryCallable<CreateDocumentRequest, Operation> createDocumentCallable;
    private final OperationCallable<CreateDocumentRequest, Document, KnowledgeOperationMetadata> createDocumentOperationCallable;
    private final UnaryCallable<DeleteDocumentRequest, Operation> deleteDocumentCallable;
    private final OperationCallable<DeleteDocumentRequest, Empty, KnowledgeOperationMetadata> deleteDocumentOperationCallable;
    private final UnaryCallable<UpdateDocumentRequest, Operation> updateDocumentCallable;
    private final OperationCallable<UpdateDocumentRequest, Document, KnowledgeOperationMetadata> updateDocumentOperationCallable;
    private final UnaryCallable<ReloadDocumentRequest, Operation> reloadDocumentCallable;
    private final OperationCallable<ReloadDocumentRequest, Document, KnowledgeOperationMetadata> reloadDocumentOperationCallable;
    private final UnaryCallable<ExportDocumentRequest, Operation> exportDocumentCallable;
    private final OperationCallable<ExportDocumentRequest, Document, KnowledgeOperationMetadata> exportDocumentOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDocumentsStub create(DocumentsStubSettings settings) throws IOException {
        return new GrpcDocumentsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDocumentsStub create(ClientContext clientContext) throws IOException {
        return new GrpcDocumentsStub(DocumentsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDocumentsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDocumentsStub(DocumentsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDocumentsStub(DocumentsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDocumentsCallableFactory());
    }

    protected GrpcDocumentsStub(DocumentsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDocumentsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings deleteDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"document.name", (Object)String.valueOf(request.getDocument().getName()));
            return params.build();
        }).build();
        GrpcCallSettings reloadDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(reloadDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings exportDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportDocumentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        this.listDocumentsCallable = callableFactory.createUnaryCallable(listDocumentsTransportSettings, settings.listDocumentsSettings(), clientContext);
        this.listDocumentsPagedCallable = callableFactory.createPagedCallable(listDocumentsTransportSettings, settings.listDocumentsSettings(), clientContext);
        this.getDocumentCallable = callableFactory.createUnaryCallable(getDocumentTransportSettings, settings.getDocumentSettings(), clientContext);
        this.createDocumentCallable = callableFactory.createUnaryCallable(createDocumentTransportSettings, settings.createDocumentSettings(), clientContext);
        this.createDocumentOperationCallable = callableFactory.createOperationCallable(createDocumentTransportSettings, settings.createDocumentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteDocumentCallable = callableFactory.createUnaryCallable(deleteDocumentTransportSettings, settings.deleteDocumentSettings(), clientContext);
        this.deleteDocumentOperationCallable = callableFactory.createOperationCallable(deleteDocumentTransportSettings, settings.deleteDocumentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateDocumentCallable = callableFactory.createUnaryCallable(updateDocumentTransportSettings, settings.updateDocumentSettings(), clientContext);
        this.updateDocumentOperationCallable = callableFactory.createOperationCallable(updateDocumentTransportSettings, settings.updateDocumentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.reloadDocumentCallable = callableFactory.createUnaryCallable(reloadDocumentTransportSettings, settings.reloadDocumentSettings(), clientContext);
        this.reloadDocumentOperationCallable = callableFactory.createOperationCallable(reloadDocumentTransportSettings, settings.reloadDocumentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.exportDocumentCallable = callableFactory.createUnaryCallable(exportDocumentTransportSettings, settings.exportDocumentSettings(), clientContext);
        this.exportDocumentOperationCallable = callableFactory.createOperationCallable(exportDocumentTransportSettings, settings.exportDocumentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable() {
        return this.listDocumentsCallable;
    }

    @Override
    public UnaryCallable<ListDocumentsRequest, DocumentsClient.ListDocumentsPagedResponse> listDocumentsPagedCallable() {
        return this.listDocumentsPagedCallable;
    }

    @Override
    public UnaryCallable<GetDocumentRequest, Document> getDocumentCallable() {
        return this.getDocumentCallable;
    }

    @Override
    public UnaryCallable<CreateDocumentRequest, Operation> createDocumentCallable() {
        return this.createDocumentCallable;
    }

    @Override
    public OperationCallable<CreateDocumentRequest, Document, KnowledgeOperationMetadata> createDocumentOperationCallable() {
        return this.createDocumentOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteDocumentRequest, Operation> deleteDocumentCallable() {
        return this.deleteDocumentCallable;
    }

    @Override
    public OperationCallable<DeleteDocumentRequest, Empty, KnowledgeOperationMetadata> deleteDocumentOperationCallable() {
        return this.deleteDocumentOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateDocumentRequest, Operation> updateDocumentCallable() {
        return this.updateDocumentCallable;
    }

    @Override
    public OperationCallable<UpdateDocumentRequest, Document, KnowledgeOperationMetadata> updateDocumentOperationCallable() {
        return this.updateDocumentOperationCallable;
    }

    @Override
    public UnaryCallable<ReloadDocumentRequest, Operation> reloadDocumentCallable() {
        return this.reloadDocumentCallable;
    }

    @Override
    public OperationCallable<ReloadDocumentRequest, Document, KnowledgeOperationMetadata> reloadDocumentOperationCallable() {
        return this.reloadDocumentOperationCallable;
    }

    @Override
    public UnaryCallable<ExportDocumentRequest, Operation> exportDocumentCallable() {
        return this.exportDocumentCallable;
    }

    @Override
    public OperationCallable<ExportDocumentRequest, Document, KnowledgeOperationMetadata> exportDocumentOperationCallable() {
        return this.exportDocumentOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

