/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.AnswerRecord;
import com.google.cloud.dialogflow.v2.AnswerRecordsSettings;
import com.google.cloud.dialogflow.v2.ListAnswerRecordsRequest;
import com.google.cloud.dialogflow.v2.ListAnswerRecordsResponse;
import com.google.cloud.dialogflow.v2.LocationName;
import com.google.cloud.dialogflow.v2.ProjectName;
import com.google.cloud.dialogflow.v2.UpdateAnswerRecordRequest;
import com.google.cloud.dialogflow.v2.stub.AnswerRecordsStub;
import com.google.cloud.dialogflow.v2.stub.AnswerRecordsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AnswerRecordsClient
implements BackgroundResource {
    private final AnswerRecordsSettings settings;
    private final AnswerRecordsStub stub;

    public static final AnswerRecordsClient create() throws IOException {
        return AnswerRecordsClient.create(AnswerRecordsSettings.newBuilder().build());
    }

    public static final AnswerRecordsClient create(AnswerRecordsSettings settings) throws IOException {
        return new AnswerRecordsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AnswerRecordsClient create(AnswerRecordsStub stub) {
        return new AnswerRecordsClient(stub);
    }

    protected AnswerRecordsClient(AnswerRecordsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AnswerRecordsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AnswerRecordsClient(AnswerRecordsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AnswerRecordsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AnswerRecordsStub getStub() {
        return this.stub;
    }

    public final ListAnswerRecordsPagedResponse listAnswerRecords(LocationName parent) {
        ListAnswerRecordsRequest request = ListAnswerRecordsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAnswerRecords(request);
    }

    public final ListAnswerRecordsPagedResponse listAnswerRecords(ProjectName parent) {
        ListAnswerRecordsRequest request = ListAnswerRecordsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAnswerRecords(request);
    }

    public final ListAnswerRecordsPagedResponse listAnswerRecords(String parent) {
        ListAnswerRecordsRequest request = ListAnswerRecordsRequest.newBuilder().setParent(parent).build();
        return this.listAnswerRecords(request);
    }

    public final ListAnswerRecordsPagedResponse listAnswerRecords(ListAnswerRecordsRequest request) {
        return (ListAnswerRecordsPagedResponse)((Object)this.listAnswerRecordsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAnswerRecordsRequest, ListAnswerRecordsPagedResponse> listAnswerRecordsPagedCallable() {
        return this.stub.listAnswerRecordsPagedCallable();
    }

    public final UnaryCallable<ListAnswerRecordsRequest, ListAnswerRecordsResponse> listAnswerRecordsCallable() {
        return this.stub.listAnswerRecordsCallable();
    }

    public final AnswerRecord updateAnswerRecord(AnswerRecord answerRecord, FieldMask updateMask) {
        UpdateAnswerRecordRequest request = UpdateAnswerRecordRequest.newBuilder().setAnswerRecord(answerRecord).setUpdateMask(updateMask).build();
        return this.updateAnswerRecord(request);
    }

    public final AnswerRecord updateAnswerRecord(UpdateAnswerRecordRequest request) {
        return (AnswerRecord)this.updateAnswerRecordCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAnswerRecordRequest, AnswerRecord> updateAnswerRecordCallable() {
        return this.stub.updateAnswerRecordCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAnswerRecordsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAnswerRecordsRequest, ListAnswerRecordsResponse, AnswerRecord, ListAnswerRecordsPage, ListAnswerRecordsFixedSizeCollection> {
        private ListAnswerRecordsFixedSizeCollection(List<ListAnswerRecordsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAnswerRecordsFixedSizeCollection createEmptyCollection() {
            return new ListAnswerRecordsFixedSizeCollection(null, 0);
        }

        protected ListAnswerRecordsFixedSizeCollection createCollection(List<ListAnswerRecordsPage> pages, int collectionSize) {
            return new ListAnswerRecordsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAnswerRecordsPage
    extends AbstractPage<ListAnswerRecordsRequest, ListAnswerRecordsResponse, AnswerRecord, ListAnswerRecordsPage> {
        private ListAnswerRecordsPage(PageContext<ListAnswerRecordsRequest, ListAnswerRecordsResponse, AnswerRecord> context, ListAnswerRecordsResponse response) {
            super(context, (Object)response);
        }

        private static ListAnswerRecordsPage createEmptyPage() {
            return new ListAnswerRecordsPage(null, null);
        }

        protected ListAnswerRecordsPage createPage(PageContext<ListAnswerRecordsRequest, ListAnswerRecordsResponse, AnswerRecord> context, ListAnswerRecordsResponse response) {
            return new ListAnswerRecordsPage(context, response);
        }

        public ApiFuture<ListAnswerRecordsPage> createPageAsync(PageContext<ListAnswerRecordsRequest, ListAnswerRecordsResponse, AnswerRecord> context, ApiFuture<ListAnswerRecordsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAnswerRecordsPagedResponse
    extends AbstractPagedListResponse<ListAnswerRecordsRequest, ListAnswerRecordsResponse, AnswerRecord, ListAnswerRecordsPage, ListAnswerRecordsFixedSizeCollection> {
        public static ApiFuture<ListAnswerRecordsPagedResponse> createAsync(PageContext<ListAnswerRecordsRequest, ListAnswerRecordsResponse, AnswerRecord> context, ApiFuture<ListAnswerRecordsResponse> futureResponse) {
            ApiFuture<ListAnswerRecordsPage> futurePage = ListAnswerRecordsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAnswerRecordsPagedResponse((ListAnswerRecordsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAnswerRecordsPagedResponse(ListAnswerRecordsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAnswerRecordsFixedSizeCollection.createEmptyCollection());
        }
    }
}

