/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.CompleteConversationRequest;
import com.google.cloud.dialogflow.v2.Conversation;
import com.google.cloud.dialogflow.v2.ConversationsClient;
import com.google.cloud.dialogflow.v2.CreateConversationRequest;
import com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest;
import com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionResponse;
import com.google.cloud.dialogflow.v2.GenerateStatelessSummaryRequest;
import com.google.cloud.dialogflow.v2.GenerateStatelessSummaryResponse;
import com.google.cloud.dialogflow.v2.GetConversationRequest;
import com.google.cloud.dialogflow.v2.ListConversationsRequest;
import com.google.cloud.dialogflow.v2.ListConversationsResponse;
import com.google.cloud.dialogflow.v2.ListMessagesRequest;
import com.google.cloud.dialogflow.v2.ListMessagesResponse;
import com.google.cloud.dialogflow.v2.Message;
import com.google.cloud.dialogflow.v2.SearchKnowledgeRequest;
import com.google.cloud.dialogflow.v2.SearchKnowledgeResponse;
import com.google.cloud.dialogflow.v2.SuggestConversationSummaryRequest;
import com.google.cloud.dialogflow.v2.SuggestConversationSummaryResponse;
import com.google.cloud.dialogflow.v2.stub.ConversationsStub;
import com.google.cloud.dialogflow.v2.stub.GrpcConversationsStub;
import com.google.cloud.dialogflow.v2.stub.HttpJsonConversationsStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ConversationsStubSettings
extends StubSettings<ConversationsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final UnaryCallSettings<CreateConversationRequest, Conversation> createConversationSettings;
    private final PagedCallSettings<ListConversationsRequest, ListConversationsResponse, ConversationsClient.ListConversationsPagedResponse> listConversationsSettings;
    private final UnaryCallSettings<GetConversationRequest, Conversation> getConversationSettings;
    private final UnaryCallSettings<CompleteConversationRequest, Conversation> completeConversationSettings;
    private final PagedCallSettings<ListMessagesRequest, ListMessagesResponse, ConversationsClient.ListMessagesPagedResponse> listMessagesSettings;
    private final UnaryCallSettings<SuggestConversationSummaryRequest, SuggestConversationSummaryResponse> suggestConversationSummarySettings;
    private final UnaryCallSettings<GenerateStatelessSummaryRequest, GenerateStatelessSummaryResponse> generateStatelessSummarySettings;
    private final UnaryCallSettings<GenerateStatelessSuggestionRequest, GenerateStatelessSuggestionResponse> generateStatelessSuggestionSettings;
    private final UnaryCallSettings<SearchKnowledgeRequest, SearchKnowledgeResponse> searchKnowledgeSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ConversationsClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListConversationsRequest, ListConversationsResponse, Conversation> LIST_CONVERSATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListConversationsRequest, ListConversationsResponse, Conversation>(){

        public String emptyToken() {
            return "";
        }

        public ListConversationsRequest injectToken(ListConversationsRequest payload, String token) {
            return ListConversationsRequest.newBuilder((ListConversationsRequest)payload).setPageToken(token).build();
        }

        public ListConversationsRequest injectPageSize(ListConversationsRequest payload, int pageSize) {
            return ListConversationsRequest.newBuilder((ListConversationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConversationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConversationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Conversation> extractResources(ListConversationsResponse payload) {
            return payload.getConversationsList();
        }
    };
    private static final PagedListDescriptor<ListMessagesRequest, ListMessagesResponse, Message> LIST_MESSAGES_PAGE_STR_DESC = new PagedListDescriptor<ListMessagesRequest, ListMessagesResponse, Message>(){

        public String emptyToken() {
            return "";
        }

        public ListMessagesRequest injectToken(ListMessagesRequest payload, String token) {
            return ListMessagesRequest.newBuilder((ListMessagesRequest)payload).setPageToken(token).build();
        }

        public ListMessagesRequest injectPageSize(ListMessagesRequest payload, int pageSize) {
            return ListMessagesRequest.newBuilder((ListMessagesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMessagesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMessagesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Message> extractResources(ListMessagesResponse payload) {
            return payload.getMessagesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListConversationsRequest, ListConversationsResponse, ConversationsClient.ListConversationsPagedResponse> LIST_CONVERSATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListConversationsRequest, ListConversationsResponse, ConversationsClient.ListConversationsPagedResponse>(){

        public ApiFuture<ConversationsClient.ListConversationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListConversationsRequest, ListConversationsResponse> callable, ListConversationsRequest request, ApiCallContext context, ApiFuture<ListConversationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONVERSATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConversationsClient.ListConversationsPagedResponse.createAsync((PageContext<ListConversationsRequest, ListConversationsResponse, Conversation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListMessagesRequest, ListMessagesResponse, ConversationsClient.ListMessagesPagedResponse> LIST_MESSAGES_PAGE_STR_FACT = new PagedListResponseFactory<ListMessagesRequest, ListMessagesResponse, ConversationsClient.ListMessagesPagedResponse>(){

        public ApiFuture<ConversationsClient.ListMessagesPagedResponse> getFuturePagedResponse(UnaryCallable<ListMessagesRequest, ListMessagesResponse> callable, ListMessagesRequest request, ApiCallContext context, ApiFuture<ListMessagesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MESSAGES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConversationsClient.ListMessagesPagedResponse.createAsync((PageContext<ListMessagesRequest, ListMessagesResponse, Message>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ConversationsClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ConversationsClient.ListLocationsPagedResponse>(){

        public ApiFuture<ConversationsClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConversationsClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateConversationRequest, Conversation> createConversationSettings() {
        return this.createConversationSettings;
    }

    public PagedCallSettings<ListConversationsRequest, ListConversationsResponse, ConversationsClient.ListConversationsPagedResponse> listConversationsSettings() {
        return this.listConversationsSettings;
    }

    public UnaryCallSettings<GetConversationRequest, Conversation> getConversationSettings() {
        return this.getConversationSettings;
    }

    public UnaryCallSettings<CompleteConversationRequest, Conversation> completeConversationSettings() {
        return this.completeConversationSettings;
    }

    public PagedCallSettings<ListMessagesRequest, ListMessagesResponse, ConversationsClient.ListMessagesPagedResponse> listMessagesSettings() {
        return this.listMessagesSettings;
    }

    public UnaryCallSettings<SuggestConversationSummaryRequest, SuggestConversationSummaryResponse> suggestConversationSummarySettings() {
        return this.suggestConversationSummarySettings;
    }

    public UnaryCallSettings<GenerateStatelessSummaryRequest, GenerateStatelessSummaryResponse> generateStatelessSummarySettings() {
        return this.generateStatelessSummarySettings;
    }

    public UnaryCallSettings<GenerateStatelessSuggestionRequest, GenerateStatelessSuggestionResponse> generateStatelessSuggestionSettings() {
        return this.generateStatelessSuggestionSettings;
    }

    public UnaryCallSettings<SearchKnowledgeRequest, SearchKnowledgeResponse> searchKnowledgeSettings() {
        return this.searchKnowledgeSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ConversationsClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public ConversationsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcConversationsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonConversationsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ConversationsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConversationsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConversationsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ConversationsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ConversationsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createConversationSettings = settingsBuilder.createConversationSettings().build();
        this.listConversationsSettings = settingsBuilder.listConversationsSettings().build();
        this.getConversationSettings = settingsBuilder.getConversationSettings().build();
        this.completeConversationSettings = settingsBuilder.completeConversationSettings().build();
        this.listMessagesSettings = settingsBuilder.listMessagesSettings().build();
        this.suggestConversationSummarySettings = settingsBuilder.suggestConversationSummarySettings().build();
        this.generateStatelessSummarySettings = settingsBuilder.generateStatelessSummarySettings().build();
        this.generateStatelessSuggestionSettings = settingsBuilder.generateStatelessSuggestionSettings().build();
        this.searchKnowledgeSettings = settingsBuilder.searchKnowledgeSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ConversationsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateConversationRequest, Conversation> createConversationSettings;
        private final PagedCallSettings.Builder<ListConversationsRequest, ListConversationsResponse, ConversationsClient.ListConversationsPagedResponse> listConversationsSettings;
        private final UnaryCallSettings.Builder<GetConversationRequest, Conversation> getConversationSettings;
        private final UnaryCallSettings.Builder<CompleteConversationRequest, Conversation> completeConversationSettings;
        private final PagedCallSettings.Builder<ListMessagesRequest, ListMessagesResponse, ConversationsClient.ListMessagesPagedResponse> listMessagesSettings;
        private final UnaryCallSettings.Builder<SuggestConversationSummaryRequest, SuggestConversationSummaryResponse> suggestConversationSummarySettings;
        private final UnaryCallSettings.Builder<GenerateStatelessSummaryRequest, GenerateStatelessSummaryResponse> generateStatelessSummarySettings;
        private final UnaryCallSettings.Builder<GenerateStatelessSuggestionRequest, GenerateStatelessSuggestionResponse> generateStatelessSuggestionSettings;
        private final UnaryCallSettings.Builder<SearchKnowledgeRequest, SearchKnowledgeResponse> searchKnowledgeSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ConversationsClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createConversationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listConversationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONVERSATIONS_PAGE_STR_FACT);
            this.getConversationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.completeConversationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listMessagesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MESSAGES_PAGE_STR_FACT);
            this.suggestConversationSummarySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateStatelessSummarySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateStatelessSuggestionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchKnowledgeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createConversationSettings, this.listConversationsSettings, this.getConversationSettings, this.completeConversationSettings, this.listMessagesSettings, this.suggestConversationSummarySettings, this.generateStatelessSummarySettings, this.generateStatelessSuggestionSettings, this.searchKnowledgeSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ConversationsStubSettings settings) {
            super((StubSettings)settings);
            this.createConversationSettings = settings.createConversationSettings.toBuilder();
            this.listConversationsSettings = settings.listConversationsSettings.toBuilder();
            this.getConversationSettings = settings.getConversationSettings.toBuilder();
            this.completeConversationSettings = settings.completeConversationSettings.toBuilder();
            this.listMessagesSettings = settings.listMessagesSettings.toBuilder();
            this.suggestConversationSummarySettings = settings.suggestConversationSummarySettings.toBuilder();
            this.generateStatelessSummarySettings = settings.generateStatelessSummarySettings.toBuilder();
            this.generateStatelessSuggestionSettings = settings.generateStatelessSuggestionSettings.toBuilder();
            this.searchKnowledgeSettings = settings.searchKnowledgeSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createConversationSettings, this.listConversationsSettings, this.getConversationSettings, this.completeConversationSettings, this.listMessagesSettings, this.suggestConversationSummarySettings, this.generateStatelessSummarySettings, this.generateStatelessSuggestionSettings, this.searchKnowledgeSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ConversationsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ConversationsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConversationsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ConversationsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ConversationsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ConversationsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConversationsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ConversationsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createConversationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listConversationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getConversationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.completeConversationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listMessagesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.suggestConversationSummarySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.generateStatelessSummarySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.generateStatelessSuggestionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.searchKnowledgeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateConversationRequest, Conversation> createConversationSettings() {
            return this.createConversationSettings;
        }

        public PagedCallSettings.Builder<ListConversationsRequest, ListConversationsResponse, ConversationsClient.ListConversationsPagedResponse> listConversationsSettings() {
            return this.listConversationsSettings;
        }

        public UnaryCallSettings.Builder<GetConversationRequest, Conversation> getConversationSettings() {
            return this.getConversationSettings;
        }

        public UnaryCallSettings.Builder<CompleteConversationRequest, Conversation> completeConversationSettings() {
            return this.completeConversationSettings;
        }

        public PagedCallSettings.Builder<ListMessagesRequest, ListMessagesResponse, ConversationsClient.ListMessagesPagedResponse> listMessagesSettings() {
            return this.listMessagesSettings;
        }

        public UnaryCallSettings.Builder<SuggestConversationSummaryRequest, SuggestConversationSummaryResponse> suggestConversationSummarySettings() {
            return this.suggestConversationSummarySettings;
        }

        public UnaryCallSettings.Builder<GenerateStatelessSummaryRequest, GenerateStatelessSummaryResponse> generateStatelessSummarySettings() {
            return this.generateStatelessSummarySettings;
        }

        public UnaryCallSettings.Builder<GenerateStatelessSuggestionRequest, GenerateStatelessSuggestionResponse> generateStatelessSuggestionSettings() {
            return this.generateStatelessSuggestionSettings;
        }

        public UnaryCallSettings.Builder<SearchKnowledgeRequest, SearchKnowledgeResponse> searchKnowledgeSettings() {
            return this.searchKnowledgeSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ConversationsClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public ConversationsStubSettings build() throws IOException {
            return new ConversationsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

