/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.CreateEnvironmentRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteEnvironmentRequest;
import com.google.cloud.dialogflow.v2beta1.Environment;
import com.google.cloud.dialogflow.v2beta1.EnvironmentHistory;
import com.google.cloud.dialogflow.v2beta1.EnvironmentsClient;
import com.google.cloud.dialogflow.v2beta1.GetEnvironmentHistoryRequest;
import com.google.cloud.dialogflow.v2beta1.GetEnvironmentRequest;
import com.google.cloud.dialogflow.v2beta1.ListEnvironmentsRequest;
import com.google.cloud.dialogflow.v2beta1.ListEnvironmentsResponse;
import com.google.cloud.dialogflow.v2beta1.UpdateEnvironmentRequest;
import com.google.cloud.dialogflow.v2beta1.stub.EnvironmentsStub;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcEnvironmentsStub;
import com.google.cloud.dialogflow.v2beta1.stub.HttpJsonEnvironmentsStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class EnvironmentsStubSettings
extends StubSettings<EnvironmentsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final PagedCallSettings<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings;
    private final UnaryCallSettings<GetEnvironmentRequest, Environment> getEnvironmentSettings;
    private final UnaryCallSettings<CreateEnvironmentRequest, Environment> createEnvironmentSettings;
    private final UnaryCallSettings<UpdateEnvironmentRequest, Environment> updateEnvironmentSettings;
    private final UnaryCallSettings<DeleteEnvironmentRequest, Empty> deleteEnvironmentSettings;
    private final PagedCallSettings<GetEnvironmentHistoryRequest, EnvironmentHistory, EnvironmentsClient.GetEnvironmentHistoryPagedResponse> getEnvironmentHistorySettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, EnvironmentsClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> LIST_ENVIRONMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment>(){

        public String emptyToken() {
            return "";
        }

        public ListEnvironmentsRequest injectToken(ListEnvironmentsRequest payload, String token) {
            return ListEnvironmentsRequest.newBuilder((ListEnvironmentsRequest)payload).setPageToken(token).build();
        }

        public ListEnvironmentsRequest injectPageSize(ListEnvironmentsRequest payload, int pageSize) {
            return ListEnvironmentsRequest.newBuilder((ListEnvironmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEnvironmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEnvironmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Environment> extractResources(ListEnvironmentsResponse payload) {
            return payload.getEnvironmentsList();
        }
    };
    private static final PagedListDescriptor<GetEnvironmentHistoryRequest, EnvironmentHistory, EnvironmentHistory.Entry> GET_ENVIRONMENT_HISTORY_PAGE_STR_DESC = new PagedListDescriptor<GetEnvironmentHistoryRequest, EnvironmentHistory, EnvironmentHistory.Entry>(){

        public String emptyToken() {
            return "";
        }

        public GetEnvironmentHistoryRequest injectToken(GetEnvironmentHistoryRequest payload, String token) {
            return GetEnvironmentHistoryRequest.newBuilder((GetEnvironmentHistoryRequest)payload).setPageToken(token).build();
        }

        public GetEnvironmentHistoryRequest injectPageSize(GetEnvironmentHistoryRequest payload, int pageSize) {
            return GetEnvironmentHistoryRequest.newBuilder((GetEnvironmentHistoryRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(GetEnvironmentHistoryRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(EnvironmentHistory payload) {
            return payload.getNextPageToken();
        }

        public Iterable<EnvironmentHistory.Entry> extractResources(EnvironmentHistory payload) {
            return payload.getEntriesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> LIST_ENVIRONMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse>(){

        public ApiFuture<EnvironmentsClient.ListEnvironmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> callable, ListEnvironmentsRequest request, ApiCallContext context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENVIRONMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EnvironmentsClient.ListEnvironmentsPagedResponse.createAsync((PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<GetEnvironmentHistoryRequest, EnvironmentHistory, EnvironmentsClient.GetEnvironmentHistoryPagedResponse> GET_ENVIRONMENT_HISTORY_PAGE_STR_FACT = new PagedListResponseFactory<GetEnvironmentHistoryRequest, EnvironmentHistory, EnvironmentsClient.GetEnvironmentHistoryPagedResponse>(){

        public ApiFuture<EnvironmentsClient.GetEnvironmentHistoryPagedResponse> getFuturePagedResponse(UnaryCallable<GetEnvironmentHistoryRequest, EnvironmentHistory> callable, GetEnvironmentHistoryRequest request, ApiCallContext context, ApiFuture<EnvironmentHistory> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)GET_ENVIRONMENT_HISTORY_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EnvironmentsClient.GetEnvironmentHistoryPagedResponse.createAsync((PageContext<GetEnvironmentHistoryRequest, EnvironmentHistory, EnvironmentHistory.Entry>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, EnvironmentsClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, EnvironmentsClient.ListLocationsPagedResponse>(){

        public ApiFuture<EnvironmentsClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EnvironmentsClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings() {
        return this.listEnvironmentsSettings;
    }

    public UnaryCallSettings<GetEnvironmentRequest, Environment> getEnvironmentSettings() {
        return this.getEnvironmentSettings;
    }

    public UnaryCallSettings<CreateEnvironmentRequest, Environment> createEnvironmentSettings() {
        return this.createEnvironmentSettings;
    }

    public UnaryCallSettings<UpdateEnvironmentRequest, Environment> updateEnvironmentSettings() {
        return this.updateEnvironmentSettings;
    }

    public UnaryCallSettings<DeleteEnvironmentRequest, Empty> deleteEnvironmentSettings() {
        return this.deleteEnvironmentSettings;
    }

    public PagedCallSettings<GetEnvironmentHistoryRequest, EnvironmentHistory, EnvironmentsClient.GetEnvironmentHistoryPagedResponse> getEnvironmentHistorySettings() {
        return this.getEnvironmentHistorySettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, EnvironmentsClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public EnvironmentsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEnvironmentsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonEnvironmentsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EnvironmentsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EnvironmentsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EnvironmentsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return EnvironmentsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EnvironmentsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listEnvironmentsSettings = settingsBuilder.listEnvironmentsSettings().build();
        this.getEnvironmentSettings = settingsBuilder.getEnvironmentSettings().build();
        this.createEnvironmentSettings = settingsBuilder.createEnvironmentSettings().build();
        this.updateEnvironmentSettings = settingsBuilder.updateEnvironmentSettings().build();
        this.deleteEnvironmentSettings = settingsBuilder.deleteEnvironmentSettings().build();
        this.getEnvironmentHistorySettings = settingsBuilder.getEnvironmentHistorySettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EnvironmentsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings;
        private final UnaryCallSettings.Builder<GetEnvironmentRequest, Environment> getEnvironmentSettings;
        private final UnaryCallSettings.Builder<CreateEnvironmentRequest, Environment> createEnvironmentSettings;
        private final UnaryCallSettings.Builder<UpdateEnvironmentRequest, Environment> updateEnvironmentSettings;
        private final UnaryCallSettings.Builder<DeleteEnvironmentRequest, Empty> deleteEnvironmentSettings;
        private final PagedCallSettings.Builder<GetEnvironmentHistoryRequest, EnvironmentHistory, EnvironmentsClient.GetEnvironmentHistoryPagedResponse> getEnvironmentHistorySettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, EnvironmentsClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listEnvironmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENVIRONMENTS_PAGE_STR_FACT);
            this.getEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getEnvironmentHistorySettings = PagedCallSettings.newBuilder((PagedListResponseFactory)GET_ENVIRONMENT_HISTORY_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listEnvironmentsSettings, this.getEnvironmentSettings, this.createEnvironmentSettings, this.updateEnvironmentSettings, this.deleteEnvironmentSettings, this.getEnvironmentHistorySettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(EnvironmentsStubSettings settings) {
            super((StubSettings)settings);
            this.listEnvironmentsSettings = settings.listEnvironmentsSettings.toBuilder();
            this.getEnvironmentSettings = settings.getEnvironmentSettings.toBuilder();
            this.createEnvironmentSettings = settings.createEnvironmentSettings.toBuilder();
            this.updateEnvironmentSettings = settings.updateEnvironmentSettings.toBuilder();
            this.deleteEnvironmentSettings = settings.deleteEnvironmentSettings.toBuilder();
            this.getEnvironmentHistorySettings = settings.getEnvironmentHistorySettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listEnvironmentsSettings, this.getEnvironmentSettings, this.createEnvironmentSettings, this.updateEnvironmentSettings, this.deleteEnvironmentSettings, this.getEnvironmentHistorySettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EnvironmentsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EnvironmentsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EnvironmentsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EnvironmentsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)EnvironmentsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)EnvironmentsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EnvironmentsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EnvironmentsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listEnvironmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getEnvironmentHistorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings() {
            return this.listEnvironmentsSettings;
        }

        public UnaryCallSettings.Builder<GetEnvironmentRequest, Environment> getEnvironmentSettings() {
            return this.getEnvironmentSettings;
        }

        public UnaryCallSettings.Builder<CreateEnvironmentRequest, Environment> createEnvironmentSettings() {
            return this.createEnvironmentSettings;
        }

        public UnaryCallSettings.Builder<UpdateEnvironmentRequest, Environment> updateEnvironmentSettings() {
            return this.updateEnvironmentSettings;
        }

        public UnaryCallSettings.Builder<DeleteEnvironmentRequest, Empty> deleteEnvironmentSettings() {
            return this.deleteEnvironmentSettings;
        }

        public PagedCallSettings.Builder<GetEnvironmentHistoryRequest, EnvironmentHistory, EnvironmentsClient.GetEnvironmentHistoryPagedResponse> getEnvironmentHistorySettings() {
            return this.getEnvironmentHistorySettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, EnvironmentsClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public EnvironmentsStubSettings build() throws IOException {
            return new EnvironmentsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

